/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.xpath;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.XPath;

public class ValueOfTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"/root", "//author", "//author/@name", "/root/author[1]", "/root/author[1]/@name", "/root/author[2]", "/root/author[2]/@name", "/root/author[3]", "/root/author[3]/@name", "name()", "name(.)", "name(..)", "name(child::node())", "name(parent::*)", "name(../*)", "name(../child::node())", "local-name()", "local-name(..)", "local-name(parent::*)", "local-name(../*)", "parent::*", "name(/.)", "name(/child::node())", "name(/*)", ".", "..", "../*", "../child::node()", "/.", "/*", "*", "/child::node()"};

    public static void main(String[] args) {
        TestRunner.run(ValueOfTest.class);
    }

    public void testXPaths() throws Exception {
        Metaset root = this.document.getRootElement();
        List<Metaset> children = root.elements("author");
        Metaset child1 = children.get(0);
        this.testXPath(this.document);
        this.testXPath(root);
        this.testXPath(child1);
    }

    protected void testXPath(Node node) throws Exception {
        this.log("Testing XPath on: " + node);
        this.log("===============================");
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(node, paths[i]);
            ++i;
        }
    }

    protected void testXPath(Node node, String xpathExpr) throws Exception {
        try {
            XPath xpath = node.createXPath(xpathExpr);
            String value = xpath.valueOf(node);
            this.log("valueOf: " + xpathExpr + " is: " + value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ValueOfTest.assertTrue((String)("Failed with exception: " + e), (boolean)false);
        }
    }
}

