/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom.xpath;

import java.util.ArrayList;
import org.act.xservices.rt.xom.InvalidXPathException;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.XPathException;
import org.act.xservices.rt.xom.xpath.DocumentNavigator;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.jaxen.saxpath.SAXPathException;

public class XPathPattern
implements org.act.xservices.rt.xom.rule.Pattern {
    private String text;
    private Pattern pattern;
    private Context context;

    public XPathPattern(Pattern pattern) {
        this.pattern = pattern;
        this.text = pattern.getText();
        this.context = new Context(this.getContextSupport());
    }

    public XPathPattern(String text) {
        this.text = text;
        this.context = new Context(this.getContextSupport());
        try {
            this.pattern = PatternParser.parse((String)text);
        }
        catch (SAXPathException e) {
            throw new InvalidXPathException(text, e.getMessage());
        }
        catch (RuntimeException e) {
            throw new InvalidXPathException(text);
        }
    }

    public boolean matches(Node node) {
        try {
            ArrayList<Node> list = new ArrayList<Node>(1);
            list.add(node);
            this.context.setNodeSet(list);
            return this.pattern.matches((Object)node, this.context);
        }
        catch (JaxenException e) {
            this.handleJaxenException(e);
            return false;
        }
    }

    public String getText() {
        return this.text;
    }

    public double getPriority() {
        return this.pattern.getPriority();
    }

    public org.act.xservices.rt.xom.rule.Pattern[] getUnionPatterns() {
        Pattern[] patterns = this.pattern.getUnionPatterns();
        if (patterns != null) {
            int size = patterns.length;
            org.act.xservices.rt.xom.rule.Pattern[] answer = new XPathPattern[size];
            int i = 0;
            while (i < size) {
                answer[i] = new XPathPattern(patterns[i]);
                ++i;
            }
            return answer;
        }
        return null;
    }

    public NodeType getMatchType() {
        return NodeType.byCode(this.pattern.getMatchType());
    }

    public String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public void setVariableContext(VariableContext variableContext) {
        this.context.getContextSupport().setVariableContext(variableContext);
    }

    public String toString() {
        return "[XPathPattern: text: " + this.text + " Pattern: " + this.pattern + "]";
    }

    protected ContextSupport getContextSupport() {
        return new ContextSupport((NamespaceContext)new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), DocumentNavigator.getInstance());
    }

    protected void handleJaxenException(JaxenException exception) throws XPathException {
        throw new XPathException(this.text, (Exception)((Object)exception));
    }
}

