/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.net.URI;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFSVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFVocabularyAdapter;
import org.semanticweb.owl.validation.OWLValidationConstants;
import uk.ac.man.cs.img.owl.fixing.Fixer;

public class Fixer
implements OWLValidationConstants {
    private static OWLVocabularyAdapter owlV = OWLVocabularyAdapter.INSTANCE;
    private static RDFVocabularyAdapter rdfV = RDFVocabularyAdapter.INSTANCE;
    private static RDFSVocabularyAdapter rdfsV = RDFSVocabularyAdapter.INSTANCE;
    private static String DC = "http://purl.org/dc/elements/1.1";

    public static void main(String[] args) {
        int c;
        BasicConfigurator.configure();
        LongOpt[] longopts = new LongOpt[10];
        longopts[0] = new LongOpt("help", 0, null, 63);
        longopts[1] = new LongOpt("output", 1, null, 111);
        longopts[2] = new LongOpt("quiet", 0, null, 113);
        longopts[3] = new LongOpt("report", 0, null, 114);
        longopts[4] = new LongOpt("strategy", 0, null, 115);
        longopts[5] = new LongOpt("verbose", 0, null, 118);
        Getopt g = new Getopt("", args, "?o:qrs:v", longopts);
        String output = null;
        boolean report = false;
        boolean quiet = false;
        boolean verbose = false;
        int strat = -1;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 63: {
                    Fixer.usage();
                    System.exit(0);
                }
                case 115: {
                    strat = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 113: {
                    quiet = true;
                    break;
                }
                case 118: {
                    verbose = true;
                    break;
                }
                case 114: {
                    report = true;
                    break;
                }
                case 111: {
                    output = g.getOptarg();
                }
            }
        }
        int i = g.getOptind();
        URI uri = null;
        try {
            if (args.length > i) {
                uri = new URI(args[i]);
            } else {
                System.err.println("No URI specified!");
                Fixer.usage();
                System.exit(1);
            }
            uk.ac.man.cs.img.owl.fixing.Fixer fixer = new uk.ac.man.cs.img.owl.fixing.Fixer();
            if (report) {
                fixer.setReportWriter(new PrintWriter(System.out, true));
            }
            if (!quiet) {
                fixer.setMessageWriter(new PrintWriter(System.out, true));
            }
            if (strat > -1) {
                Fixer.Strategy strategy = fixer.newStrategy(uk.ac.man.cs.img.owl.fixing.Fixer.options[strat]);
                fixer.setStrategy(strategy);
                int result = fixer.applyStrategy(uri, output);
                if (result == 0 || result == 1) {
                    System.exit(result);
                }
            } else {
                for (int opti = 0; opti < uk.ac.man.cs.img.owl.fixing.Fixer.options.length; ++opti) {
                    Fixer.Strategy strategy = fixer.newStrategy(uk.ac.man.cs.img.owl.fixing.Fixer.options[opti]);
                    fixer.setStrategy(strategy);
                    int result = fixer.applyStrategy(uri, output);
                    if (result != 0) continue;
                    if (verbose) {
                        System.out.print(uri);
                        System.out.print(",");
                        System.out.print("1");
                        System.out.print(",");
                        System.out.print(fixer.getFixes().size());
                        System.out.print(",");
                        System.out.print(strategy.fixOthers ? "1" : "0");
                        System.out.print(",");
                        System.out.print(strategy.fixDC ? "1" : "0");
                        System.out.print(",");
                        System.out.print(strategy.laxSchema ? "1" : "0");
                        System.out.print(",");
                        System.out.print(strategy.laxSameAs ? "1" : "0");
                        System.out.println();
                    }
                    System.exit(result);
                }
            }
            if (verbose) {
                System.out.print(uri);
                System.out.print(",");
                System.out.print("0");
                System.out.println();
            }
            fixer.message("***** FIX FAILED *****");
            System.exit(1);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.out.print(uri);
            System.out.print(",0,0,0,0,0,0,1");
            System.out.println();
            System.exit(1);
        }
    }

    public static void usage() {
        System.out.println("usage: Fixer [options] URI");
        System.out.println("\t--help -? \n\t\tPrint this message");
        System.out.println("\t--lax -l \n\t\tIf validation fails, try and parse with lax options.");
        System.out.println("\t--fix -f \n\t\tIf validation fails, try and fix and then check the fixed ontology.");
        System.out.println("\t--output -o \n\t\tWrite fixed ontology to file");
    }
}

