/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.Parser;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.util.PropertyBasedURIMapper;
import org.semanticweb.owl.validation.OWLValidationConstants;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;
import uk.ac.man.cs.img.owl.validation.ConstructChecker;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class Processor
implements OWLValidationConstants {
    public static void main(String[] args) {
        int c;
        OWLRDFParser rdfParser = null;
        Parser parser = null;
        OWLOntology onto = null;
        org.semanticweb.owl.io.abstract_syntax.Renderer renderer = null;
        LongOpt[] longopts = new LongOpt[11];
        boolean warnings = false;
        boolean constructs = false;
        boolean noImports = false;
        String uriMapping = "";
        BasicConfigurator.configure();
        longopts[0] = new LongOpt("help", 0, null, 63);
        longopts[1] = new LongOpt("abstract", 0, null, 97);
        longopts[2] = new LongOpt("tptp", 0, null, 116);
        longopts[3] = new LongOpt("validate", 2, null, 118);
        longopts[4] = new LongOpt("warn", 0, null, 119);
        longopts[5] = new LongOpt("renderer", 1, null, 114);
        longopts[6] = new LongOpt("impl", 1, null, 105);
        longopts[7] = new LongOpt("parser", 1, null, 112);
        longopts[8] = new LongOpt("noimports", 1, null, 110);
        longopts[9] = new LongOpt("constructs", 2, null, 99);
        longopts[10] = new LongOpt("uriMapping", 1, null, 117);
        Getopt g = new Getopt("", args, "?acwtv::r:i:p:nu:", longopts);
        int validation = -1;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 63: {
                    Processor.usage();
                    System.exit(0);
                }
                case 110: {
                    noImports = true;
                    break;
                }
                case 97: {
                    renderer = new org.semanticweb.owl.io.abstract_syntax.Renderer();
                    break;
                }
                case 99: {
                    constructs = true;
                    break;
                }
                case 116: {
                    renderer = new Renderer();
                    break;
                }
                case 114: {
                    String renderingClass = g.getOptarg();
                    try {
                        renderer = (org.semanticweb.owl.io.Renderer)ClassLoader.getSystemClassLoader().loadClass(renderingClass).newInstance();
                    }
                    catch (Exception ex) {
                        System.err.println("Cannot create renderer " + renderingClass + "\n" + ex.getMessage());
                        Processor.usage();
                        System.exit(0);
                    }
                    break;
                }
                case 117: {
                    uriMapping = g.getOptarg();
                    break;
                }
                case 105: {
                    String implementationClass = g.getOptarg();
                    System.setProperty("org.semanticweb.owl.util.OWLConnection", implementationClass);
                    break;
                }
                case 112: {
                    String parsingClass = g.getOptarg();
                    try {
                        parser = (Parser)ClassLoader.getSystemClassLoader().loadClass(parsingClass).newInstance();
                    }
                    catch (Exception ex) {
                        System.err.println("Cannot create parser " + parsingClass + "\n" + ex.getMessage());
                        Processor.usage();
                        System.exit(0);
                    }
                    break;
                }
                case 119: {
                    warnings = true;
                    break;
                }
                case 118: {
                    String arg = g.getOptarg();
                    if (arg == null || arg.equals("dl")) {
                        validation = 1;
                        break;
                    }
                    if (arg.equals("lite")) {
                        validation = 0;
                        break;
                    }
                    if (arg.equals("full")) {
                        validation = 3;
                        break;
                    }
                    Processor.usage();
                    System.exit(0);
                }
            }
        }
        int i = g.getOptind();
        try {
            URI uri = null;
            if (args.length > i) {
                uri = new URI(args[i]);
            } else {
                System.out.println("No URI specified!");
                Processor.usage();
                System.exit(0);
            }
            PropertyBasedURIMapper mapper = null;
            if (!uriMapping.equals("")) {
                try {
                    Properties props = new Properties();
                    props.load(new FileInputStream(uriMapping));
                    mapper = new PropertyBasedURIMapper(props);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (parser == null) {
                rdfParser = new OWLRDFParser();
                if (validation == 0 || validation == 1 || validation == 3) {
                    SpeciesValidator sv = new SpeciesValidator();
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("uriMapper", mapper);
                    if (noImports) {
                        options.put("ignoreSchemaImports", new Boolean(true));
                    }
                    sv.setOptions(options);
                    if (validation == 0) {
                        System.out.println("OWL-Lite:\t" + (sv.isOWLLite(uri) ? "YES" : "NO"));
                    } else if (validation == 1) {
                        System.out.println("OWL-DL  :\t" + (sv.isOWLDL(uri) ? "YES" : "NO"));
                    } else if (validation == 3) {
                        System.out.println("OWL-Full  :\t" + (sv.isOWLFull(uri) ? "YES" : "NO"));
                    }
                    System.exit(0);
                }
                if (warnings) {
                    OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                        public void owlFullConstruct(int code, String message) throws SAXException {
                        }

                        public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                        }

                        public void error(String message) throws SAXException {
                            throw new SAXException(message.toString());
                        }

                        public void warning(String message) throws SAXException {
                            System.out.println("WARNING: " + message);
                        }
                    };
                    rdfParser.setOWLRDFErrorHandler(handler);
                }
                parser = rdfParser;
            }
            parser.setConnection(OWLManager.getOWLConnection());
            if (mapper != null) {
                HashMap<String, PropertyBasedURIMapper> options = new HashMap<String, PropertyBasedURIMapper>();
                options.put("uriMapper", mapper);
                parser.setOptions(options);
            }
            onto = parser.parseOntology(uri);
            if (constructs) {
                System.out.println("Constructs Used:");
                System.out.println("================");
                ConstructChecker cc = new ConstructChecker();
                Iterator it = ConstructChecker.used((Set)cc.constructsUsed(onto)).iterator();
                while (it.hasNext()) {
                    System.out.println("\t" + it.next());
                }
            }
            if (renderer != null) {
                StringWriter writer = new StringWriter();
                renderer.renderOntology(onto, (Writer)writer);
                System.out.println(((Object)writer).toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.out.println("usage: Processor [options] URI");
        System.out.println("options are:");
        System.out.println("\t--abstract -a \n\t\tProduce OWL Abstract Syntax");
        System.out.println("\t--tptp -t \n\t\tProduce TPTP");
        System.out.println("\t--warn -w \n\t\tReport warnings & errors");
        System.out.println("\t--renderer=className -r \n\t\tUse the given class for output.");
        System.out.println("\t--parser=className -p \n\t\tUse the given class for parsing (validation and warning may not work).");
        System.out.println("\t--impl=className -i \n\t\tUse the given class as the default implementation of OWLConnection.");
        System.out.println("\t--validate[=lite|dl] -v \n\t\tValidate. If no level is given, validates as DL.");
        System.out.println("\t--help -? \n\t\tPrint this message");
    }
}

