/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.validation.OWLValidationConstants;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.util.Errors;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class Validator
implements OWLValidationConstants {
    private URI uri;
    private boolean result;
    private int level;
    private Set codes;

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean getResult() {
        return this.result;
    }

    public Set getCodes() {
        return this.codes;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.uri);
        for (int i = 0; i < Errors.allCodes.length; ++i) {
            sb.append(",");
            boolean found = false;
            Iterator it = this.getCodes().iterator();
            while (it.hasNext()) {
                int code = (Integer)it.next();
                if (code != Errors.allCodes[i]) continue;
                found = true;
            }
            sb.append(found ? "1" : "0");
        }
        return sb.toString();
    }

    public String getHeaders() {
        StringBuffer sb = new StringBuffer();
        sb.append("URI");
        for (int i = 0; i < Errors.allCodes.length; ++i) {
            sb.append(",");
            sb.append(Errors.pretty(Errors.allCodes[i]));
        }
        return sb.toString();
    }

    public void validate() throws OWLException {
        this.result = false;
        this.codes = new TreeSet();
        SpeciesValidator sv = new SpeciesValidator();
        SpeciesValidatorReporter rep = new SpeciesValidatorReporter(){

            public void message(String str) {
            }

            public void explain(int l, int c, String str) {
                if (c == 1001) {
                    System.out.println(str);
                }
                if (c == 2001) {
                    System.out.println(str);
                }
                if (l > Validator.this.level) {
                    Validator.this.codes.add(new Integer(c));
                }
            }

            public void ontology(OWLOntology ontology) {
            }

            public void done(String level) {
            }
        };
        sv.setReporter(rep);
        if (this.level == 0) {
            this.result = sv.isOWLLite(this.uri);
        } else if (this.level == 1) {
            this.result = sv.isOWLDL(this.uri);
        } else if (this.level == 3) {
            this.result = sv.isOWLFull(this.uri);
        }
    }

    public static void main(String[] args) {
        int c;
        Object parser = null;
        Object onto = null;
        Object renderer = null;
        boolean verbose = false;
        int level = 3;
        BasicConfigurator.configure();
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 63), new LongOpt("output", 1, null, 111), new LongOpt("level", 1, null, 108), new LongOpt("verbose", 0, null, 118), new LongOpt("urls", 1, null, 117), new LongOpt("check", 0, null, 99)};
        Getopt g = new Getopt("", args, "?o:l:u:vc", longopts);
        String output = null;
        String urls = null;
        boolean justCheckURLs = false;
        int validation = -1;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 63: {
                    Validator.usage();
                    System.exit(1);
                }
                case 99: {
                    justCheckURLs = true;
                }
                case 111: {
                    output = g.getOptarg();
                    break;
                }
                case 117: {
                    urls = g.getOptarg();
                    break;
                }
                case 108: {
                    String arg = g.getOptarg();
                    if (arg == null || arg.equals("dl")) {
                        level = 1;
                        break;
                    }
                    if (arg.equals("lite")) {
                        level = 0;
                        break;
                    }
                    if (arg.equals("full")) {
                        level = 3;
                        break;
                    }
                    Validator.usage();
                    System.exit(0);
                    break;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        int i = g.getOptind();
        try {
            if (urls == null) {
                URI uri = null;
                if (args.length > i) {
                    uri = new URI(args[i]);
                } else {
                    System.err.println("No URI specified!");
                    Validator.usage();
                    System.exit(1);
                }
                Validator v = new Validator();
                v.setURI(uri);
                v.setLevel(level);
                v.validate();
                PrintWriter out = null;
                out = output != null ? new PrintWriter(new FileWriter(output)) : new PrintWriter(System.out);
                if (verbose) {
                    out.println(uri);
                    Iterator it = v.getCodes().iterator();
                    while (it.hasNext()) {
                        int code = (Integer)it.next();
                        out.println(Errors.pretty(code));
                    }
                } else {
                    out.print(v.getSummary());
                }
                out.println();
                out.flush();
                if (v.getResult()) {
                    System.exit(0);
                } else {
                    System.exit(1);
                }
            } else {
                PrintWriter out = null;
                out = output != null ? new PrintWriter(new FileWriter(output, true)) : new PrintWriter(System.out);
                Validator v = new Validator();
                v.setLevel(level);
                out.println(v.getHeaders());
                BufferedReader br = new BufferedReader(new FileReader(urls));
                String f = null;
                while ((f = br.readLine()) != null) {
                    if (f.startsWith("#")) continue;
                    try {
                        URI uri = new URI(f);
                        System.err.println(uri);
                        if (justCheckURLs) continue;
                        v.setURI(uri);
                        v.validate();
                        out.println(v.getSummary());
                    }
                    catch (Exception ex) {
                        out.println(f + "," + ex.getMessage());
                    }
                }
                out.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.out.println("usage: Validator [options] URI");
        System.out.println("options are:");
        System.out.println("\t--output=file -p \n\t\tOutput File");
        System.out.println("\t--help -? \n\t\tPrint this message");
        System.out.println("\t--level=(dl|lite|full) -l \n\t\tValidation Level");
    }

    public static String level(int l) {
        switch (l) {
            case 0: {
                return "Lite";
            }
            case 1: {
                return "DL  ";
            }
            case 3: {
                return "Full";
            }
        }
        return "----";
    }
}

