/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;

public class ABox {
    public static boolean DEBUG = false;
    static final Individual TOP_IND = new Individual(ATermUtils.TOP);
    static final Individual BOTTOM_IND = new Individual(ATermUtils.BOTTOM);
    static final Individual DUMMY_IND = new Individual(ATermUtils.makeTermAppl("_DUMMY_"));
    protected static final String ANON_PREFIX = "anon";
    protected int anonCount = 0;
    public long satisfiabilityCount = 0L;
    public long consistencyCount = 0L;
    public int treeDepth = 0;
    protected DatatypeReasoner dtReasoner;
    protected Map nodes;
    protected List nodeList;
    boolean changed = false;
    private boolean doExplanation;
    protected Map cache;
    private ABox pseudoModel;
    private ABox lastCompletion;
    private boolean isComplete = false;
    private Clash clash;
    private int branch;
    private List branches;
    List toBeMerged;
    Map disjBranchStats;
    ABox sourceABox;
    private boolean initialized = false;
    private KnowledgeBase kb;

    public ABox() {
        this(new KnowledgeBase());
    }

    public ABox(KnowledgeBase kb) {
        this.kb = kb;
        this.nodes = new HashMap();
        this.nodeList = new ArrayList();
        this.clash = null;
        this.doExplanation = false;
        this.dtReasoner = new DatatypeReasoner();
        this.clearCaches(true);
        this.branch = 0;
        this.branches = new ArrayList();
        this.disjBranchStats = new HashMap();
        this.toBeMerged = new ArrayList();
    }

    public ABox(ABox abox) {
        this(abox, null, true);
    }

    public ABox(ABox abox, ATermAppl extraIndividual, boolean copyIndividuals) {
        Object copy;
        this.kb = abox.kb;
        Timer timer = this.kb.timers.startTimer("cloneABox");
        this.initialized = abox.initialized;
        this.changed = abox.changed;
        this.anonCount = abox.anonCount;
        this.cache = abox.cache;
        this.clash = abox.clash;
        this.dtReasoner = abox.dtReasoner;
        this.doExplanation = abox.doExplanation;
        this.disjBranchStats = abox.disjBranchStats;
        this.toBeMerged = abox.toBeMerged;
        int extra = extraIndividual == null ? 0 : 1;
        int nodeCount = abox.nodes.size() + extra;
        this.nodes = new HashMap(nodeCount);
        this.nodeList = new ArrayList(nodeCount);
        if (extraIndividual != null) {
            Individual n = new Individual(extraIndividual, this, Individual.BLOCKABLE);
            n.setConceptRoot(true);
            n.branch = -1;
            n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this.nodes.put(extraIndividual, n);
            this.nodeList.add(extraIndividual);
            this.applyUC(n);
            if (PelletOptions.COPY_ON_WRITE) {
                this.sourceABox = abox;
            }
        }
        if (copyIndividuals) {
            if (this.sourceABox == null) {
                for (int i = 0; i < nodeCount - extra; ++i) {
                    ATerm x = (ATerm)abox.nodeList.get(i);
                    Node node = abox.getNode(x);
                    copy = node.copyTo(this);
                    this.nodes.put(x, copy);
                    this.nodeList.add(x);
                }
                Iterator i = this.nodes.values().iterator();
                while (i.hasNext()) {
                    Node node = (Node)i.next();
                    node.updateNodeReferences();
                }
            }
        } else {
            this.sourceABox = null;
        }
        this.branch = abox.branch;
        this.branches = new ArrayList(abox.branches.size());
        int n = abox.branches.size();
        for (int i = 0; i < n; ++i) {
            Branch branch = (Branch)abox.branches.get(i);
            if (this.sourceABox == null) {
                copy = branch.copyTo(this);
                ((Branch)copy).nodeCount = branch.nodeCount + extra;
            } else {
                copy = branch;
            }
            this.branches.add(copy);
        }
        timer.stop();
    }

    public ABox copy() {
        return new ABox(this);
    }

    public ABox copy(ATermAppl extraIndividual, boolean copyIndividuals) {
        return new ABox(this, extraIndividual, copyIndividuals);
    }

    public void copyOnWrite() {
        if (this.sourceABox == null) {
            return;
        }
        Timer t = this.kb.timers.startTimer("copyOnWrite");
        ArrayList currentNodeList = new ArrayList(this.nodeList);
        int currentSize = currentNodeList.size();
        this.nodeList = new ArrayList();
        this.nodeList.add(currentNodeList.get(0));
        int nodeCount = this.sourceABox.nodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            ATerm x = (ATerm)this.sourceABox.nodeList.get(i);
            Node node = this.sourceABox.getNode(x);
            Node copyNode = node.copyTo(this);
            this.nodes.put(x, copyNode);
            this.nodeList.add(x);
        }
        if (currentSize > 1) {
            this.nodeList.addAll(currentNodeList.subList(1, currentSize));
        }
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (!this.sourceABox.nodes.containsKey(node.getName())) continue;
            node.updateNodeReferences();
        }
        int n = this.branches.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Branch branch = (Branch)this.branches.get(i2);
            Branch copy = branch.copyTo(this);
            this.branches.set(i2, copy);
            if (i2 < this.sourceABox.getBranches().size()) continue;
            copy.nodeCount += this.sourceABox.nodes.size();
        }
        t.stop();
        this.sourceABox = null;
    }

    public void clearCaches(boolean clearSatCache) {
        this.pseudoModel = null;
        this.lastCompletion = null;
        if (clearSatCache) {
            this.cache = new HashMap();
        }
    }

    Bool getCachedSat(ATermAppl c) {
        CachedNode cached = (CachedNode)this.cache.get(c);
        return cached == null ? Bool.UNKNOWN : Bool.create(!cached.isBottom());
    }

    CachedNode getCached(ATermAppl c) {
        return (CachedNode)this.cache.get(c);
    }

    boolean cacheUnsatConcept(ATermAppl c) {
        if (this.cache.containsKey(c)) {
            CachedNode cached = this.getCached(c);
            if (!cached.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + c);
            }
            return false;
        }
        ATermAppl notC = ATermUtils.negate(c);
        this.cacheConcept(c, BOTTOM_IND, DependencySet.INDEPENDENT);
        this.cacheConcept(notC, TOP_IND, DependencySet.INDEPENDENT);
        return true;
    }

    boolean cacheSatConcept(ATermAppl c) {
        if (this.cache.containsKey(c)) {
            CachedNode cached = this.getCached(c);
            if (cached.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + c);
            }
            return false;
        }
        this.cacheConcept(c, DUMMY_IND, DependencySet.INDEPENDENT);
        return true;
    }

    void cacheConcept(ATermAppl c, Individual ind, DependencySet ds) {
        this.cache.put(c, new CachedNode(ind, ds));
    }

    private void cache(ATermAppl x, ATermAppl c, boolean isConsistent) {
        if (PelletOptions.USE_CACHING && x != null && c != null && ATermUtils.isPrimitiveOrNegated(c)) {
            if (isConsistent) {
                ABox lastABox = this.lastCompletion;
                Individual rootNode = lastABox.getIndividual((ATerm)x);
                DependencySet ds = rootNode.getMergeDependency();
                rootNode = (Individual)rootNode.getSame();
                if (this.kb.getExpressivity().hasNominal()) {
                    this.collectTransitivePropertyValues(rootNode);
                }
                rootNode = (Individual)rootNode.copy();
                if (DEBUG) {
                    System.out.println("Cache " + rootNode.debugString());
                }
                this.cacheConcept(c, rootNode, ds);
            } else {
                if (DEBUG) {
                    System.out.println(c + " is not satisfiable");
                    System.out.println(ATermUtils.negate(c) + " is TOP");
                }
                this.cacheUnsatConcept(c);
            }
        }
    }

    Bool mergable(Individual root1, Individual root2, boolean independent) {
        Role role;
        Individual[] roots = new Individual[]{root1, root2};
        if (roots[0] == BOTTOM_IND || roots[1] == BOTTOM_IND) {
            if (DEBUG) {
                System.out.println("(1) true ");
            }
            return Bool.FALSE;
        }
        if (roots[0] == TOP_IND && roots[1] != BOTTOM_IND) {
            if (DEBUG) {
                System.out.println("(2) false ");
            }
            return Bool.TRUE;
        }
        if (roots[1] == TOP_IND && roots[0] != BOTTOM_IND) {
            if (DEBUG) {
                System.out.println("(3) false ");
            }
            return Bool.TRUE;
        }
        if (roots[0] == DUMMY_IND || roots[1] == DUMMY_IND) {
            return Bool.UNKNOWN;
        }
        Bool result = Bool.TRUE;
        int root = roots[0].getTypes().size() < roots[1].getTypes().size() ? 0 : 1;
        int otherRoot = 1 - root;
        Iterator i = roots[root].getTypes().iterator();
        while (i.hasNext()) {
            boolean allIndependent;
            ATermAppl c = (ATermAppl)i.next();
            ATermAppl notC = ATermUtils.negate(c);
            if (!roots[otherRoot].hasType((ATerm)notC)) continue;
            DependencySet ds1 = roots[root].getDepends((ATerm)c);
            DependencySet ds2 = roots[otherRoot].getDepends((ATerm)notC);
            boolean bl = allIndependent = independent && ds1.isIndependent() && ds2.isIndependent();
            if (allIndependent) {
                return Bool.FALSE;
            }
            if (DEBUG) {
                System.out.println(roots[root] + " has " + c + " " + roots[otherRoot] + " has negation " + ds1.max() + " " + ds2.max());
            }
            result = Bool.UNKNOWN;
        }
        if (result.isUnknown()) {
            return result;
        }
        for (root = 0; root < 2; ++root) {
            otherRoot = 1 - root;
            i = roots[root].getTypes(Node.ALL).iterator();
            while (i.hasNext()) {
                ATermAppl av = (ATermAppl)i.next();
                ATerm r = av.getArgument(0);
                role = this.getRole(r);
                if (!roots[otherRoot].hasRNeighbor(role)) continue;
                if (DEBUG) {
                    System.out.println(roots[root] + " has " + av + " " + roots[otherRoot] + " has R-neighbor");
                }
                return Bool.UNKNOWN;
            }
            i = roots[root].getTypes(Node.MAX).iterator();
            while (i.hasNext()) {
                int n2;
                ATermAppl mc = (ATermAppl)i.next();
                ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
                Role maxR = this.getRole(maxCard.getArgument(0));
                int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
                int n1 = roots[root].getRNeighborEdges(maxR).getFilteredNeighbors(roots[root]).size();
                if (n1 + (n2 = roots[otherRoot].getRNeighborEdges(maxR).getFilteredNeighbors(roots[otherRoot]).size()) <= max) continue;
                if (DEBUG) {
                    System.out.println(roots[root] + " has " + mc + " " + roots[otherRoot] + " has R-neighbor");
                }
                return Bool.UNKNOWN;
            }
        }
        if (this.kb.getExpressivity().hasFunctionality()) {
            Edge edge;
            root = roots[0].getOutEdges().size() + roots[0].getInEdges().size() < roots[1].getOutEdges().size() + roots[1].getInEdges().size() ? 0 : 1;
            otherRoot = 1 - root;
            HashSet<Role> checked = new HashSet<Role>();
            Iterator i2 = roots[root].getOutEdges().iterator();
            while (i2.hasNext()) {
                edge = (Edge)i2.next();
                role = edge.getRole();
                if (!role.isFunctional() || checked.contains(role)) continue;
                checked.add(role);
                if (!roots[otherRoot].hasRNeighbor(role)) continue;
                if (DEBUG) {
                    System.out.println(root1 + " and " + root2 + " has " + role);
                }
                return Bool.UNKNOWN;
            }
            i2 = roots[root].getInEdges().iterator();
            while (i2.hasNext()) {
                edge = (Edge)i2.next();
                role = edge.getRole().getInverse();
                if (role == null || !role.isFunctional() || checked.contains(role)) continue;
                checked.add(role);
                if (!roots[otherRoot].hasRNeighbor(role)) continue;
                if (DEBUG) {
                    System.out.println(root1 + " and " + root2 + " has " + role);
                }
                return Bool.UNKNOWN;
            }
        }
        return result;
    }

    public boolean isSubclassOf(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2);
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        CachedNode cached = this.getCached(c1);
        if (cached != null) {
            Bool possible = this.isPossibleType(cached.node, c2, cached.depends.isIndependent());
            if (possible.isKnown()) {
                return possible.isTrue();
            }
            if (this.isObviousType(cached.node, c2, cached.depends.isIndependent())) {
                return true;
            }
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        if (DEBUG) {
            String name1 = URIUtils.getLocalName(c1.getName());
            String name2 = URIUtils.getLocalName(c2.getName());
            System.out.println("Check subclass [" + name1 + " " + name2 + "]");
        }
        Timer t = this.kb.timers.startTimer("subClassSat");
        boolean sat = !this.isSatisfiable(ATermUtils.makeAnd((ATerm)c1, (ATerm)notC2));
        t.stop();
        return sat;
    }

    public boolean isSatisfiable(ATermAppl c) {
        CachedNode cached;
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.print("Satisfiablity for " + c);
        }
        if (PelletOptions.USE_CACHING && (cached = this.getCached(c)) != null) {
            boolean needToCacheModel;
            boolean satisfiable = !cached.isBottom();
            boolean bl = needToCacheModel = ATermUtils.isPrimitiveOrNegated(c) && !cached.isComplete();
            if (DEBUG) {
                System.out.println("Cached sat for " + c + " is " + satisfiable);
            }
            if (!(needToCacheModel || !satisfiable && this.doExplanation)) {
                return satisfiable;
            }
        }
        ++this.satisfiabilityCount;
        Timer t = this.kb.timers.startTimer("satisfiability");
        boolean isSat = this.isConsistent(SetUtils.EMPTY_SET, c);
        t.stop();
        return isSat;
    }

    public void getObviousTypes(ATermAppl x, List types, List nonTypes) {
        Individual pNode = this.pseudoModel.getIndividual((ATerm)x);
        pNode = pNode.mergedAt() > 0 ? this.getIndividual((ATerm)x) : (Individual)pNode.getSame();
        List atomic = pNode.getTypes(Node.ATOM);
        Iterator i = atomic.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (!pNode.getDepends((ATerm)c).isIndependent()) continue;
            if (ATermUtils.isPrimitive(c)) {
                types.add(c);
                continue;
            }
            if (!ATermUtils.isNegatedPrimitive(c)) continue;
            nonTypes.add(c.getArgument(0));
        }
    }

    public boolean isObviousType(ATermAppl x, ATermAppl c) {
        Individual pNode = this.pseudoModel.getIndividual((ATerm)x);
        pNode = pNode.mergedAt() > 0 ? this.getIndividual((ATerm)x) : (Individual)pNode.getSame();
        return this.isObviousType(pNode, c, pNode.getMergeDependency().isIndependent());
    }

    private boolean isObviousType(Individual pNode, ATermAppl c, boolean isIndependent) {
        Timer t = this.kb.timers.startTimer("isObviousType");
        DependencySet ds = pNode.getDepends((ATerm)c);
        boolean obvious = isIndependent && ds != null && ds.isIndependent();
        t.stop();
        return obvious;
    }

    public boolean isPossibleType(ATermAppl x, ATermAppl c) {
        Individual pNode = this.pseudoModel.getIndividual((ATerm)x);
        pNode = pNode.mergedAt() > 0 ? this.getIndividual((ATerm)x) : (Individual)pNode.getSame();
        return !this.isPossibleType(pNode, c, false).isFalse();
    }

    private Bool isPossibleType(Individual pNode, ATermAppl c, boolean isIndependent) {
        Bool mergable;
        ATermAppl notC = ATermUtils.negate(c);
        CachedNode cached = this.getCached(notC);
        if (cached != null && (mergable = this.mergable(pNode, cached.node, isIndependent &= cached.depends.isIndependent())).isKnown()) {
            return mergable.not();
        }
        if (PelletOptions.CHECK_NOMINAL_EDGES && this.kb.getExpressivity().hasNominal() && (cached = this.getCached(c)) != null) {
            Node rNeighbor;
            Iterator j;
            Set neighbors;
            boolean found;
            Node val;
            Role role;
            Edge edge;
            Individual cNode = cached.node;
            Iterator i = cNode.getOutEdges().iterator();
            while (i.hasNext()) {
                edge = (Edge)i.next();
                role = edge.getRole();
                val = edge.getTo();
                if (!role.isObjectRole() || !val.isRoot() || edge.getDepends().max() != 0) continue;
                found = false;
                neighbors = pNode.getRNeighbors(role);
                if (!role.isSimple() && !pNode.isConceptRoot()) {
                    this.getObjectPropertyValues(pNode, role, neighbors, neighbors, false);
                }
                j = neighbors.iterator();
                while (j.hasNext()) {
                    rNeighbor = (Node)j.next();
                    if (!rNeighbor.getName().equals(val.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return Bool.FALSE;
            }
            i = cNode.getInEdges().iterator();
            while (i.hasNext()) {
                edge = (Edge)i.next();
                role = edge.getRole().getInverse();
                val = edge.getFrom();
                if (!val.isNominal() || edge.getDepends().max() != 0) continue;
                found = false;
                neighbors = pNode.getRNeighbors(role);
                if (!role.isSimple() && !pNode.isConceptRoot()) {
                    this.getObjectPropertyValues(pNode, role, neighbors, neighbors, false);
                }
                j = neighbors.iterator();
                while (j.hasNext()) {
                    rNeighbor = (Node)j.next();
                    if (!rNeighbor.getName().equals(val.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return Bool.FALSE;
            }
        }
        return Bool.UNKNOWN;
    }

    public boolean isSameAs(ATermAppl ind1, ATermAppl ind2) {
        ATermAppl c = ATermUtils.makeValue((ATerm)ind2);
        return this.isType(ind1, c);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        boolean isType;
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.println("Checking type " + c + " for individual " + x);
        }
        if (this.isObviousType(x, c)) {
            return true;
        }
        if (!this.isPossibleType(x, c)) {
            return false;
        }
        ATermAppl notC = ATermUtils.negate(c);
        boolean bl = isType = !this.isConsistent(SetUtils.singleton(x), notC);
        if (DEBUG) {
            System.out.println("Type " + isType + " " + c + " for individual " + x);
        }
        return isType;
    }

    public boolean isType(List inds, ATermAppl c) {
        ATermAppl notC;
        boolean isType;
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.println("Checking type " + c + " for individuals " + inds);
        }
        boolean bl = isType = !this.isConsistent(inds, notC = ATermUtils.negate(c));
        if (DEBUG) {
            System.out.println("Type " + isType + " " + c + " for individuals " + inds);
        }
        return isType;
    }

    public Bool hasObviousPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole((ATerm)p);
        if (prop.isDatatypeRole()) {
            Object value = o == null ? null : this.dtReasoner.getValue(o);
            return this.hasObviousDataPropertyValue(s, p, value);
        }
        if (o == null) {
            return this.hasObviousObjectProperty(s, p);
        }
        return this.hasObviousObjectPropertyValue(s, p, o);
    }

    public Bool hasObviousDataPropertyValue(ATermAppl s, ATermAppl p, Object value) {
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        Role prop = this.getRole((ATerm)p);
        boolean onlyPositive = false;
        if (subj.mergedAt() > 0) {
            onlyPositive = true;
            subj = this.getIndividual((ATerm)s);
        } else {
            subj = (Individual)subj.getSame();
        }
        Bool hasValue = subj.hasDataPropertyValue(prop, value);
        if (onlyPositive && hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    public Bool hasObviousObjectPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        boolean onlyPositive;
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        Individual obj = this.pseudoModel.getIndividual((ATerm)o);
        Role prop = this.getRole((ATerm)p);
        boolean bl = onlyPositive = !prop.isSimple();
        if (subj.mergedAt() > 0 || obj.mergedAt() > 0) {
            onlyPositive = true;
            subj = this.getIndividual((ATerm)s);
            obj = this.getIndividual((ATerm)s);
        } else {
            subj = (Individual)subj.getSame();
            obj = (Individual)obj.getSame();
        }
        Bool hasValue = subj.hasObjectPropertyValue(prop, obj);
        if (onlyPositive && hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    public Bool hasObviousObjectProperty(ATermAppl s, ATermAppl p) {
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        Role prop = this.getRole((ATerm)p);
        Bool hasValue = (subj = subj.mergedAt() > 0 ? this.getIndividual((ATerm)s) : (Individual)subj.getSame()).hasObjectPropertyValue(prop, null);
        if (hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    public boolean hasProperty(ATermAppl s, ATermAppl p) {
        Bool hasObviousValue = this.hasObviousPropertyValue(s, p, null);
        if (hasObviousValue.isKnown()) {
            return hasObviousValue.isTrue();
        }
        return false;
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
        if (hasObviousValue.isKnown()) {
            return hasObviousValue.isTrue();
        }
        ATermAppl c = null;
        c = o == null ? ATermUtils.makeMin((ATerm)p, 1) : ATermUtils.makeHasValue((ATerm)p, (ATerm)o);
        return this.isType(s, c);
    }

    public List getObviousDataPropertyValues(ATermAppl s, Role prop) {
        Individual subj = this.pseudoModel.getIndividual((ATerm)s);
        subj = subj.mergedAt() > 0 ? this.getIndividual((ATerm)s) : (Individual)subj.getSame();
        ArrayList<Literal> values = new ArrayList<Literal>();
        EdgeList edges = subj.getRSuccessorEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (literalValue == null || ds.max() != 0) continue;
            values.add(literal);
        }
        return values;
    }

    void getObjectPropertyValues(ATermAppl s, Role prop, Set knowns, Set unknowns) {
        ABox abox = this.pseudoModel != null ? this.pseudoModel : this;
        Individual subj = abox.getIndividual((ATerm)s);
        subj = subj.mergedAt() > 0 ? this.getIndividual((ATerm)s) : (Individual)subj.getSame();
        EdgeList edges = subj.getRNeighborEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            if (value.branch != 0) continue;
            if (ds.isIndependent()) {
                this.getSames(value, knowns, unknowns);
                continue;
            }
            this.getSames(value, unknowns, unknowns);
        }
        if (!prop.isSimple()) {
            Iterator i = this.kb.getIndividuals().iterator();
            while (i.hasNext()) {
                Individual ind;
                ATermAppl candidate = (ATermAppl)i.next();
                if (knowns.contains(candidate) || !(ind = (Individual)abox.getIndividual((ATerm)candidate).getSame()).hasRNeighbor(prop.getInverse())) continue;
                unknowns.add(candidate);
            }
        }
    }

    void collectTransitivePropertyValues(Individual subj) {
        Role role;
        HashSet collected = new HashSet();
        Set roles = subj.getOutEdges().getRoles();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            if (role.isSimple() || collected.contains(role)) continue;
            this.collectTransitivePropertyValues(subj, role);
        }
        roles = subj.getInEdges().getRoles();
        i = roles.iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            if ((role = role.getInverse()).isSimple() || collected.contains(role)) continue;
            this.collectTransitivePropertyValues(subj, role);
        }
    }

    void collectTransitivePropertyValues(Individual subj, Role role) {
        Individual val;
        HashSet knowns = new HashSet();
        HashSet unknowns = new HashSet();
        this.getObjectPropertyValues(subj, role, knowns, unknowns, false);
        Iterator j = knowns.iterator();
        while (j.hasNext()) {
            val = (Individual)j.next();
            subj.addEdge(role, val, DependencySet.INDEPENDENT);
        }
        j = unknowns.iterator();
        while (j.hasNext()) {
            val = (Individual)j.next();
            subj.addEdge(role, val, DependencySet.EMPTY);
        }
    }

    void getObjectPropertyValues(Individual subj, Role prop, Set knowns, Set unknowns, boolean getSames) {
        EdgeList edges = subj.getRNeighborEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            if (value.branch == 0) {
                if (ds.isIndependent()) {
                    if (getSames) {
                        this.getSames(value, knowns, unknowns);
                    } else {
                        knowns.add(value);
                    }
                } else if (getSames) {
                    this.getSames(value, unknowns, unknowns);
                } else {
                    unknowns.add(value);
                }
            }
            if (prop.isSimple()) continue;
            if (ds.isIndependent()) {
                this.getObjectPropertyValues(value, prop, knowns, unknowns, getSames);
                continue;
            }
            this.getObjectPropertyValues(value, prop, unknowns, unknowns, getSames);
        }
    }

    public void getSames(Individual ind, Set knowns, Set unknowns) {
        knowns.add(ind.getName());
        boolean merged = ind.getMergeDependency().max() > 0;
        Iterator i = ind.getMerged().iterator();
        while (i.hasNext()) {
            Individual other = (Individual)i.next();
            if (!other.isRootNominal()) continue;
            if (merged || !other.getMergeDependency().isIndependent()) {
                unknowns.add(other.getName());
                this.getSames(other, unknowns, unknowns);
                continue;
            }
            knowns.add(other.getName());
            this.getSames(other, knowns, unknowns);
        }
    }

    public boolean isConsistent() {
        ATermAppl c = this.isEmpty() ? ATermUtils.TOP : null;
        boolean isConsistent = this.isConsistent(SetUtils.EMPTY_SET, c);
        this.pseudoModel = this.lastCompletion;
        if (isConsistent) {
            this.cacheConcept(ATermUtils.TOP, TOP_IND, DependencySet.INDEPENDENT);
            this.cacheConcept(ATermUtils.BOTTOM, BOTTOM_IND, DependencySet.INDEPENDENT);
        }
        return isConsistent;
    }

    private boolean isConsistent(Collection individuals, ATermAppl c) {
        boolean consistent;
        boolean buildPseudoModel = c == null;
        boolean conceptSatisfiability = !buildPseudoModel && individuals.isEmpty();
        boolean hasNominal = this.kb.getExpressivity().hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
        boolean canUseEmptyModel = conceptSatisfiability && !hasNominal && !(this.kb instanceof EconnectedKB);
        boolean canUsePseudoModel = !buildPseudoModel && this.pseudoModel != null && PelletOptions.USE_PSEUDO_MODEL && this.kb.chooseStrategy(this).supportsPseudoModelCompletion();
        ATermAppl x = null;
        if (conceptSatisfiability) {
            x = ATermUtils.makeTermAppl(DEBUG ? "x" + new UID() : "Any member of " + c.toString());
            individuals = SetUtils.singleton(x);
        }
        ABox abox = canUseEmptyModel ? this.copy(x, false) : (canUsePseudoModel ? this.pseudoModel.copy(x, true) : this.copy(x, true));
        Iterator i = individuals.iterator();
        while (i.hasNext()) {
            ATermAppl ind = (ATermAppl)i.next();
            abox.addType(ind, c);
        }
        if (DEBUG) {
            System.out.println("Consistency check starts");
        }
        if (abox.isEmpty()) {
            this.lastCompletion = abox;
        } else {
            CompletionStrategy strategy = this.kb.chooseStrategy(abox);
            this.lastCompletion = strategy.complete();
        }
        if (DEBUG) {
            System.out.println("Tree depth: " + this.lastCompletion.treeDepth + "size: " + this.lastCompletion.getNodes().size());
        }
        boolean bl = consistent = !this.lastCompletion.isClosed();
        if (!consistent && DEBUG) {
            System.out.println(this.lastCompletion.getClash().detailedString());
        }
        this.cache(x, c, consistent);
        ++this.consistencyCount;
        return consistent;
    }

    void applyUC(Individual node) {
        ATermList UC = this.kb.getTBox().getUC();
        if (UC != null) {
            ATermList t = UC;
            while (!t.isEmpty()) {
                ATermAppl c = (ATermAppl)t.getFirst();
                node.addType(c, DependencySet.INDEPENDENT);
                t = t.getNext();
            }
        }
    }

    public EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getInEdges();
    }

    public EdgeList getOutEdges(ATerm x) {
        Node node = this.getNode(x);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    public Individual getIndividual(ATerm x) {
        return (Individual)this.nodes.get(x);
    }

    public Literal getLiteral(ATerm x) {
        return (Literal)this.nodes.get(x);
    }

    public Node getNode(ATerm x) {
        return (Node)this.nodes.get(x);
    }

    public void addType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        int remember = this.branch;
        this.branch = -1;
        Node node = this.getNode((ATerm)x);
        if (node.isMerged()) {
            node = node.getSame();
        }
        node.addType(c, DependencySet.INDEPENDENT);
        this.branch = remember;
    }

    public void removeType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        Node node = this.getNode((ATerm)x);
        node.removeType(c);
    }

    public Literal addLiteral() {
        return this.createLiteral(null);
    }

    public Literal addLiteral(ATermAppl dataValue) {
        if (dataValue == null || !ATermUtils.isLiteral(dataValue)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + dataValue);
        }
        return this.createLiteral(dataValue);
    }

    private Literal createLiteral(ATermAppl value) {
        ATermAppl name = this.createUniqueName();
        Literal lit = new Literal(name, value, this);
        lit.addType(ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal"), DependencySet.INDEPENDENT);
        this.nodes.put(name, lit);
        this.nodeList.add(name);
        return lit;
    }

    public Individual addIndividual(ATermAppl x) {
        Individual ind = this.addIndividual(x, Individual.NOMINAL);
        ATermAppl valueX = ATermUtils.makeValue((ATerm)x);
        ind.addType(valueX, DependencySet.INDEPENDENT);
        return ind;
    }

    Individual addFreshIndividual() {
        ATermAppl name = this.createUniqueName();
        Individual ind = this.addIndividual(name, Individual.BLOCKABLE);
        this.applyUC(ind);
        return ind;
    }

    private Individual addIndividual(ATermAppl x, int nominalLevel) {
        if (this.nodes.containsKey(x)) {
            throw new InternalReasonerException("adding a node twice " + x);
        }
        this.changed = true;
        Individual n = new Individual(x, this, nominalLevel);
        n.branch = this.branch;
        n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
        this.nodes.put(x, n);
        this.nodeList.add(x);
        return n;
    }

    public void addSame(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual((ATerm)x);
        Individual ind2 = this.getIndividual((ATerm)y);
        this.toBeMerged.add(new NodeMerge(ind1, ind2, DependencySet.INDEPENDENT));
    }

    public void addDifferent(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual((ATerm)x);
        Individual ind2 = this.getIndividual((ATerm)y);
        ind1.setDifferent(ind2, DependencySet.INDEPENDENT);
    }

    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    private final ATermAppl createUniqueName() {
        return ATermUtils.makeTermAppl(ANON_PREFIX + ++this.anonCount);
    }

    public final Collection getNodes() {
        return this.nodes.values();
    }

    final Map getNodeMap() {
        return this.nodes;
    }

    public final List getNodeNames() {
        return this.nodeList;
    }

    public final IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    public final IndividualIterator getSingletonIterator(Individual x) {
        int index = this.nodeList.indexOf(x.getName());
        return new IndividualIterator(this, index, index + 1);
    }

    public String toString() {
        return "[size: " + this.nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.dtReasoner;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public boolean isClosed() {
        return this.clash != null;
    }

    public Clash getClash() {
        return this.clash;
    }

    public void setClash(Clash clash) {
        if (clash != null && this.clash != null) {
            if (DEBUG) {
                System.out.println("Clash was already set \nExisting: " + this.clash + "\nNew     : " + clash);
            }
            if (this.clash.depends.max() < clash.depends.max()) {
                return;
            }
        }
        this.clash = clash;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Role getRole(ATerm r) {
        return this.kb.getRole(r);
    }

    public RBox getRBox() {
        return this.kb.getRBox();
    }

    public TBox getTBox() {
        return this.kb.getTBox();
    }

    int getBranch() {
        return this.branch;
    }

    void setBranch(int branch) {
        this.branch = branch;
    }

    void incrementBranch() {
        ++this.branch;
    }

    public boolean isInitialized() {
        return this.initialized && !this.kb.isChanged();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public final boolean doExplanation() {
        return this.doExplanation || DEBUG;
    }

    public void setDoExplanation(boolean doExplanation) {
        this.doExplanation = doExplanation;
    }

    public String getExplanation() {
        Clash lastClash;
        Clash clash = lastClash = this.lastCompletion != null ? this.lastCompletion.getClash() : null;
        if (lastClash == null) {
            return "No inconsistency was found! There is no explanation generated.";
        }
        return lastClash.detailedString();
    }

    public List getBranches() {
        return this.branches;
    }

    public void validate() {
        if (!PelletOptions.VALIDATE_ABOX) {
            return;
        }
        System.out.print("VALIDATING...");
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (node.isPruned()) continue;
            this.validate(node);
        }
    }

    void validate(Individual node) {
        int e;
        ATermAppl nominal;
        List[] negatedTypes = new List[]{node.getTypes(Node.ATOM), node.getTypes(Node.SOME), node.getTypes(Node.OR), node.getTypes(Node.MAX)};
        for (int j = 0; j < negatedTypes.length; ++j) {
            int n = negatedTypes[j].size();
            for (int i = 0; i < n; ++i) {
                ATermAppl notA;
                ATermAppl a = (ATermAppl)negatedTypes[j].get(i);
                if (a.getArity() == 0 || !node.hasType((ATerm)(notA = (ATermAppl)a.getArgument(0)))) continue;
                if (!node.hasType((ATerm)a)) {
                    throw new InternalReasonerException("Invalid type found: " + node + " " + j + " " + a + " " + node.debugString() + " " + node.depends);
                }
                throw new InternalReasonerException("Clash found: " + node + " " + a + " " + node.debugString() + " " + node.depends);
            }
        }
        if (!node.isRoot()) {
            if (node.getPredecessors().size() != 1) {
                throw new InternalReasonerException("Invalid blockable node: " + node + " " + node.getInEdges());
            }
        } else if (node.isNominal() && !node.hasType((ATerm)(nominal = ATermUtils.makeValue((ATerm)node.getName())))) {
            throw new InternalReasonerException("Invalid nominal node: " + node + " " + node.getTypes());
        }
        Iterator<Object> i = node.getDepends().keySet().iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            DependencySet ds = node.getDepends((ATerm)c);
            if (ds.max() <= this.branch && (PelletOptions.USE_SMART_RESTORE || ds.branch <= this.branch)) continue;
            throw new InternalReasonerException("Invalid ds found: " + node + " " + c + " " + ds + " " + this.branch);
        }
        i = node.getDifferents().iterator();
        while (i.hasNext()) {
            Node ind = (Node)i.next();
            DependencySet ds = node.getDifferenceDependency(ind);
            if (ds.max() > this.branch || ds.branch > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + node + " != " + ind + " " + ds);
            }
            if (ind.getDifferenceDependency(node) != null) continue;
            throw new InternalReasonerException("Invalid difference: " + node + " != " + ind + " " + ds);
        }
        EdgeList edges = node.getOutEdges();
        for (e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            Node succ = edge.getTo();
            if (this.nodes.get(succ.getName()) != succ) {
                throw new InternalReasonerException("Invalid edge to a non-existing node: " + edge + " " + this.nodes.get(succ.getName()) + "(" + this.nodes.get(succ.getName()).hashCode() + ")" + succ + "(" + succ.hashCode() + ")");
            }
            if (!succ.getInEdges().hasEdge(edge)) {
                throw new InternalReasonerException("Invalid edge: " + edge);
            }
            if (succ.isMerged()) {
                throw new InternalReasonerException("Invalid edge to a removed node: " + edge + " " + succ.isMerged());
            }
            DependencySet ds = edge.getDepends();
            if (ds.max() > this.branch || ds.branch > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + edge + " " + ds);
            }
            EdgeList allEdges = node.getEdgesTo(succ);
            if (allEdges.getRoles().size() == allEdges.size()) continue;
            throw new InternalReasonerException("Duplicate edges: " + allEdges);
        }
        edges = node.getInEdges();
        for (e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            DependencySet ds = edge.getDepends();
            if (ds.max() <= this.branch && ds.branch <= this.branch) continue;
            throw new InternalReasonerException("Invalid ds: " + edge + " " + ds);
        }
    }

    public void printTree() {
        if (!PelletOptions.PRINT_ABOX) {
            return;
        }
        System.out.println("PRINTING...");
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (!node.isNominal()) continue;
            this.printNode(node, new HashSet(), "   ");
        }
    }

    private void printNode(Individual node, Set printed, String indent) {
        boolean printOnlyName;
        boolean bl = printOnlyName = node.isNominal() && !printed.isEmpty();
        if (printed.contains(node)) {
            System.out.println(" " + node.getNameStr());
            return;
        }
        printed.add(node);
        if (node.isMerged()) {
            System.out.println(node.getNameStr() + " -> " + node.getSame().getNameStr() + " " + node.getMergeDependency());
            return;
        }
        System.out.println(node.debugString());
        if (printOnlyName) {
            return;
        }
        indent = indent + "  ";
        Iterator i = node.getSuccessors().iterator();
        while (i.hasNext()) {
            Node succ = (Node)i.next();
            EdgeList edges = node.getEdgesTo(succ);
            System.out.print(indent + "[");
            for (int e = 0; e < edges.size(); ++e) {
                if (e > 0) {
                    System.out.print(", ");
                }
                System.out.print(edges.edgeAt(e).getRole());
            }
            System.out.print("] ");
            if (succ instanceof Individual) {
                this.printNode((Individual)succ, printed, indent);
                continue;
            }
            System.out.println(" (Literal) " + succ.getName() + " " + succ.getTypes());
        }
    }

    public ABox getLastCompletion() {
        return this.lastCompletion;
    }

    public ABox getPseudoModel() {
        return this.pseudoModel;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }
}

