/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;

public class Clash {
    public static final String[] TYPES = new String[]{"An individual belongs to a type and its complement", "An individual contains a minCardinality restriction that is greater than a maxCardinality restriction", "The maxCardinality restriction is violated", "An individual contains a minCardinality restriction that is greater than a maxCardinality restriction", "The maxCardinality(0) restriction is violated", "An individual is sameAs and differentFrom another individual at the same time", "Range restrictions on a literal is inconsistent", "The literal value does not satisfy the datatype restriction", "Plain literal does not satisfy the datatype restriction (literal may be missing the rdf:datatype attribute)", "The literal value does not satisfy the datatype restriction", "Invalid literal for the rdf:datatype attribute", "Cannot explain"};
    public static final String[] SHORT = new String[]{"ATOMIC", "MIN_MAX", "MAX_CARD", "FUNC_MAX_CARD", "MAX_ZERO", "NOMINAL", "EMPTY_DATATYPE", "VALUE_DATATYPE", "MISSING_DATATYPE", "INVALID_LITERAL", "UNEXPLAINED"};
    private static final int ATOMIC = 0;
    public static final int MIN_MAX = 1;
    private static final int MAX_CARD = 2;
    private static final int FUNC_MAX_CARD = 3;
    public static final int MAX_ZERO = 4;
    public static final int NOMINAL = 5;
    public static final int EMPTY_DATATYPE = 6;
    private static final int VALUE_DATATYPE = 7;
    private static final int MISSING_DATATYPE = 8;
    private static final int INVALID_LITERAL = 9;
    private static final int UNEXPLAINED = 10;
    DependencySet depends;
    Node node;
    int type;
    ATerm[] args;
    String explanation;

    Clash(Node node, int type, DependencySet depends) {
        this.depends = depends;
        this.node = node;
        this.type = type;
    }

    Clash(Node node, int type, DependencySet depends, ATerm[] args) {
        this.depends = depends;
        this.node = node;
        this.type = type;
        this.args = args;
    }

    Clash(Node node, int type, DependencySet depends, String explanation) {
        this.depends = depends;
        this.node = node;
        this.type = type;
        this.explanation = explanation;
    }

    public static Clash unexplained(Node node, DependencySet depends) {
        return new Clash(node, 10, depends);
    }

    public static Clash atomic(Node node, DependencySet depends) {
        return new Clash(node, 0, depends);
    }

    public static Clash atomic(Node node, DependencySet depends, ATermAppl c) {
        return new Clash(node, 0, depends, new ATerm[]{c});
    }

    public static Clash maxCardinality(Node node, DependencySet depends) {
        return new Clash(node, 2, depends);
    }

    public static Clash maxCardinality(Node node, DependencySet depends, ATermAppl r, int n) {
        return new Clash(node, 2, depends, new ATerm[]{r, ATermUtils.getFactory().makeInt(n)});
    }

    public static Clash functionalCardinality(Node node, DependencySet depends) {
        return new Clash(node, 3, depends);
    }

    public static Clash functionalCardinality(Node node, DependencySet depends, ATermAppl r) {
        return new Clash(node, 3, depends, new ATerm[]{r});
    }

    public static Clash missingDatatype(Node node, DependencySet depends) {
        return new Clash(node, 8, depends);
    }

    public static Clash missingDatatype(Node node, DependencySet depends, ATermAppl value, ATermAppl datatype) {
        return new Clash(node, 8, depends, (ATerm[])new ATermAppl[]{value, datatype});
    }

    public static Clash nominal(Node node, DependencySet depends) {
        return new Clash(node, 5, depends);
    }

    public static Clash nominal(Node node, DependencySet depends, ATermAppl other) {
        return new Clash(node, 5, depends, (ATerm[])new ATermAppl[]{other});
    }

    public static Clash valueDatatype(Node node, DependencySet depends) {
        return new Clash(node, 7, depends);
    }

    public static Clash valueDatatype(Node node, DependencySet depends, ATermAppl value, ATermAppl datatype) {
        return new Clash(node, 7, depends, (ATerm[])new ATermAppl[]{value, datatype});
    }

    public static Clash invalidLiteral(Node node, DependencySet depends) {
        return new Clash(node, 9, depends);
    }

    public static Clash invalidLiteral(Node node, DependencySet depends, ATermAppl value) {
        return new Clash(node, 9, depends, (ATerm[])new ATermAppl[]{value});
    }

    public String detailedString() {
        String str = this.explanation != null ? this.explanation : (this.args == null ? "No specific explanation was generated. Generic explanation: " + TYPES[this.type] : (this.type == 0 ? this.atomicExplanation() : (this.type == 2 ? this.maxCardinalityExplanation() : (this.type == 3 ? this.functionalCardinalityExplanation() : (this.type == 5 ? this.nominalExplanation() : (this.type == 8 ? this.missingDatatypeExplanation() : (this.type == 7 ? this.valueDatatypeExplanation() : (this.type == 9 ? this.invalidLiteralExplanation() : this.explanation))))))));
        return str;
    }

    public String describeNode(Node node) {
        String str = "";
        if (node.getNameStr().startsWith("Any member of")) {
            str = str + node.getNameStr();
        } else if (node.isNamedIndividual()) {
            str = str + "Individual " + node.getNameStr();
        } else {
            List path = node.getPath();
            if (path.isEmpty()) {
                str = str + "There is an anonymous individual which";
            } else {
                ATermAppl first = (ATermAppl)path.get(0);
                Iterator i = path.iterator();
                String nodeID = "";
                if (first.getName().startsWith("Any member of")) {
                    nodeID = "Y";
                    str = str + first.getName() + ", X, is related to some " + nodeID + ", identified by this path (X ";
                    i.next();
                } else {
                    nodeID = "X";
                    str = str + "There is an anonymous individual X, identified by this path (" + i.next() + " ";
                }
                while (i.hasNext()) {
                    str = str + i.next() + " ";
                    if (!i.hasNext()) continue;
                    str = str + "[ ";
                }
                str = str + nodeID;
                for (int count = 0; count < path.size() - 2; ++count) {
                    str = str + " ]";
                }
                str = str + "), which";
            }
        }
        return str;
    }

    public String atomicExplanation() {
        return this.describeNode(this.node) + " is forced to belong to class " + this.args[0] + " and its complement";
    }

    public String maxCardinalityExplanation() {
        return this.describeNode(this.node) + " has more than " + this.args[1] + " values for property " + this.args[0] + " violating the cardinality restriction";
    }

    public String functionalCardinalityExplanation() {
        return this.describeNode(this.node) + " has more than " + "one value for the functional property " + this.args[0];
    }

    public String missingDatatypeExplanation() {
        return "Plain literal " + ATermUtils.toString((ATermAppl)this.args[0]) + " does not belong to datatype " + this.args[1] + ". Literal value may be missing the rdf:datatype attribute.";
    }

    public String nominalExplanation() {
        return this.describeNode(this.node) + " is sameAs and differentFrom " + this.args[0] + "  at the same time ";
    }

    public String valueDatatypeExplanation() {
        return "Literal value " + ATermUtils.toString((ATermAppl)this.args[0]) + " does not belong to datatype " + this.args[1];
    }

    public String invalidLiteralExplanation() {
        return "Literal value \"" + ((ATermAppl)this.args[0]).getArgument(0) + "\" is not a valid value for the rdf:datatype " + ((ATermAppl)this.args[0]).getArgument(2);
    }

    public String toString() {
        return "[Clash " + this.node + " " + SHORT[this.type] + " " + this.depends.toString() + " " + (this.args == null ? (List<ATerm>)null : Arrays.asList(this.args)) + "]";
    }
}

