/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Blocking;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.DisjunctionSorting;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MaxBranch;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class CompletionStrategy {
    protected ABox abox;
    protected Blocking blocking;
    protected Timers timers;
    protected Map unfoldingMap;
    protected Timer completionTimer;
    private boolean merging;
    protected List mergeList;

    public CompletionStrategy(ABox abox, Blocking blocking) {
        this.abox = abox;
        this.blocking = blocking;
        this.timers = abox.getKB().timers;
        this.completionTimer = this.timers.createTimer("complete");
    }

    public void initialize() {
        Individual n;
        TBox tbox = this.abox.getKB().getTBox();
        this.unfoldingMap = tbox.Tu.normalizedMap;
        this.mergeList = new ArrayList();
        IndividualIterator i = this.abox.getBranches().iterator();
        while (i.hasNext()) {
            Branch branch = (Branch)i.next();
            branch.setStrategy(this);
        }
        if (this.abox.isInitialized()) {
            i = this.abox.getIndIterator();
            while (i.hasNext()) {
                n = (Individual)i.next();
                if (!n.isChanged(Node.ALL)) continue;
                this.applyAllValues(n);
                this.applyNominalRule(n);
            }
            return;
        }
        if (ABox.DEBUG) {
            System.out.println("Initialize started");
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.toBeMerged);
        if (!this.mergeList.isEmpty()) {
            this.mergeFirst();
        }
        i = this.abox.getIndIterator();
        block2: while (i.hasNext()) {
            n = (Individual)i.next();
            if (n.isMerged()) continue;
            n.setChanged(true);
            this.abox.applyUC(n);
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = allEdges.edgeAt(e);
                if (edge.getTo().isPruned()) continue;
                this.applyDomainRange(edge);
                this.applyAllValues(edge);
                this.applyFunctionalRole(edge);
                if (n.isMerged()) continue block2;
            }
        }
        if (ABox.DEBUG) {
            System.out.println("Merging: " + this.mergeList);
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeFirst();
        }
        if (ABox.DEBUG) {
            System.out.println("Initialize finished");
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        this.abox.treeDepth = 1;
        this.abox.changed = true;
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    private void mergeLater(Node y, Node z, DependencySet ds) {
        this.mergeList.add(new NodeMerge(y, z, ds));
    }

    abstract ABox complete();

    abstract boolean supportsPseudoModelCompletion();

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        node.addType(c, ds);
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(node, conj, ds);
                node = node.getSame();
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.applyAllValues((Individual)node, c, ds);
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = subj.addEdge(pred, obj, ds);
        if (edge != null) {
            this.applyDomainRange(edge);
            this.applyAllValues(edge);
            this.applyFunctionalRole(edge);
        }
    }

    protected void applyUnfoldingRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = (Individual)i.next();
            this.applyUnfoldingRule(node);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected final void applyUnfoldingRule(Individual node) {
        if (!node.canApply(Node.ATOM) || this.blocking.isBlocked(node)) {
            return;
        }
        List types = node.getTypes(Node.ATOM);
        int size = types.size();
        for (int j = node.applyNext[Node.ATOM]; j < size; ++j) {
            ATermAppl c = (ATermAppl)types.get(j);
            ATermAppl unfolded = (ATermAppl)this.unfoldingMap.get(c);
            if (unfolded == null) continue;
            DependencySet ds = node.getDepends((ATerm)c);
            if (ABox.DEBUG && !node.hasType((ATerm)unfolded)) {
                System.out.println("UNF : " + node + ", " + c + " -> " + unfolded + " - " + ds);
            }
            this.addType(node, unfolded, ds);
            size = types.size();
            if (!this.abox.isClosed()) continue;
            return;
        }
        node.applyNext[Node.ATOM] = size;
    }

    void applyFunctionalRole(Edge edge) {
        DependencySet maxCardDS;
        Individual subj = edge.getFrom();
        Role r = edge.getRole();
        DependencySet dependencySet = maxCardDS = r.isFunctional() ? DependencySet.INDEPENDENT : subj.hasMax1(r);
        if (maxCardDS != null) {
            this.applyFunctionalMaxRule(subj, r, maxCardDS);
        }
        if (r.isObjectRole()) {
            Individual obj = (Individual)edge.getTo();
            Role invR = r.getInverse();
            DependencySet dependencySet2 = maxCardDS = invR.isFunctional() ? DependencySet.INDEPENDENT : obj.hasMax1(invR);
            if (maxCardDS != null) {
                this.applyFunctionalMaxRule(obj, invR, maxCardDS);
            }
        }
    }

    protected void applyFunctionalMaxRule(Individual x, Role s, DependencySet ds) {
        Set functionalSupers = s.getFunctionalSupers();
        if (functionalSupers.isEmpty()) {
            functionalSupers = SetUtils.singleton(s);
        }
        Iterator it = functionalSupers.iterator();
        block0: while (it.hasNext()) {
            Set neighbors;
            Role r = (Role)it.next();
            EdgeList edges = x.getRNeighborEdges(r);
            if (edges.size() <= 1 || (neighbors = edges.getFilteredNeighbors(x)).size() <= 1) continue;
            Edge first = edges.edgeAt(0);
            Node head = first.getNeighbor(x);
            ds = ds.union(first.getDepends());
            for (int i = 1; i < edges.size(); ++i) {
                Edge edge = edges.edgeAt(i);
                Node next = edge.getNeighbor(x);
                if (next.isPruned() || head.isSame(next)) continue;
                ds = ds.union(edge.getDepends());
                if (next.isDifferent(head)) {
                    ds = ds.union(next.getDifferenceDependency(head));
                    if (r.isFunctional()) {
                        this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                        continue block0;
                    }
                    this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                    continue block0;
                }
                if (next.getNominalLevel() < head.getNominalLevel() || !head.isNominal() && next.hasSuccessor(x)) {
                    Node temp = head;
                    head = next;
                    next = temp;
                }
                if (ABox.DEBUG) {
                    System.out.println("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
                }
                this.mergeTo(next, head, ds);
                if (this.abox.isClosed()) {
                    return;
                }
                if (!head.isPruned()) continue;
                head = head.getSame();
            }
        }
    }

    void applyDomainRange(Edge edge) {
        Role r = edge.getRole();
        ATermAppl domain = r.getDomain();
        ATermAppl range = r.getRange();
        if (domain != null) {
            Individual from = edge.getFrom();
            if (ABox.DEBUG && !from.hasType((ATerm)domain)) {
                System.out.println("DOM : " + edge.getTo() + " <- " + edge.getRole() + " <- " + edge.getFrom() + " : " + domain);
            }
            this.addType(from, domain, edge.getDepends());
        }
        if (range != null) {
            Node to = edge.getTo();
            if (ABox.DEBUG && !to.hasType((ATerm)range)) {
                System.out.println("RAN : " + edge.getFrom() + " -> " + edge.getRole() + " -> " + edge.getTo() + " : " + range);
            }
            this.addType(to, range, edge.getDepends());
        }
    }

    void applyAllValues(Individual x) {
        List allValues = x.getTypes(Node.ALL);
        x.setChanged(Node.ALL, false);
        Iterator i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = (ATermAppl)i.next();
            DependencySet avDepends = x.getDepends((ATerm)av);
            this.applyAllValues(x, av, avDepends);
            if (x.isMerged()) {
                return;
            }
            if (!x.isChanged(Node.ALL)) continue;
            i = allValues.iterator();
            x.setChanged(Node.ALL, false);
        }
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        Role s = this.abox.getRole(av.getArgument(0));
        ATermAppl c = (ATermAppl)av.getArgument(1);
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            this.applyAllValues(x, s, c, edgeToY, ds);
            if (!x.isMerged()) continue;
            return;
        }
        if (!s.isSimple()) {
            Set transitiveSubRoles = s.getTransitiveSubRoles();
            Iterator it = transitiveSubRoles.iterator();
            while (it.hasNext()) {
                Role r = (Role)it.next();
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)r.getName(), (ATerm)c);
                edges = x.getRNeighborEdges(r);
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edgeToY = edges.edgeAt(e);
                    this.applyAllValues(x, r, allRC, edgeToY, ds);
                    if (!x.isMerged()) continue;
                    return;
                }
            }
        }
    }

    void applyAllValues(Individual x, Role s, ATermAppl c, Edge edgeToY, DependencySet avDepends) {
        DependencySet ds = null;
        Node y = edgeToY.getNeighbor(x);
        if (!y.hasType((ATerm)c)) {
            ds = avDepends.union(edgeToY.getDepends());
            if (ABox.DEBUG) {
                System.out.println("ALL : " + x + " -> " + s + " -> " + y + " : " + c + " - " + ds);
            }
            this.addType(y, c, ds);
        }
    }

    void applyAllValues(Edge edge) {
        Individual x = edge.getFrom();
        Role r = edge.getRole();
        List allValues = x.getTypes(Node.ALL);
        Iterator i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = (ATermAppl)i.next();
            Role s = this.abox.getRole(av.getArgument(0));
            if (!r.isSubRoleOf(s)) continue;
            ATermAppl c = (ATermAppl)av.getArgument(1);
            DependencySet ds = x.getDepends((ATerm)av);
            this.applyAllValues(x, s, c, edge, ds);
            if (!r.isTransitive()) continue;
            ATermAppl allRC = ATermUtils.makeAllValues((ATerm)r.getName(), (ATerm)c);
            this.applyAllValues(x, r, allRC, edge, ds);
        }
        if (r.isObjectRole()) {
            Individual y = (Individual)edge.getTo();
            r = r.getInverse();
            allValues = y.getTypes(Node.ALL);
            i = allValues.iterator();
            while (i.hasNext()) {
                ATermAppl av = (ATermAppl)i.next();
                Role s = this.abox.getRole(av.getArgument(0));
                if (!r.isSubRoleOf(s)) continue;
                ATermAppl c = (ATermAppl)av.getArgument(1);
                DependencySet ds = y.getDepends((ATerm)av);
                this.applyAllValues(y, s, c, edge, ds);
                if (!r.isTransitive()) continue;
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)r.getName(), (ATerm)c);
                this.applyAllValues(y, r, allRC, edge, ds);
            }
        }
    }

    protected void applySomeValuesRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.canApply(Individual.SOME) || this.blocking.isBlocked(x)) continue;
            List types = x.getTypes(Node.SOME);
            int size = types.size();
            for (int j = x.applyNext[Node.SOME]; j < size; ++j) {
                ATermAppl sv = (ATermAppl)types.get(j);
                ATermAppl a = (ATermAppl)sv.getArgument(0);
                ATermAppl s = (ATermAppl)a.getArgument(0);
                ATermAppl c = (ATermAppl)a.getArgument(1);
                Role role = this.abox.getRole((ATerm)s);
                c = ATermUtils.negate(c);
                boolean neighborFound = false;
                boolean neighborSafe = x.isBlockable();
                Node y = null;
                Edge edge = null;
                EdgeList edges = x.getRNeighborEdges(role);
                for (int e = 0; e < edges.size(); ++e) {
                    edge = edges.edgeAt(e);
                    y = edge.getNeighbor(x);
                    if (!y.hasType((ATerm)c) || !(neighborSafe |= y.isLiteral() || !this.blocking.isBlocked((Individual)y))) continue;
                    neighborFound = true;
                    break;
                }
                if (neighborFound) continue;
                DependencySet ds = x.getDepends((ATerm)sv).copy();
                if (role.isDatatypeRole()) {
                    if (ABox.DEBUG) {
                        System.out.println("SOME: " + x + " -> " + s + " -> " + y + " : " + c + " - " + ds);
                    }
                    Literal literal = (Literal)y;
                    if (ATermUtils.isNominal(c)) {
                        literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
                    } else {
                        if (!role.isFunctional() || literal == null) {
                            literal = this.abox.addLiteral();
                        }
                        literal.addType(c, ds);
                    }
                    this.addEdge(x, role, literal, ds);
                } else if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                    this.abox.copyOnWrite();
                    ATermAppl value = (ATermAppl)c.getArgument(0);
                    y = this.abox.getIndividual((ATerm)value);
                    if (ABox.DEBUG) {
                        System.out.println("VAL : " + x + " -> " + s + " -> " + y + " - " + ds);
                    }
                    if (y == null) {
                        if (ATermUtils.isLiteral(value)) {
                            throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString(value));
                        }
                        throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                    }
                    while (y.isMerged()) {
                        ds = ds.union(y.getMergeDependency());
                        y = (Individual)y.getMergedTo();
                    }
                    this.addEdge(x, role, y, ds);
                } else {
                    DependencySet maxCardDS;
                    boolean useExistingNode = false;
                    boolean useExistingRole = false;
                    DependencySet dependencySet = maxCardDS = role.isFunctional() ? DependencySet.INDEPENDENT : x.hasMax1(role);
                    if (maxCardDS != null) {
                        ds = ds.union(maxCardDS);
                        if (edge != null) {
                            useExistingNode = true;
                            useExistingRole = true;
                        } else {
                            Set fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                            Iterator it = fs.iterator();
                            while (it.hasNext()) {
                                Role f = (Role)it.next();
                                edges = x.getRNeighborEdges(f);
                                if (edges.isEmpty()) continue;
                                if (useExistingNode) {
                                    Edge otherEdge = edges.edgeAt(0);
                                    Node otherNode = otherEdge.getNeighbor(x);
                                    DependencySet d = ds.union(edge.getDepends()).union(otherEdge.getDepends());
                                    this.mergeTo(y, otherNode, d);
                                    continue;
                                }
                                useExistingNode = true;
                                edge = edges.edgeAt(0);
                                y = edge.getNeighbor(x);
                            }
                            if (y != null) {
                                y = y.getSame();
                            }
                        }
                    }
                    if (useExistingNode) {
                        ds = ds.union(edge.getDepends());
                    } else {
                        y = this.abox.addFreshIndividual();
                        y.depth = x.depth + 1;
                        if (x.depth >= this.abox.treeDepth) {
                            this.abox.treeDepth = x.depth + 1;
                        }
                    }
                    if (ABox.DEBUG) {
                        System.out.println("SOME: " + x + " -> " + s + " -> " + y + " : " + c + (useExistingNode ? "" : " (*)") + " - " + ds);
                    }
                    this.addType(y, c, ds);
                    if (!useExistingRole) {
                        this.addEdge(x, role, y, ds);
                    }
                }
                if (!this.abox.isClosed() && !x.isMerged()) continue;
                return;
            }
            x.applyNext[Individual.SOME] = size;
        }
    }

    protected void applyDisjunctionRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = (Individual)i.next();
            node.setChanged(Node.OR, false);
            if (!node.canApply(Node.OR) || this.blocking.isIndirectlyBlocked(node)) continue;
            List types = node.getTypes(Node.OR);
            int size = types.size();
            ATermAppl[] disjunctions = new ATermAppl[size - node.applyNext[Node.OR]];
            types.subList(node.applyNext[Node.OR], size).toArray(disjunctions);
            if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
                DisjunctionSorting.sort(node, disjunctions);
            }
            int n = disjunctions.length;
            for (int j = 0; j < n; ++j) {
                ATermAppl disjunction = disjunctions[j];
                ATermAppl a = (ATermAppl)disjunction.getArgument(0);
                ATermList disjuncts = (ATermList)a.getArgument(0);
                ATerm[] disj = new ATerm[disjuncts.getLength()];
                int index = 0;
                while (!disjuncts.isEmpty()) {
                    disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
                    if (node.hasType(disj[index])) break;
                    disjuncts = disjuncts.getNext();
                    ++index;
                }
                if (!disjuncts.isEmpty()) continue;
                DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, this, node, disjunction, node.getDepends((ATerm)disjunction), disj);
                this.addBranch(newBranch);
                newBranch.tryNext();
                if (!this.abox.isClosed() && !node.isMerged()) continue;
                return;
            }
            node.applyNext[Node.OR] = size;
        }
    }

    protected boolean applyMaxRule(Individual x, Role r, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set neighbors = edges.getFilteredNeighbors(x);
        if (k == 0 && neighbors.size() > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                ds = ds.union(edge.getDepends());
            }
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = "Individual " + x + " should not have any value for property " + r;
            }
            this.abox.setClash(new Clash((Node)x, 4, ds, exp));
            return false;
        }
        if (neighbors.size() <= k) {
            return false;
        }
        List mergePairs = this.findMergeNodes(neighbors, x);
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1);
            if (dsEdges == null) {
                System.err.println("DEBUG: Cannot determine the exact clash dependency for " + x);
                this.abox.setClash(Clash.maxCardinality(x, ds));
                return false;
            }
            if (ABox.DEBUG) {
                System.out.println("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges), r.getName(), k));
            } else {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges)));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, this, x, r, k, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        return neighbors.size() > k + 1;
    }

    protected void applyMaxRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.canApply(Individual.MAX) || this.blocking.isIndirectlyBlocked(x)) continue;
            List maxCardinality = x.getTypes(Node.MAX);
            Iterator j = maxCardinality.iterator();
            while (j.hasNext()) {
                ATermAppl mc = (ATermAppl)j.next();
                ATermAppl max = (ATermAppl)mc.getArgument(0);
                Role r = this.abox.getRole(max.getArgument(0));
                int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
                DependencySet ds = x.getDepends((ATerm)mc);
                if (n == 1) {
                    this.applyFunctionalMaxRule(x, r, ds);
                    if (!this.abox.isClosed()) continue;
                    return;
                }
                boolean hasMore = true;
                do {
                    hasMore = this.applyMaxRule(x, r, n, ds);
                    if (this.abox.isClosed() || x.isMerged()) {
                        return;
                    }
                    if (!hasMore) continue;
                    ds = ds.union(new DependencySet(this.abox.getBranches().size()));
                } while (hasMore);
            }
            x.setChanged(Node.MAX, false);
        }
    }

    protected void applyMinRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.canApply(Node.MIN) || this.blocking.isBlocked(x)) continue;
            List types = x.getTypes(Node.MIN);
            int size = types.size();
            for (int j = x.applyNext[Node.MIN]; j < size; ++j) {
                int n;
                ATermAppl mc = (ATermAppl)types.get(j);
                Role r = this.abox.getRole(mc.getArgument(0));
                if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt())) continue;
                DependencySet ds = x.getDepends((ATerm)mc);
                if (ABox.DEBUG) {
                    System.out.println("MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this.abox.anonCount + 1 + " - anon") + (this.abox.anonCount + n) + " " + ds);
                }
                Node[] y = new Node[n];
                for (int c1 = 0; c1 < n; ++c1) {
                    if (r.isDatatypeRole()) {
                        y[c1] = this.abox.addLiteral();
                    } else {
                        y[c1] = this.abox.addFreshIndividual();
                        y[c1].depth = x.depth + 1;
                        if (x.depth >= this.abox.treeDepth) {
                            this.abox.treeDepth = x.depth + 1;
                        }
                    }
                    this.addEdge(x, r, y[c1], ds);
                    for (int c2 = 0; c2 < c1; ++c2) {
                        y[c1].setDifferent(y[c2], ds);
                    }
                }
                if (!this.abox.isClosed()) continue;
                return;
            }
            x.applyNext[Node.MIN] = size;
        }
    }

    protected void applyNominalRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual y = (Individual)i.next();
            if (!y.canApply(Individual.NOM) || this.blocking.isBlocked(y)) continue;
            this.applyNominalRule(y);
            y.setChanged(Node.NOM, false);
            if (this.abox.isClosed()) {
                return;
            }
            if (!y.isMerged()) continue;
            this.applyNominalRule((Individual)y.getSame());
        }
    }

    void applyNominalRule(Individual y) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            return;
        }
        List types = y.getTypes(Node.NOM);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl nc = (ATermAppl)types.get(j);
            DependencySet ds = y.getDepends((ATerm)nc);
            this.applyNominalRule(y, nc, ds);
            if (!this.abox.isClosed() && !y.isMerged()) continue;
            return;
        }
    }

    void applyNominalRule(Individual y, ATermAppl nc, DependencySet ds) {
        this.abox.copyOnWrite();
        ATerm nominal = nc.getArgument(0);
        Individual z = this.abox.getIndividual(nominal);
        if (z == null) {
            throw new InternalReasonerException("Nominal " + nominal + " not found in KB!");
        }
        while (z.isMerged()) {
            ds = ds.union(z.getMergeDependency());
            z = (Individual)z.getMergedTo();
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            ds = ds.union(y.getDifferenceDependency(z));
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.nominal(y, ds, z.getName()));
            } else {
                this.abox.setClash(Clash.nominal(y, ds));
            }
            return;
        }
        if (ABox.DEBUG) {
            System.out.println("NOM:  " + y + " -> " + z);
        }
        this.mergeTo(y, z, ds);
    }

    private void mergeFirst() {
        NodeMerge merge = (NodeMerge)this.mergeList.remove(0);
        Node y = this.abox.getNode((ATerm)merge.y).getSame();
        Node z = this.abox.getNode((ATerm)merge.z).getSame();
        if (y.isPruned() || z.isPruned()) {
            return;
        }
        this.mergeTo(y, z, merge.ds);
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            this.abox.setClash(Clash.nominal(y, y.getDifferenceDependency(z)));
            return;
        }
        if (this.merging) {
            this.mergeLater(y, z, ds);
            return;
        }
        this.merging = true;
        if (ABox.DEBUG) {
            System.out.println("MERG: " + y + " -> " + z + " " + ds);
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        if (y instanceof Literal && z instanceof Literal) {
            this.mergeLiterals((Literal)y, (Literal)z, ds);
        } else if (y instanceof Individual && z instanceof Individual) {
            this.mergeIndividuals((Individual)y, (Individual)z, ds);
        } else {
            throw new InternalReasonerException("Invalid merge operation!");
        }
        this.merging = false;
        if (!this.mergeList.isEmpty()) {
            if (this.abox.isClosed()) {
                return;
            }
            this.mergeFirst();
        }
    }

    private void mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        y.setSame(x, ds);
        x.setNominalLevel(Math.min(x.getNominalLevel(), y.getNominalLevel()));
        Map types = y.getDepends();
        Iterator yTypes = types.entrySet().iterator();
        while (yTypes.hasNext()) {
            Map.Entry entry = yTypes.next();
            ATermAppl yType = (ATermAppl)entry.getKey();
            DependencySet finalDS = ds.union((DependencySet)entry.getValue());
            this.addType(x, yType, finalDS);
        }
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends());
            if (y.equals(z)) {
                this.addEdge(x, r, x, finalDS);
            } else if (x.hasSuccessor(z)) {
                this.addEdge(x, r.getInverse(), z, finalDS);
            } else {
                this.addEdge(z, r, x, finalDS);
            }
            z.removeEdge(edge);
        }
        y.prune(ds);
        EdgeList outEdges = y.getOutEdges();
        for (int e = 0; e < outEdges.size(); ++e) {
            Edge edge = outEdges.edgeAt(e);
            Node z = edge.getTo();
            if (!z.isNominal() || y.equals(z)) continue;
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends());
            this.addEdge(x, r, z, finalDS);
        }
        x.inheritDifferents(y, ds);
    }

    private void mergeLiterals(Literal y, Literal x, DependencySet ds) {
        y.setSame(x, ds);
        if (y.isNominal() && x.isNominal() && !x.getValue().equals(y.getValue())) {
            throw new InternalReasonerException("Trying to merge two distinct literals.Literal1: " + y.toTypedString() + " Literal2: " + x.toTypedString());
        }
        x.addAllTypes(y.getDepends());
        Edge edge = y.getInEdge();
        Individual z = edge.getFrom();
        z.removeEdge(edge);
        if (!z.hasEdge(edge.getRole(), x)) {
            throw new InternalReasonerException("Cannot find expected edge " + edge);
        }
        y.prune(ds);
        x.inheritDifferents(y, ds);
    }

    List findMergeNodes(Set neighbors, Individual node) {
        Timer t = this.timers.startTimer("findMergeNodes");
        ArrayList<NodeMerge> pairs = new ArrayList<NodeMerge>();
        ArrayList nodes = new ArrayList(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = (Node)nodes.get(j);
                if (y.isDifferent(x)) continue;
                if (x.getNominalLevel() <= y.getNominalLevel()) {
                    pairs.add(new NodeMerge(y, x));
                    continue;
                }
                if (y.isNominal()) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                if (y.hasSuccessor(node)) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                pairs.add(new NodeMerge(y, x));
            }
        }
        t.stop();
        return pairs;
    }

    public void restore(Branch br) {
        this.abox.setBranch(br.branch);
        this.abox.setClash(null);
        this.abox.anonCount = br.anonCount;
        this.mergeList.clear();
        List nodeList = this.abox.getNodeNames();
        Map nodes = this.abox.getNodeMap();
        if (ABox.DEBUG) {
            System.out.println("RESTORE: Branch " + br.branch);
        }
        if (ABox.DEBUG && br.nodeCount < nodeList.size()) {
            System.out.println("Remove nodes " + nodeList.subList(br.nodeCount, nodeList.size()));
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATerm x = (ATerm)nodeList.get(i);
            Node node = this.abox.getNode(x);
            if (i >= br.nodeCount) {
                nodes.remove(x);
                continue;
            }
            node.restore(br.branch);
        }
        nodeList.subList(br.nodeCount, nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.applyAllValues(ind);
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        if (!this.abox.isClosed()) {
            this.abox.validate();
        }
    }

    void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        if (newBranch.branch != this.abox.getBranches().size()) {
            throw new RuntimeException("Invalid branch created!");
        }
        this.completionTimer.check();
    }

    void printBlocked() {
        int blockedCount = 0;
        String blockedNodes = "";
        IndividualIterator n = this.abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this.blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes = blockedNodes + x + " ";
        }
        System.out.println("Blocked nodes " + blockedCount + " [" + blockedNodes + "]");
    }

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }
}

