/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

class DisjunctionBranch
extends Branch {
    ATermAppl disjunction;
    ATerm[] disj;
    int[] order;

    DisjunctionBranch(ABox abox, CompletionStrategy completion, Individual x, ATermAppl disjunction, DependencySet ds, ATerm[] disj) {
        super(abox, completion, x, ds, disj.length);
        this.disjunction = disjunction;
        this.disj = disj;
        this.order = new int[disj.length];
        for (int i = 0; i < disj.length; ++i) {
            this.order[i] = i;
        }
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.node.getName());
        DisjunctionBranch b = new DisjunctionBranch(abox, null, x, this.disjunction, this.termDepends, this.disj);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.node.getName();
        b.strategy = this.strategy;
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void tryBranch() {
        this.abox.incrementBranch();
        int[] stats = null;
        if (PelletOptions.USE_DISJUNCT_SORTING) {
            stats = (int[])this.abox.disjBranchStats.get(this.disjunction);
            if (this.tryNext > 0) {
                if (stats == null) {
                    stats = new int[this.disj.length];
                    for (int i = 0; i < this.disj.length; ++i) {
                        stats[i] = 0;
                    }
                    this.abox.disjBranchStats.put(this.disjunction, stats);
                }
                int n = this.order[this.tryNext - 1];
                stats[n] = stats[n] + 1;
            }
            if (stats != null) {
                int minIndex = this.tryNext;
                int minValue = stats[this.tryNext];
                for (int i = this.tryNext + 1; i < stats.length; ++i) {
                    if (stats[i] >= minValue) continue;
                    minIndex = i;
                    minValue = stats[i];
                }
                if (minIndex != this.tryNext) {
                    ATerm selDisj = this.disj[minIndex];
                    this.disj[minIndex] = this.disj[this.tryNext];
                    this.disj[this.tryNext] = selDisj;
                    this.order[minIndex] = this.tryNext;
                    this.order[this.tryNext] = minIndex;
                }
            }
        }
        while (this.tryNext < this.tryCount) {
            ATermAppl notD;
            DependencySet clashDepends;
            ATermAppl d = (ATermAppl)this.disj[this.tryNext];
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.tryNext; ++m) {
                    this.strategy.addType(this.node, ATermUtils.negate((ATermAppl)this.disj[m]), this.prevDS[m]);
                }
            }
            DependencySet ds = null;
            if (this.tryNext == this.tryCount - 1) {
                ds = this.termDepends;
                for (int m = 0; m < this.tryNext; ++m) {
                    ds = ds.union(this.prevDS[m]);
                }
                ds.remove(this.branch);
            } else {
                ds = new DependencySet(this.branch);
            }
            if (ABox.DEBUG) {
                System.out.println("DISJ: Branch (" + this.branch + ") try (" + (this.tryNext + 1) + "/" + this.tryCount + ") " + this.node.getName() + " " + d + " " + this.disjunction + " " + ds);
            }
            if ((clashDepends = this.node.getDepends((ATerm)(notD = ATermUtils.negate(d)))) == null) {
                this.strategy.addType(this.node, d, ds);
                if (this.abox.isClosed()) {
                    clashDepends = this.abox.getClash().depends;
                }
            } else {
                clashDepends = clashDepends.union(ds);
            }
            if (clashDepends == null) return;
            if (ABox.DEBUG) {
                System.out.println("CLASH: Branch " + this.branch + " " + Clash.atomic(this.node, clashDepends, d) + "!");
            }
            if (PelletOptions.USE_DISJUNCT_SORTING) {
                if (stats == null) {
                    stats = new int[this.disj.length];
                    for (int i = 0; i < this.disj.length; ++i) {
                        stats[i] = 0;
                    }
                    this.abox.disjBranchStats.put(this.disjunction, stats);
                }
                int n = this.order[this.tryNext];
                stats[n] = stats[n] + 1;
            }
            if (this.tryNext < this.tryCount - 1 && clashDepends.contains(this.branch)) {
                if (this.abox.isClosed()) {
                    this.strategy.restore(this);
                    this.abox.incrementBranch();
                }
            } else {
                if (this.abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this.abox.setClash(Clash.atomic(this.node, clashDepends.union(ds), positive));
                    return;
                } else {
                    this.abox.setClash(Clash.atomic(this.node, clashDepends.union(ds)));
                }
                return;
            }
            this.prevDS[this.tryNext] = clashDepends;
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }
}

