/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class Node {
    public static boolean DEBUG = false;
    public static int BLOCKABLE = Integer.MAX_VALUE;
    public static int NOMINAL = 0;
    public static int CHANGED = 127;
    public static int UNCHANGED = 0;
    public static int ATOM = 0;
    public static int OR = 1;
    public static int SOME = 2;
    public static int ALL = 3;
    public static int MIN = 4;
    public static int MAX = 5;
    public static int NOM = 6;
    public static int TYPES = 7;
    private String ontology;
    private int status;
    protected ABox abox;
    protected ATermAppl name;
    protected Map depends;
    protected int depth = 1;
    private boolean isRoot;
    private boolean isConceptRoot;
    protected Node mergedTo = this;
    protected DependencySet mergeDepends = null;
    protected DependencySet pruned = null;
    protected Set merged;
    protected Map differents;
    int branch;

    protected Node(ATermAppl name, ABox abox) {
        this.name = name;
        this.abox = abox;
        if (abox != null) {
            this.ontology = abox.getKB().getOntology();
        }
        this.isRoot = !name.getName().startsWith("anon");
        this.isConceptRoot = false;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.differents = new HashMap();
        this.depends = new HashMap();
        this.branch = 0;
        this.status = CHANGED;
    }

    protected Node(Node node, ABox abox) {
        this.name = node.getName();
        this.abox = abox;
        this.ontology = node.ontology;
        this.isRoot = node.isRoot;
        this.isConceptRoot = node.isConceptRoot;
        this.mergeDepends = node.mergeDepends;
        this.mergedTo = node.mergedTo;
        this.merged = node.merged;
        this.pruned = node.pruned;
        this.differents = node.differents;
        this.depends = new HashMap(node.depends);
        this.branch = node.branch;
        this.status = CHANGED;
    }

    protected void updateNodeReferences() {
        Node node;
        this.mergedTo = this.abox.getNode((ATerm)this.mergedTo.getName());
        HashMap diffs = new HashMap(this.differents.size());
        Iterator i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            node = (Node)entry.getKey();
            diffs.put(this.abox.getNode((ATerm)node.getName()), entry.getValue());
        }
        this.differents = diffs;
        if (this.merged != null) {
            HashSet<Node> sames = new HashSet<Node>(this.merged.size());
            Iterator i2 = this.merged.iterator();
            while (i2.hasNext()) {
                node = (Node)i2.next();
                sames.add(this.abox.getNode((ATerm)node.getName()));
            }
            this.merged = sames;
        }
    }

    public final Node copy() {
        return this.copyTo(null);
    }

    public final boolean isChanged() {
        return this.status != UNCHANGED;
    }

    public final boolean isChanged(int type) {
        return (this.status & 1 << type) != 0;
    }

    public final void setChanged(boolean changed) {
        this.status = changed ? CHANGED : UNCHANGED;
    }

    public void setOntology(String ont) {
        this.ontology = ont;
    }

    public String getOntology() {
        return this.ontology;
    }

    public void setChanged(int type, boolean changed) {
        this.status = changed ? (this.status |= 1 << type) : (this.status &= ~(1 << type));
    }

    public boolean isConceptRoot() {
        return this.isConceptRoot;
    }

    public void setConceptRoot(boolean isConceptRoot) {
        this.isConceptRoot = isConceptRoot;
    }

    public final boolean isBnode() {
        return this.name.getName().startsWith("bNode");
    }

    public final boolean isNamedIndividual() {
        return this.isRoot && !this.isBnode();
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public abstract boolean isLeaf();

    public boolean isRootNominal() {
        return this.isRoot && this.isNominal();
    }

    public abstract Node copyTo(ABox var1);

    protected abstract void addInEdge(Edge var1);

    public abstract boolean removeInEdge(Edge var1);

    public abstract EdgeList getInEdges();

    public abstract void removeInEdges();

    public boolean restore(int branch) {
        DependencySet d;
        ATermAppl c;
        if (this.pruned != null) {
            if (this.pruned.branch > branch) {
                if (DEBUG) {
                    System.out.println("RESTORE: " + this + " merged node " + this.mergedTo + " " + this.mergeDepends);
                }
                if (this.mergeDepends.branch > branch) {
                    this.undoSetSame();
                }
                this.unprune(branch);
            } else {
                if (DEBUG) {
                    System.out.println("DO NOT RESTORE: pruned node " + this + " = " + this.mergedTo + " " + this.mergeDepends);
                }
                return false;
            }
        }
        ArrayList<ATermAppl> conjunctions = new ArrayList<ATermAppl>();
        this.status = CHANGED;
        Iterator i = this.getTypes().iterator();
        while (i.hasNext()) {
            boolean removeType;
            c = (ATermAppl)i.next();
            d = this.getDepends((ATerm)c);
            boolean bl = PelletOptions.USE_SMART_RESTORE ? d.max() >= branch : (removeType = d.branch > branch);
            if (removeType) {
                if (DEBUG) {
                    System.out.println("RESTORE: " + this.name + " remove type " + c + " " + d + " " + branch);
                }
                i.remove();
                this.removeType(c);
                continue;
            }
            if (!PelletOptions.USE_SMART_RESTORE || !ATermUtils.isAnd(c)) continue;
            conjunctions.add(c);
        }
        if (PelletOptions.USE_SMART_RESTORE) {
            i = conjunctions.iterator();
            while (i.hasNext()) {
                c = (ATermAppl)i.next();
                d = this.getDepends((ATerm)c);
                ATermList cs = (ATermList)c.getArgument(0);
                while (!cs.isEmpty()) {
                    ATermAppl conj = (ATermAppl)cs.getFirst();
                    this.addType(conj, d);
                    cs = cs.getNext();
                }
            }
        }
        i = this.getInEdges().iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            d = e.getDepends();
            if (d.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("RESTORE: " + this.name + " delete reverse edge " + e);
            }
            i.remove();
        }
        i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Node node = (Node)entry.getKey();
            DependencySet d2 = (DependencySet)entry.getValue();
            if (d2.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("RESTORE: " + this.name + " delete difference " + node);
            }
            i.remove();
        }
        return true;
    }

    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isMerged()) {
            throw new InternalReasonerException("Adding type to a merged node " + this + " " + c);
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
    }

    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.status = CHANGED;
    }

    public boolean hasType(ATerm c) {
        return this.depends.containsKey(c);
    }

    public abstract Individual getParent();

    public final Set getPredecessors() {
        return this.getInEdges().getPredecessors();
    }

    final boolean hasPredecessor(Individual x) {
        return x.hasSuccessor(this);
    }

    public abstract boolean hasSuccessor(Node var1);

    public final DependencySet getDepends(ATerm c) {
        return (DependencySet)this.depends.get(c);
    }

    public final Map getDepends() {
        return this.depends;
    }

    public final Set getTypes() {
        return this.depends.keySet();
    }

    public void removeTypes() {
        this.depends.clear();
        this.status = CHANGED;
    }

    public final int prunedAt() {
        return this.pruned.branch;
    }

    public final boolean isPruned() {
        return this.pruned != null;
    }

    public final DependencySet getPruned() {
        return this.pruned;
    }

    public abstract void prune(DependencySet var1);

    public abstract void unprune(int var1);

    public abstract int getNominalLevel();

    public abstract boolean isNominal();

    public abstract boolean isBlockable();

    public abstract boolean isLiteral();

    public abstract boolean isIndividual();

    public final int mergedAt() {
        return this.mergeDepends.branch;
    }

    public final boolean isMerged() {
        return this.mergedTo != this;
    }

    public final Node getMergedTo() {
        return this.mergedTo;
    }

    public final DependencySet getMergeDependency() {
        return this.mergeDepends;
    }

    public Node getSame() {
        if (this.mergedTo == this) {
            return this;
        }
        return this.mergedTo.getSame();
    }

    public void undoSetSame() {
        this.mergedTo.removeMerged(this);
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.mergedTo = this;
    }

    private void addMerged(Node node) {
        if (this.merged == null) {
            this.merged = new HashSet(3);
        }
        this.merged.add(node);
    }

    private void removeMerged(Node node) {
        this.merged.remove(node);
        if (this.merged.isEmpty()) {
            this.merged = null;
        }
    }

    public final void setSame(Node node, DependencySet ds) {
        if (this.isSame(node)) {
            return;
        }
        if (this.isDifferent(node)) {
            throw new RuntimeException("Trying to set two distinct nodes equal " + this.name + ", " + node.getNameStr() + " " + ds);
        }
        this.mergedTo = node;
        this.mergeDepends = ds.copy();
        this.mergeDepends.branch = this.abox.getBranch();
        node.addMerged(this);
    }

    public boolean isSame(Node node) {
        return this.getSame().equals(node.getSame());
    }

    public boolean isDifferent(Node node) {
        return this.differents.containsKey(node);
    }

    public void setDifferent(Node node, DependencySet ds) {
        if (this.isDifferent(node)) {
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        this.differents.put(node, ds);
        node.setDifferent(this, ds);
    }

    public void inheritDifferents(Node y, DependencySet ds) {
        Iterator yDiffs = y.differents.entrySet().iterator();
        while (yDiffs.hasNext()) {
            Map.Entry entry = yDiffs.next();
            Individual yDiff = (Individual)entry.getKey();
            DependencySet finalDS = ds.union((DependencySet)entry.getValue());
            this.setDifferent(yDiff, finalDS);
        }
    }

    public Set getDifferents() {
        return this.differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return (DependencySet)this.differents.get(node);
    }

    public Map getDifferenceDependency() {
        return this.differents;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public final ATermAppl getName() {
        return this.name;
    }

    public abstract ATermAppl getTerm();

    public final String getNameStr() {
        return this.name.getName();
    }

    public String toString() {
        return this.name.getName();
    }

    public final List getPath() {
        LinkedList<ATermAppl> path = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            path.add(this.name);
        } else {
            Node node = this;
            while (!node.getInEdges().isEmpty()) {
                Edge inEdge = node.getInEdges().edgeAt(0);
                node = inEdge.getFrom();
                path.addFirst(inEdge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                path.addFirst(node.getName());
                break;
            }
        }
        return path;
    }

    public ABox getABox() {
        return this.abox;
    }
}

