/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.shared.JenaException;
import java.io.ByteArrayInputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.OWLSpecies;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class Pellet {
    public static boolean DEBUG = false;
    String inFile = null;
    String inString = null;
    String inFormat = null;
    String conclusionsFile = null;
    String conclusionsString = null;
    String conclusionsFormat = null;
    String outFile = null;
    String queryFile = null;
    String queryString = null;
    String classifyFormat = "none";
    boolean checkConsistency = true;
    boolean realize = false;
    boolean findUnsat = false;
    boolean quiet = false;
    boolean econnEnabled = false;
    boolean printTiming = false;
    Timers timers;
    ModelReader modelReader;
    List parseErrors;
    OWLReasoner reasoner;
    Set unsatClasses;
    Query query;
    QueryResults queryResults;
    OutputFormatter out = new OutputFormatter();
    int timeout = -1;

    public Pellet() {
        this.unsatClasses = new HashSet();
        this.modelReader = new ModelReader();
        this.parseErrors = new ArrayList();
        this.timers = new Timers();
        this.modelReader.setErrorHandler(new RDFErrorHandler(){

            public void warning(Exception e) {
                Pellet.this.parseErrors.add(ParseException.formatMessage((Exception)e));
            }

            public void error(Exception e) {
                Pellet.this.parseErrors.add(ParseException.formatMessage((Exception)e));
            }

            public void fatalError(Exception e) {
                throw new JenaException((Throwable)e);
            }
        });
    }

    private void loadInput() {
        Timer t = this.timers.startTimer("Loading");
        if (this.inFile != null) {
            if (this.inString != null) {
                throw new RuntimeException("Both an input url and text is given.");
            }
        } else if (this.inString == null) {
            String string = this.inFile = this.query != null ? this.query.getSourceURL() : null;
            if (this.inFile == null) {
                this.out.println("No input file is given!");
                if (!this.out.isFormatHTML()) {
                    Pellet.usage();
                }
                this.out.flush();
                System.exit(1);
            }
        } else if (this.econnEnabled) {
            System.err.println("The URI of the input should be given when E-connections are enabled!");
            System.exit(0);
        }
        this.reasoner = new OWLReasoner();
        if (this.econnEnabled) {
            this.out.printBold("Input file: ").printLink(this.inFile).println();
            this.reasoner.setEconnEnabled(true);
            this.reasoner.load(this.inFile);
        } else {
            Model model = null;
            if (this.inFile != null) {
                this.out.printBold("Input file: ").printLink(this.inFile).println();
                model = this.modelReader.read(this.inFile, this.inFormat);
            } else {
                this.out.printBold("Input file: ").println("Text area");
                model = this.modelReader.read(new ByteArrayInputStream(this.inString.getBytes()), this.inFormat);
            }
            if (model != null) {
                this.reasoner.load(model);
            }
            this.printParseErrors();
        }
        if (this.timeout > 0) {
            this.reasoner.getKB().setTimeout(this.timeout * 1000);
        }
        t.stop();
    }

    private void printParseErrors() {
        if (!this.parseErrors.isEmpty()) {
            this.out.printBold("Problems encountered parsing RDF:").println();
            Iterator iter = this.parseErrors.iterator();
            while (iter.hasNext()) {
                this.out.println(iter.next());
            }
        }
        this.out.flush();
    }

    private OWLSpecies checkSpecies() {
        Timer t = this.timers.startTimer("Species Validation");
        OWLSpecies species = this.reasoner.getSpecies();
        this.out.printBold("OWL Species: ").println(species);
        if (this.econnEnabled) {
            this.out.printBold("DL Expressivity: ").println(((EconnectedKB)this.reasoner.getKB()).getEconnExpressivity());
        } else {
            this.out.printBold("DL Expressivity: ").println(this.reasoner.getKB().getExpressivity());
        }
        t.stop();
        return species;
    }

    private void checkConsistency() {
        if (!this.checkConsistency) {
            return;
        }
        Timer t = this.timers.startTimer("Preprocessing");
        this.reasoner.getKB().prepare();
        t.stop();
        if (this.checkConsistency) {
            t = this.timers.startTimer("Consistency");
            this.reasoner.isConsistent();
            t.stop();
        }
        boolean isConsistent = this.reasoner.isConsistent();
        this.out.printBold("Consistent: ");
        if (isConsistent) {
            this.out.println("Yes");
        } else {
            this.out.printHTML("<font color=Red><b>").print("No").printHTML("</b></font>").println();
            this.out.printBold("Reason: ").println(this.reasoner.getKB().getExplanation());
        }
    }

    private void checkConclusions() {
        if (this.conclusionsFile != null && this.conclusionsString != null) {
            throw new RuntimeException("Both a conclusions url and text is given.");
        }
        if (this.conclusionsFile == null && this.conclusionsString == null) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        Model coModel = null;
        coModel = this.conclusionsFile != null ? this.modelReader.read(this.conclusionsFile, this.conclusionsFormat) : this.modelReader.read(new ByteArrayInputStream(this.conclusionsString.getBytes()), this.conclusionsFormat);
        boolean isEntailed = this.reasoner.isEntailed(coModel);
        this.out.printBold("Entailed: ").print(isEntailed ? "Yes" : "No").println();
    }

    private void checkUnsat() {
        if (!this.findUnsat && !this.reasoner.getKB().isClassified()) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        Iterator i = this.reasoner.getKB().getClasses().iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (this.reasoner.getKB().isSatisfiable(c)) continue;
            this.unsatClasses.add(c);
        }
    }

    private boolean doClassify() {
        if (this.classifyFormat.equals("none") || !this.reasoner.isConsistent()) {
            return false;
        }
        Timer t = this.timers.startTimer("Classification");
        this.reasoner.classify();
        t.stop();
        if (this.realize) {
            t = this.timers.startTimer("Realization");
            this.reasoner.realize();
            t.stop();
        }
        return true;
    }

    private void printClassTree() {
        if (!this.reasoner.getKB().isClassified()) {
            return;
        }
        this.out.println();
        this.out.printBold("Classification:").println();
        if (this.classifyFormat.equals("tree")) {
            this.reasoner.getKB().printClassTree(this.out);
        } else {
            boolean verbose;
            if (this.classifyFormat.equals("rdf")) {
                verbose = false;
            } else if (this.classifyFormat.equals("rdf-all")) {
                verbose = true;
            } else {
                throw new RuntimeException("Invalid format to display classification");
            }
            this.out.printHTML("<xmp>");
            this.reasoner.extractModel(verbose).write((Writer)this.out.getWriter(), "RDF/XML-ABBREV");
            this.out.printHTML("</xmp>");
            this.out.flush();
        }
    }

    private void printUnsat() {
        if (this.unsatClasses.isEmpty()) {
            return;
        }
        this.out.printParagraph().printBold("Unsatisfiable Concepts").println();
        Iterator i = this.unsatClasses.iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            this.out.printURI(name);
            if (!i.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println();
    }

    private void printTimeInfo() {
        this.out.printBold("Time: ").println(this.getTimeInfo());
    }

    private void loadQuery() {
        if (this.queryFile != null && this.queryString != null) {
            throw new RuntimeException("Both a query url and text is given.");
        }
        if (this.queryFile == null && this.queryString == null) {
            return;
        }
        Timer t = this.timers.startTimer("Loading");
        try {
            if (this.queryString == null) {
                this.queryString = FileUtils.readURL(new URL(this.queryFile));
            }
            this.query = new Query(this.queryString);
        }
        catch (Exception e) {
            this.out.printBold("Error: ").println("Query cannot be loaded");
            this.out.print(e);
            this.out.flush();
        }
        t.stop();
    }

    private void runQuery() {
        if (this.query == null) {
            return;
        }
        if (!this.reasoner.isConsistent()) {
            return;
        }
        this.queryResults = this.reasoner.runQuery(this.query.toString());
    }

    private void printQueryResults() {
        if (this.query == null) {
            return;
        }
        this.out.println();
        this.out.printBold("Query: ").println();
        this.out.printHTML("<pre>");
        if (this.out.isFormatHTML()) {
            this.out.print(this.queryString.trim().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        } else {
            this.out.println(this.queryString.trim());
        }
        this.out.printHTML("</pre>");
        this.out.println("-----------------------------------------------------");
        QueryResultsFormatter formatter = new QueryResultsFormatter(this.queryResults);
        this.out.printBold("Query Results: ").println();
        if (this.queryResults.hasNext()) {
            if (this.out.isFormatHTML()) {
                formatter.printHTML(this.out.getWriter());
            } else {
                formatter.printAll(this.out.getWriter());
            }
        } else {
            this.out.printBold("NO RESULTS").println();
        }
    }

    public void run() {
        try {
            Timer t = this.timers.startTimer("totalTime");
            this.loadQuery();
            this.loadInput();
            this.checkSpecies();
            this.checkConsistency();
            this.checkConclusions();
            this.doClassify();
            this.checkUnsat();
            this.runQuery();
            t.stop();
            this.printTimeInfo();
            this.printUnsat();
            this.printClassTree();
            this.printQueryResults();
            this.printSpeciesReport();
            if (this.printTiming) {
                this.reasoner.getKB().timers.print();
            }
        }
        catch (JenaException e) {
            this.out.printBold("Unrecoverable error while parsing RDF:").println();
            this.out.println(ParseException.formatMessage((Exception)((Object)e)));
            this.out.println();
            this.out.println("Cannot process file due to parse error!");
            throw e;
        }
        catch (TimeoutException e) {
            this.out.printParagraph().printBold("TIMEOUT:").println("Timeout after " + this.timeout + " seconds");
        }
        catch (UnsupportedFeatureException e) {
            this.out.printParagraph().printBold("Unsupported features in input:");
            this.out.println(e.getMessage());
            throw e;
        }
        finally {
            this.out.flush();
        }
    }

    private void printSpeciesReport() {
        if (this.quiet) {
            return;
        }
        this.out.printParagraph();
        OWLSpecies species = this.reasoner.getSpecies();
        species.getReport().print(this.out);
        if (species.getLevel() == 2) {
            this.out.printParagraph().printBold("Add the following statements to make this document OWL DL").println();
            if (species.missingTriples != null) {
                this.out.printHTML("<xmp>");
                try {
                    RDFWriter rdfWriter = species.missingTriples.getWriter();
                    rdfWriter.setProperty("allowBadURIs", (Object)"true");
                    rdfWriter.write(species.missingTriples, (Writer)this.out.getWriter(), null);
                }
                catch (Exception e) {
                    this.out.print("Following error occured when trying to print the missing triples " + e);
                    e.printStackTrace();
                    StmtIterator si = species.missingTriples.listStatements();
                    while (si.hasNext()) {
                        System.err.println(si.next());
                    }
                }
                this.out.printHTML("</xmp>");
            } else {
                this.out.println("This ontology cannot be converted to OWL DL.");
            }
        }
    }

    public String getTimeInfo() {
        String timeInfo = this.timers.getTimer("totalTime").getTotal() + " ms (";
        timeInfo = timeInfo + this.getTimerString("Loading");
        timeInfo = timeInfo + this.getTimerString("Preprocessing");
        timeInfo = timeInfo + this.getTimerString("Species Validation");
        timeInfo = timeInfo + this.getTimerString("Consistency");
        timeInfo = timeInfo + this.getTimerString("Entailment");
        timeInfo = timeInfo + this.getTimerString("Unsatisfiability");
        timeInfo = timeInfo + this.getTimerString("Classification");
        timeInfo = timeInfo + this.getTimerString("Realization");
        timeInfo = timeInfo + ")";
        return timeInfo;
    }

    private String getTimerString(String name) {
        String info = "";
        Timer t = this.timers.getTimer(name);
        if (t != null) {
            info = name + ": " + t.getTotal() + " ";
        }
        return info;
    }

    public void setClassifyFormat(String format) {
        this.classifyFormat = format.toLowerCase();
    }

    public void setConclusionsFile(String string) {
        this.conclusionsFile = string;
    }

    public void setConclusionsFormat(String string) {
        this.conclusionsFormat = string;
    }

    public void setConclusionsString(String string) {
        this.conclusionsString = string;
    }

    public void setFormatHTML(boolean b) {
        this.out.setFormatHTML(b);
    }

    public void setInFile(String string) {
        this.inFile = string;
    }

    public void setInFormat(String string) {
        this.inFormat = string;
    }

    public void setInString(String string) {
        this.inString = string;
    }

    public void setPrintTiming(boolean value) {
        this.printTiming = value;
    }

    public void setQueryFile(String string) {
        this.queryFile = string;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void setTimeout(int i) {
        this.timeout = i;
    }

    public void setQuiet(boolean b) {
        this.quiet = b;
    }

    public void setConsistency(boolean b) {
        this.checkConsistency = b;
    }

    public void setRealize(boolean b) {
        this.realize = b;
    }

    public void setUnsat(boolean b) {
        this.findUnsat = b;
    }

    static void usage() {
        System.out.println("Pellet - OWL DL Reasoner");
        System.out.println("For the OWL ontologies Pellet provides options find the ontology level");
        System.out.println("(Lite, DL, FULL), check consistency, find unsatisfiable concepts, ");
        System.out.println("display class hierarchy, save OWL Full ontologies as OWL DL, ");
        System.out.println("check if triples in another ontology is entailed by the input");
        System.out.println("ontology");
        System.out.println("");
        System.out.println("Usage: java Pellet [-inputFile file]");
        System.out.println("   -inputFile file           Input ontology, a uri or a local file");
        System.out.println("   -inputString string       A string representation of the input file");
        System.out.println("   -inputFormat format       Format of the input file, ");
        System.out.println("                             one of [RDF/XML, N3, NTRIPLES]");
        System.out.println("   -quick              \t     Find ontology level, don't check consistency");
        System.out.println("   -unsat              \t     Find the unsatisfiable classes in the ontology");
        System.out.println("   -classify format          Classify the ontology and display the hierachy in");
        System.out.println("                             one of the formats [TREE, RDF, RDF-ALL]. If real-");
        System.out.println("                             ize option is selected, types for individuals are");
        System.out.println("                             also printed");
        System.out.println("                             TREE: Display the hierarchy as an indented tree");
        System.out.println("                             RDF: Display direct subclass relations in RDF/XML");
        System.out.println("                             RDF-ALL: Display all subclass relations in RDF/XML");
        System.out.println("   -realize                  Find and print the classes each individual belongs");
        System.out.println("                             to. When this option is enabled classification");
        System.out.println("                             will be automatically done");
        System.out.println("   -conclusionsFile file     Check if all the triples in this ontology is");
        System.out.println("                             entailed by the input ontology");
        System.out.println("   -conclusionsString string A string representation of the conclusions file");
        System.out.println("   -conclusionsFormat format Format of the conclusions file,");
        System.out.println("                             one of [RDF/XML, N3, NTRIPLES]");
        System.out.println("   -queryFile file           Read the RDQL query from the given file and run it");
        System.out.println("                             on the input ontology");
        System.out.println("   -queryString string       Run the given RDQL query on the input ontology");
        System.out.println("   -econn                    Enable E-Connected ontologies");
        System.out.println("   -timeout time             Timeout after <time> seconds");
        System.out.println("   -timing                   Print detailed timing information");
        System.out.println("   -quiet                    Don't print warning messages");
        System.out.println("   -help                     Print this message");
    }

    public static final void main(String[] args) throws Exception {
        Pellet pellet = new Pellet();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                Pellet.usage();
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-classify")) {
                pellet.setClassifyFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-inputFile")) {
                pellet.setInFile(FileUtils.toURI(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-inputFormat")) {
                pellet.setInFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-inputString")) {
                pellet.setInString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsFile")) {
                pellet.setConclusionsFile(FileUtils.toURI(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsFormat")) {
                pellet.setConclusionsFormat(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-conclusionsString")) {
                pellet.setConclusionsString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-queryFile")) {
                pellet.setQueryFile(FileUtils.toURI(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-queryString")) {
                pellet.setQueryString(args[++i]);
                continue;
            }
            if (arg.equalsIgnoreCase("-timeout")) {
                pellet.setTimeout(Integer.parseInt(args[++i]));
                continue;
            }
            if (arg.equalsIgnoreCase("-econn")) {
                pellet.setEconnEnabled(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-html")) {
                pellet.setFormatHTML(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-text")) {
                pellet.setFormatHTML(false);
                continue;
            }
            if (arg.equalsIgnoreCase("-quick")) {
                pellet.setConsistency(false);
                continue;
            }
            if (arg.equalsIgnoreCase("-unsat")) {
                pellet.setUnsat(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-realize")) {
                pellet.setRealize(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-quiet")) {
                pellet.setQuiet(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-timing")) {
                pellet.setPrintTiming(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-debug")) {
                String which;
                if ((which = args[++i]).equalsIgnoreCase("abox")) {
                    ABox.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("reasoner")) {
                    OWLReasoner.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("classify")) {
                    Taxonomy.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("kb")) {
                    KnowledgeBase.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("pellet")) {
                    DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("species")) {
                    OWLSpecies.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("query")) {
                    QueryEngine.DEBUG = true;
                    continue;
                }
                if (which.equalsIgnoreCase("all")) {
                    ABox.DEBUG = true;
                    OWLReasoner.DEBUG = true;
                    Taxonomy.DEBUG = true;
                    DEBUG = true;
                    continue;
                }
                System.err.println("Invalid debug option");
                Pellet.usage();
                System.exit(1);
                continue;
            }
            System.err.println("Unrecognized option: " + arg);
            Pellet.usage();
            System.exit(1);
        }
        pellet.run();
    }

    public void setEconnEnabled(boolean econnEnabled) {
        this.econnEnabled = econnEnabled;
    }
}

