/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Properties;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.PelletErrorForm;

public class PelletCGI {
    public static void main(String[] args) {
        PelletCGI.printHeader();
        Pellet pellet = null;
        try {
            BufferedReader in = args.length == 0 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new StringReader(args[0]));
            String queryString = in.readLine();
            Properties params = PelletCGI.parseArgs(queryString);
            pellet = new Pellet();
            pellet.setFormatHTML(true);
            pellet.setTimeout(60);
            pellet.setInFile(params.getProperty("inputFile"));
            pellet.setInFormat(params.getProperty("inputFormat"));
            pellet.setInString(params.getProperty("inputString"));
            pellet.setConclusionsFile(params.getProperty("conclusionsFile"));
            pellet.setConclusionsFormat(params.getProperty("conclusionsFormat"));
            pellet.setConclusionsString(params.getProperty("conclusionsString"));
            pellet.setClassifyFormat(params.getProperty("classifyFormat"));
            pellet.setQueryFile(params.getProperty("queryFile"));
            pellet.setQueryString(params.getProperty("queryString"));
            pellet.setConsistency(params.getProperty("Consistency") != null);
            pellet.setUnsat(params.getProperty("Unsat") != null);
            pellet.setRealize(params.getProperty("Realize") != null);
            pellet.setEconnEnabled(params.getProperty("Econn") != null);
            pellet.run();
            System.out.println(PelletErrorForm.getForm2(pellet));
        }
        catch (Exception e) {
            if (pellet != null) {
                System.out.println(PelletErrorForm.getForm(e, pellet));
            } else {
                e.printStackTrace(System.out);
            }
            System.out.flush();
        }
        PelletCGI.printFooter();
    }

    public static Properties parseArgs(String queryString) throws Exception {
        Properties props = new Properties();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            String decoded = URLDecoder.decode(p[1], "ISO-8859-1");
            props.setProperty(p[0], decoded);
        }
        return props;
    }

    public static void printHeader() {
        System.out.println("<html>");
        System.out.println("<head>");
        System.out.println("<title>Pellet Results</title>");
        System.out.println("<style>");
        System.out.println("table {");
        System.out.println("  background-color:#FFF;");
        System.out.println("  border-collapse:collapse;");
        System.out.println("}");
        System.out.println("th {");
        System.out.println("  background-color:#FFF;");
        System.out.println("  border:2px solid black;");
        System.out.println("  padding:2px;");
        System.out.println("}");
        System.out.println("td {");
        System.out.println("  background-color:#FFF;");
        System.out.println("  border:2px solid black;");
        System.out.println("  padding:2px;");
        System.out.println("}");
        System.out.println("td.NoBorder {");
        System.out.println("  background-color:#FFF;");
        System.out.println("  border: none;");
        System.out.println("  padding:2px;");
        System.out.println("}");
        System.out.println("</style>");
        System.out.println("</head>");
        System.out.println("<body>");
        System.out.println("<H1>Results</H1>");
    }

    public static void printFooter() {
        System.out.println("</body>");
        System.out.println("</html>");
    }
}

