/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Properties;
import org.mindswap.pellet.PelletCGI;
import org.mindswap.pellet.PelletQuery;

public class PelletQueryCGI
extends PelletCGI {
    public static void main(String[] args) {
        RunThread thread = new RunThread(args);
        thread.start();
        int timeout = 300;
        try {
            thread.join(timeout * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            System.out.print("<p><b>TIMEOUT</b>: Timeout after " + timeout + " seconds");
        }
        System.exit(0);
    }

    static class RunThread
    extends Thread {
        String[] args;

        public RunThread(String[] args) {
            this.args = args;
        }

        public void run() {
            try {
                String rdqlQuery = null;
                if (this.args.length == 1) {
                    String queryString = this.args[0];
                    Properties params = PelletCGI.parseArgs(queryString);
                    rdqlQuery = params.getProperty("query");
                }
                System.out.println("<H1>Pellet Query Engine</H1>");
                System.out.println("Enter a RDQL query in the text area<p>");
                System.out.println("<textarea cols=85 rows=8 name=query wrap=off>");
                if (rdqlQuery != null) {
                    System.out.println(rdqlQuery);
                }
                System.out.println("</textarea>");
                System.out.println("<p><input type=\"button\" value=\"Run Query\" name=\"submitBtn\" onclick=\"sendIt()\">");
                if (rdqlQuery != null) {
                    System.out.println("<H1>Results</H1>");
                    PelletQuery pelletQuery = new PelletQuery();
                    pelletQuery.setFormatHTML(true);
                    pelletQuery.run(rdqlQuery);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.flush();
            }
        }
    }
}

