/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.utils.URIUtils;

public class RoleTaxonomyBuilder {
    private byte PROPOGATE_UP = 1;
    private byte NO_PROPOGATE = 0;
    private byte PROPOGATE_DOWN = (byte)-1;
    protected Collection properties;
    protected Taxonomy taxonomy;
    protected RBox rbox;

    public RoleTaxonomyBuilder(RBox rbox) {
        this.rbox = rbox;
        this.properties = rbox.getRoles();
        this.taxonomy = new Taxonomy(true);
    }

    public Taxonomy classify() {
        if (Taxonomy.DEBUG) {
            System.out.println("Properties: " + this.properties.size());
        }
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            Role c = (Role)i.next();
            if (c.isAnnotationRole() || c.isOntologyRole()) continue;
            this.classify(c);
        }
        return this.taxonomy;
    }

    private void classify(Role c) {
        TaxonomyNode sup;
        boolean hide = c.isAnon();
        if (this.taxonomy.contains(c.getName())) {
            return;
        }
        HashMap marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        Collection supers = this.search(true, c, this.taxonomy.getTop(), new HashSet(), new ArrayList(), marked);
        marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        if (supers.size() == 1 && this.subsumed(sup = (TaxonomyNode)supers.iterator().next(), c, marked)) {
            if (Taxonomy.DEBUG) {
                System.out.println(this.getName(c.getName()) + " = " + this.getName(sup.getName()));
            }
            this.taxonomy.addEquivalentNode(c.getName(), sup);
            return;
        }
        Collection subs = this.search(false, c, this.taxonomy.getBottom(), new HashSet(), new ArrayList(), marked);
        TaxonomyNode node = this.taxonomy.addNode(c.getName(), hide);
        node.addSupers(new ArrayList(supers));
        node.addSubs(new ArrayList(subs));
        node.removeMultiplePaths();
    }

    private Collection search(boolean topSearch, Role c, TaxonomyNode x, Set visited, List result, Map marked) {
        ArrayList<TaxonomyNode> posSucc = new ArrayList<TaxonomyNode>();
        visited.add(x);
        List list = topSearch ? x.getSubs() : x.getSupers();
        for (int i = 0; i < list.size(); ++i) {
            TaxonomyNode next = (TaxonomyNode)list.get(i);
            if (topSearch) {
                if (!this.subsumes(next, c, marked)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c, marked)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            Iterator i = posSucc.iterator();
            while (i.hasNext()) {
                TaxonomyNode y = (TaxonomyNode)i.next();
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode node, Role c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = this.subsumes(this.rbox.getRole((ATerm)node.getName()), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumes ? this.NO_PROPOGATE : this.PROPOGATE_DOWN;
        this.mark(node, marked, value, propogate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode node, Role c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = this.subsumes(c, this.rbox.getRole((ATerm)node.getName()));
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumed ? this.NO_PROPOGATE : this.PROPOGATE_UP;
        this.mark(node, marked, value, propogate);
        return subsumed;
    }

    private void mark(TaxonomyNode node, Map marked, Boolean value, byte propogate) {
        Boolean exists = (Boolean)marked.get(node);
        if (exists != null) {
            if (exists != value) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + exists + " " + value);
            }
            return;
        }
        marked.put(node, value);
        if (propogate != this.NO_PROPOGATE) {
            List others = propogate == this.PROPOGATE_UP ? node.getSupers() : node.getSubs();
            Iterator i = others.iterator();
            while (i.hasNext()) {
                TaxonomyNode next = (TaxonomyNode)i.next();
                this.mark(next, marked, value, propogate);
            }
        }
    }

    private boolean subsumes(Role sup, Role sub) {
        boolean result = sup.isSuperRoleOf(sub);
        return result;
    }

    private String getName(ATermAppl c) {
        return URIUtils.getLocalName(c.getName());
    }
}

