/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.TgBox;
import org.mindswap.pellet.TuBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class TBox {
    public static boolean DEBUG = false;
    public static final ATermFactory factory = ATermUtils.getFactory();
    protected KnowledgeBase kb;
    protected Map termhash = new HashMap();
    protected Set classes = new HashSet();
    private Set allClasses;
    public Map refersTo = new HashMap();
    static boolean hookset = false;
    static long splittime = 0L;
    static long absorbtime = 0L;
    private List tboxAxioms = new ArrayList();
    public TuBox Tu = null;
    public TgBox Tg = null;
    static Exception lastException = null;

    public TBox(KnowledgeBase kb) {
        this.kb = kb;
        if (DEBUG) {
            this.addPrintHook();
        }
    }

    public void addPrintHook() {
        if (hookset) {
            return;
        }
        hookset = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                TBox.printStatistics();
                TuBox.printStatistics();
                TgBox.printStatistics();
            }
        });
    }

    public static void printStatistics() {
        System.out.println("\nTBox Statistics:");
        System.out.println("Time spent in createSplitTBox:" + splittime);
        System.out.println("Time spent in absorb:" + absorbtime);
    }

    public Set getAllClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet(this.classes);
            this.allClasses.add(ATermUtils.TOP);
            this.allClasses.add(ATermUtils.BOTTOM);
        }
        return this.allClasses;
    }

    public void addAxiom(ATermAppl axiom) {
        this.tboxAxioms.add(axiom);
    }

    public void addAxioms(List axioms) {
        this.tboxAxioms.addAll(axioms);
    }

    public void addAxioms(ATermList axioms) {
        while (!axioms.isEmpty()) {
            ATermAppl axiom = (ATermAppl)axioms.getFirst();
            this.addAxiom(axiom);
        }
    }

    public List getAxioms() {
        return this.tboxAxioms;
    }

    public void split() {
        ATermAppl term;
        this.Tu = new TuBox(this.kb);
        this.Tu.setAllowEvenLoops(false);
        this.Tg = new TgBox(this.kb);
        Timer timer = this.kb.timers.startTimer("split");
        ArrayList<ATermAppl> sameAxioms = new ArrayList<ATermAppl>();
        Iterator i = this.tboxAxioms.iterator();
        while (i.hasNext()) {
            this.kb.timers.checkTimer("preprocessing");
            term = (ATermAppl)i.next();
            if (term.getName().equals("same")) {
                sameAxioms.add(term);
                continue;
            }
            if (this.Tu.addIfUnfoldable(term)) continue;
            this.Tg.addDef(term);
        }
        i = sameAxioms.iterator();
        while (i.hasNext()) {
            this.kb.timers.checkTimer("preprocessing");
            term = (ATermAppl)i.next();
            if (this.Tu.addIfUnfoldable(term)) continue;
            ATermAppl name = (ATermAppl)term.getArgument(0);
            ATermAppl desc = (ATermAppl)term.getArgument(1);
            ATermAppl reversedTerm = ATermUtils.makeSame((ATerm)desc, (ATerm)name);
            if (this.Tu.addIfUnfoldable(reversedTerm)) continue;
            this.Tg.addDef(term);
        }
        timer.stop();
    }

    public void absorb() {
        long time = System.currentTimeMillis();
        this.Tg.absorb(this.Tu);
        if (DEBUG && !this.Tu.isUnfoldable()) {
            System.out.println("Error in TgBox.absorb(Tu)");
            throw new RuntimeException("TgBox.absorb(Tu) made a not-unfoldable Tu!");
        }
        absorbtime += System.currentTimeMillis() - time;
    }

    public boolean isEmpty() {
        return this.termhash.size() == 0;
    }

    public int size() {
        return this.termhash.size();
    }

    public TermDefinition getTD(ATerm name) {
        return (TermDefinition)this.termhash.get(name);
    }

    public boolean contains(ATerm name) {
        return this.termhash.containsKey(name);
    }

    public void addDef(ATermAppl def) {
        ATermAppl name = (ATermAppl)def.getArgument(0);
        if (this.termhash.containsKey(name)) {
            this.getTD((ATerm)name).addDef(def);
        } else {
            TermDefinition td = new TermDefinition();
            td.addDef(def);
            this.termhash.put(name, td);
        }
    }

    public String toString() {
        String str = "[";
        Iterator e = this.termhash.values().iterator();
        while (e.hasNext()) {
            str = str + e.next() + "\n";
        }
        return str + "]";
    }

    public List toList() {
        ArrayList terms = new ArrayList(this.termhash.size());
        Iterator e = this.termhash.values().iterator();
        while (e.hasNext()) {
            TermDefinition td = (TermDefinition)e.next();
            terms.addAll(td.toList());
        }
        return terms;
    }

    public static void main(String[] args) {
        ATermFactory factory = ATermUtils.getFactory();
        TBox tbox = null;
        ATerm t = null;
        try {
            if (args.length > 0) {
                FileInputStream input = new FileInputStream(args[0]);
                t = factory.readFromTextFile((InputStream)input);
            } else {
                t = factory.parse("[same(or(a,or(b,c)),or(x,y))]");
                t = factory.parse("[sub(not(a),and(or(b,or(c,not(y))),or(b,or(c,not(x))))),sub(not(y),and(or(not(b),x),or(x,not(a)))),sub(c,or(x,y))]}");
            }
            System.out.println(t);
            tbox = new TBox(null);
            tbox.addAxioms((ATermList)t);
            tbox.split();
            tbox.absorb();
            try {
                System.out.println("\nUnfolded TBox:\n" + tbox.Tu);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                tbox.Tg.internalize();
                System.out.println("\nInternalized TBox:\n" + tbox.Tg.getUC());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (args.length > 1) {
                ATermAppl conceptname = ATermUtils.makeTermAppl(args[1]);
                System.out.println("\nConcept for " + conceptname);
                System.out.println(ATermUtils.simplify(tbox.Tu.getTD((ATerm)conceptname).getDef(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ATermList getUC() {
        if (this.Tg == null) {
            return null;
        }
        return this.Tg.getUC();
    }

    public class TBoxException
    extends Exception {
        public TBoxException() {
        }

        public TBoxException(String e) {
            super(e);
        }
    }
}

