/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class Taxonomy {
    public static boolean DEBUG = false;
    public static boolean DETAILED_DEBUG = false;
    public static boolean SUB = true;
    public static boolean SUPER = false;
    public static boolean TOP_DOWN = true;
    public static boolean BOTTOM_UP = false;
    protected Map nodes;
    protected TaxonomyNode TOP_NODE;
    protected TaxonomyNode BOTTOM_NODE;
    protected TaxonomyPrinter printer = new TaxonomyPrinter();

    public Taxonomy() {
        this(false);
    }

    public Taxonomy(boolean hideTopBottom) {
        this.nodes = new HashMap();
        this.TOP_NODE = this.addNode(ATermUtils.TOP, hideTopBottom);
        this.BOTTOM_NODE = this.addNode(ATermUtils.BOTTOM, hideTopBottom);
        this.TOP_NODE.addSub(this.BOTTOM_NODE);
    }

    public TaxonomyNode getBottom() {
        return this.BOTTOM_NODE;
    }

    public TaxonomyNode getTop() {
        return this.TOP_NODE;
    }

    public Set getClasses() {
        return this.nodes.keySet();
    }

    public boolean contains(ATermAppl c) {
        return this.nodes.containsKey(c);
    }

    public TaxonomyNode addNode(ATermAppl c) {
        return this.addNode(c, false);
    }

    public TaxonomyNode addNode(ATermAppl c, boolean hide) {
        TaxonomyNode node = new TaxonomyNode(c, hide);
        this.nodes.put(c, node);
        return node;
    }

    public void addEquivalentNode(ATermAppl c, TaxonomyNode node) {
        boolean hide;
        boolean bl = hide = !ATermUtils.isPrimitive(c);
        if (!hide) {
            node.addEquivalent(c);
        }
        this.nodes.put(c, node);
    }

    public TaxonomyNode getNode(ATermAppl c) {
        return (TaxonomyNode)this.nodes.get(c);
    }

    public void removeNode(TaxonomyNode node) {
        node.disconnect();
        this.nodes.remove(node.getName());
    }

    public Set getInstances(ATermAppl c) {
        return this.getInstances(c, false);
    }

    public Set getInstances(ATermAppl c, boolean direct) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        HashSet result = new HashSet(node.getInstances());
        if (!direct) {
            Iterator subs = this.getSubs(c).iterator();
            while (subs.hasNext()) {
                Set sub = (Set)subs.next();
                ATermAppl a = (ATermAppl)sub.iterator().next();
                result.addAll(this.getInstances(a));
            }
        }
        return result;
    }

    public boolean isEquivalent(ATermAppl x, ATermAppl y) {
        TaxonomyNode node1 = (TaxonomyNode)this.nodes.get(x);
        TaxonomyNode node2 = (TaxonomyNode)this.nodes.get(y);
        return node1.equals(node2);
    }

    public boolean isSubNodeOf(ATermAppl x, ATermAppl y) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(x);
        ArrayList visit = new ArrayList();
        visit.add(this.nodes.get(x));
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.contains(y)) {
                return true;
            }
            visit.addAll(node.getSupers());
        }
        return false;
    }

    public Set getSubs(ATermAppl c) {
        return this.getSubs(c, false);
    }

    public Set getSubs(ATermAppl c, boolean direct) {
        return this.getSubSupers(c, direct, SUB, false);
    }

    public Set getSupers(ATermAppl c) {
        return this.getSupers(c, false);
    }

    public Set getSupers(ATermAppl c, boolean direct, boolean flat) {
        return this.getSubSupers(c, direct, SUPER, flat);
    }

    public Set getSubs(ATermAppl c, boolean direct, boolean flat) {
        return this.getSubSupers(c, direct, SUB, flat);
    }

    public Set getSupers(ATermAppl c, boolean direct) {
        return this.getSubSupers(c, direct, SUPER, false);
    }

    public Set getSubSupers(ATermAppl c, boolean direct, boolean subOrSuper, boolean flat) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        HashSet<Set> result = new HashSet<Set>();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper == SUB ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            Set add = node.getEquivalents();
            if (flat) {
                result.addAll(add);
            } else if (!add.isEmpty()) {
                result.add(add);
            }
            if (direct) continue;
            visit.addAll(subOrSuper == SUB ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set getFlattenedSubSupers(ATermAppl c, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        HashSet result = new HashSet();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper == SUB ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            Set add = node.getEquivalents();
            result.addAll(add);
            if (direct) continue;
            visit.addAll(subOrSuper == SUB ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set getEquivalents(ATermAppl c) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        if (node.isHidden()) {
            return SetUtils.EMPTY_SET;
        }
        HashSet result = new HashSet(node.getEquivalents());
        result.remove(c);
        return result;
    }

    public Set getAllEquivalents(ATermAppl c) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        if (node.isHidden()) {
            return SetUtils.EMPTY_SET;
        }
        HashSet result = new HashSet(node.getEquivalents());
        return result;
    }

    public Set getDirectTypes(ATermAppl ind) {
        HashSet<Set> result = new HashSet<Set>();
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
        }
        return result;
    }

    public Set getTypes(ATermAppl ind) {
        HashSet<Set> result = new HashSet<Set>();
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
            Set supers = this.getSupers(node.getName());
            result.addAll(supers);
        }
        return result;
    }

    public Set getTypes(ATermAppl ind, boolean direct) {
        if (direct) {
            return this.getDirectTypes(ind);
        }
        return this.getTypes(ind);
    }

    public List topologocialSort() {
        Integer ZERO = new Integer(0);
        HashMap<TaxonomyNode, Integer> degrees = new HashMap<TaxonomyNode, Integer>();
        LinkedHashSet<TaxonomyNode> nodesPending = new LinkedHashSet<TaxonomyNode>();
        HashSet<TaxonomyNode> nodesLeft = new HashSet<TaxonomyNode>();
        ArrayList<ATermAppl> nodesSorted = new ArrayList<ATermAppl>();
        if (DETAILED_DEBUG) {
            System.out.print("Topological sort...");
        }
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            nodesLeft.add(node);
            int degree = node.getSupers().size();
            if (degree == 0) {
                nodesPending.add(node);
                degrees.put(node, ZERO);
                continue;
            }
            degrees.put(node, new Integer(degree));
        }
        if (nodesPending.size() != 1) {
            throw new InternalReasonerException("More than one node with no incoming edges " + nodesPending);
        }
        int size = nodesLeft.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (nodesPending.isEmpty()) {
                throw new InternalReasonerException("Cycle detected in the taxonomy!");
            }
            TaxonomyNode node = (TaxonomyNode)nodesPending.iterator().next();
            Integer deg = (Integer)degrees.get(node);
            if (deg == null) {
                throw new InternalReasonerException("No degree for node " + node);
            }
            if (deg != ZERO) {
                throw new InternalReasonerException("Cycle detected in the taxonomy " + node + " " + deg + " " + nodesSorted.size() + " " + this.nodes.size());
            }
            nodesPending.remove(node);
            nodesLeft.remove(node);
            nodesSorted.add(node.getName());
            Iterator j = node.getSubs().iterator();
            while (j.hasNext()) {
                TaxonomyNode sub = (TaxonomyNode)j.next();
                int degree = (Integer)degrees.get(sub);
                if (degree == 1) {
                    nodesPending.add(sub);
                    degrees.put(sub, ZERO);
                    continue;
                }
                degrees.put(sub, new Integer(degree - 1));
            }
        }
        if (!nodesLeft.isEmpty()) {
            throw new InternalReasonerException("Failed to sort elements: " + nodesLeft);
        }
        if (DETAILED_DEBUG) {
            System.out.println("done.");
        }
        return nodesSorted;
    }

    public void removeCycles(TaxonomyNode node) {
        if (!this.nodes.get(node.getName()).equals(node)) {
            throw new InternalReasonerException("This node does not exist in the taxonomy: " + node.getName());
        }
        this.removeCycles(node, new ArrayList());
    }

    private boolean removeCycles(TaxonomyNode node, List path) {
        ATermUtils.assertTrue(this.nodes.containsValue(node));
        ATermUtils.assertTrue(this.nodes.containsKey(node.getName()));
        if (path.contains(node)) {
            this.mergeNodes(path);
            return true;
        }
        path.add(node);
        List supers = node.getSupers();
        int i = 0;
        while (i < supers.size()) {
            TaxonomyNode sup = (TaxonomyNode)supers.get(i);
            boolean cycle = this.removeCycles(sup, path);
            path.remove(sup);
            if (cycle) continue;
            ++i;
        }
        return false;
    }

    public void merge(TaxonomyNode node1, TaxonomyNode node2) {
        ArrayList<TaxonomyNode> mergeList = new ArrayList<TaxonomyNode>();
        mergeList.add(node1);
        mergeList.add(node2);
        this.mergeNodes(mergeList);
    }

    private void mergeNodes(List mergeList) {
        if (DETAILED_DEBUG) {
            System.out.println("Merge " + mergeList);
        }
        if (mergeList.size() == 1) {
            System.err.println("Merge one node?");
        }
        TaxonomyNode node = null;
        node = mergeList.contains(this.TOP_NODE) ? this.TOP_NODE : (mergeList.contains(this.BOTTOM_NODE) ? this.BOTTOM_NODE : (TaxonomyNode)mergeList.get(0));
        HashSet<TaxonomyNode> merged = new HashSet<TaxonomyNode>();
        merged.add(node);
        Iterator i = mergeList.iterator();
        while (i.hasNext()) {
            TaxonomyNode other = (TaxonomyNode)i.next();
            if (merged.contains(other)) continue;
            merged.add(other);
            Iterator j = other.getSubs().iterator();
            while (j.hasNext()) {
                TaxonomyNode sub = (TaxonomyNode)j.next();
                if (mergeList.contains(sub)) continue;
                node.addSub(sub);
            }
            j = other.getSupers().iterator();
            while (j.hasNext()) {
                TaxonomyNode sup = (TaxonomyNode)j.next();
                if (mergeList.contains(sup)) continue;
                sup.addSub(node);
            }
            this.removeNode(other);
            j = other.getEquivalents().iterator();
            while (j.hasNext()) {
                ATermAppl c = (ATermAppl)j.next();
                this.addEquivalentNode(c, node);
            }
        }
    }

    public List computeLCA(ATermList list) {
        ATermAppl c = (ATermAppl)list.getFirst();
        ArrayList ancestors = new ArrayList(this.getSupers(c, true, true));
        while (!list.isEmpty()) {
            c = (ATermAppl)list.getFirst();
            ancestors.retainAll(this.getSupers(c, true, true));
            if (ancestors.size() == 1) {
                ATermUtils.assertTrue(ancestors.contains(ATermUtils.TOP));
                return ancestors;
            }
            list = list.getNext();
        }
        for (int j = 0; j < ancestors.size(); ++j) {
            c = (ATermAppl)ancestors.get(j);
            ancestors.removeAll(this.getSupers(c, true, true));
        }
        return ancestors;
    }

    public void print() {
        this.printer.print(this);
    }

    public void print(OutputFormatter out) {
        this.printer.print(this, out);
    }
}

