/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public class TermDefinition {
    private ATermAppl sub;
    private List samelist;
    private Set seen;
    public Set dependencies;

    public TermDefinition() {
        this.sub = null;
        this.samelist = new ArrayList();
        this.seen = new HashSet();
        this.updateDependencies();
    }

    public TermDefinition(TermDefinition td) {
        this.sub = td.sub;
        this.samelist = new ArrayList(td.samelist);
        this.seen = new HashSet(td.seen);
        this.updateDependencies();
    }

    public ATermAppl getName() {
        ATermAppl name = null;
        if (this.size() > 0) {
            name = (ATermAppl)this.getDef(0).getArgument(0);
        }
        return name;
    }

    public void addDef(ATermAppl appl) {
        if (this.seen.contains(appl)) {
            return;
        }
        this.seen.add(appl);
        String name = appl.getName();
        if (name.equals("sub")) {
            if (this.sub != null) {
                ATermAppl conjunct = ATermUtils.makeAnd(appl.getArgument(1), this.sub.getArgument(1));
                this.sub = this.sub.setArgument((ATerm)conjunct, 1);
            } else {
                this.sub = appl;
            }
        } else if (name.equals("same")) {
            this.samelist.add(appl);
        } else {
            throw new RuntimeException("Cannot add non-definition!");
        }
        this.updateDependencies();
    }

    public void removeDef(int i) {
        if (this.sub != null) {
            if (i == 0) {
                this.seen.remove(this.sub);
                this.sub = null;
            }
            --i;
        }
        if (i >= 0) {
            this.seen.remove(this.samelist.get(i));
            this.samelist.remove(i);
        }
        this.updateDependencies();
    }

    public void replaceDef(int i, ATermAppl appl) {
        this.removeDef(i);
        this.addDef(appl);
        this.updateDependencies();
    }

    public boolean isUnique() {
        return this.sub != null && this.samelist.size() == 0 || this.sub == null && this.samelist.size() == 1;
    }

    public boolean isGCI() {
        ATermAppl term = this.getDef(0);
        return ((ATermAppl)term.getArgument(0)).getArity() != 0;
    }

    public List toList() {
        ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
        if (this.sub != null) {
            list.add(this.sub);
        }
        list.addAll(this.samelist);
        return list;
    }

    public ATermAppl getDef(int i) {
        if (this.sub != null) {
            if (i == 0) {
                return this.sub;
            }
            --i;
        }
        return (ATermAppl)this.samelist.get(i);
    }

    public ATermAppl getSub() {
        return this.sub;
    }

    public List getSames() {
        return this.samelist;
    }

    public int size() {
        int s = this.samelist.size();
        if (this.sub != null) {
            ++s;
        }
        return s;
    }

    public String toString() {
        return this.sub != null ? this.sub + "; " + this.samelist : this.samelist.toString();
    }

    protected void updateDependencies() {
        this.dependencies = new HashSet();
        if (this.getSub() != null) {
            this.dependencies.addAll(ATermUtils.findPrimitives((ATermAppl)this.getSub().getArgument(1)));
        }
        Iterator iter = this.getSames().iterator();
        while (iter.hasNext()) {
            ATermAppl same = (ATermAppl)iter.next();
            this.dependencies.addAll(ATermUtils.findPrimitives((ATermAppl)same.getArgument(1)));
        }
    }
}

