/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATerm;
import aterm.ATermAppl;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom3.bootstrap.DOMImplementationRegistry;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseUnionDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.RDFXMLLiteral;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.datatypes.UnknownDatatype;
import org.mindswap.pellet.datatypes.XSDBoolean;
import org.mindswap.pellet.datatypes.XSDByte;
import org.mindswap.pellet.datatypes.XSDDate;
import org.mindswap.pellet.datatypes.XSDDateTime;
import org.mindswap.pellet.datatypes.XSDDay;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.datatypes.XSDDerivableType;
import org.mindswap.pellet.datatypes.XSDDouble;
import org.mindswap.pellet.datatypes.XSDFloat;
import org.mindswap.pellet.datatypes.XSDInt;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.datatypes.XSDLong;
import org.mindswap.pellet.datatypes.XSDMonth;
import org.mindswap.pellet.datatypes.XSDMonthDay;
import org.mindswap.pellet.datatypes.XSDNegativeInteger;
import org.mindswap.pellet.datatypes.XSDNonNegativeInteger;
import org.mindswap.pellet.datatypes.XSDNonPositiveInteger;
import org.mindswap.pellet.datatypes.XSDPositiveInteger;
import org.mindswap.pellet.datatypes.XSDShort;
import org.mindswap.pellet.datatypes.XSDSimpleType;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.datatypes.XSDTime;
import org.mindswap.pellet.datatypes.XSDUnsignedByte;
import org.mindswap.pellet.datatypes.XSDUnsignedInt;
import org.mindswap.pellet.datatypes.XSDUnsignedLong;
import org.mindswap.pellet.datatypes.XSDUnsignedShort;
import org.mindswap.pellet.datatypes.XSDYear;
import org.mindswap.pellet.datatypes.XSDYearMonth;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.URIUtils;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

public class DatatypeReasoner {
    public static boolean DEBUG = false;
    private Map uriToDatatype = new Hashtable();
    private Map datatypeToURI = new Hashtable();
    private Map termToDatatype = new Hashtable();
    private Map normalized = new Hashtable();
    private int datatypeCount = 0;

    public DatatypeReasoner() {
        this.defineDatatype("http://www.w3.org/2000/01/rdf-schema#Literal", RDFSLiteral.instance);
        this.defineDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", RDFXMLLiteral.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#decimal", XSDDecimal.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#string", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#boolean", XSDBoolean.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#float", XSDFloat.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#double", XSDDouble.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#dateTime", XSDDateTime.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#date", XSDDate.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#time", XSDTime.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gYear", XSDYear.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gMonth", XSDMonth.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gDay", XSDDay.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gYearMonth", XSDYearMonth.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#gMonthDay", XSDMonthDay.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#duration", UnknownDatatype.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#anyURI", UnknownDatatype.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#anySimpleType", XSDSimpleType.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#integer", XSDInteger.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", XSDNonPositiveInteger.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#negativeInteger", XSDNegativeInteger.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", XSDNonNegativeInteger.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#positiveInteger", XSDPositiveInteger.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#long", XSDLong.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#int", XSDInt.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#short", XSDShort.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#byte", XSDByte.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedByte", XSDUnsignedByte.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedShort", XSDUnsignedShort.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedInt", XSDUnsignedInt.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#unsignedLong", XSDUnsignedLong.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#normalizedString", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#token", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#language", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#NMTOKEN", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#Name", XSDString.instance);
        this.defineDatatype("http://www.w3.org/2001/XMLSchema#NCName", XSDString.instance);
    }

    public final Set getDatatypeURIs() {
        return this.datatypeToURI.keySet();
    }

    public final boolean isDefined(String datatypeURI) {
        return this.uriToDatatype.containsKey(datatypeURI);
    }

    public final boolean isDefined(Datatype datatype) {
        return this.datatypeToURI.containsKey(datatype);
    }

    public void defineDatatype(String name, Datatype dt) {
        if (this.uriToDatatype.containsKey(name)) {
            throw new RuntimeException(name + " is already defined");
        }
        this.uriToDatatype.put(name, dt);
        this.datatypeToURI.put(dt, name);
        this.normalize(dt);
    }

    public void defineUnknownDatatype(String name) {
        this.defineDatatype(name, new UnknownDatatype());
    }

    public void loadUserDefinedDatatype(String name) {
        try {
            if (this.uriToDatatype.containsKey(name)) {
                return;
            }
            URL url = new URL(name);
            if (DEBUG) {
                System.out.println("Load " + url);
            }
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl ");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS ls = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSInput input = ls.createLSInput();
            input.setCharacterStream(new InputStreamReader(url.openStream()));
            XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            XSLoader schemaLoader = impl.createXSLoader(null);
            XSModel schema = schemaLoader.load(input);
            XSNamedMap map = schema.getComponents((short)16);
            String localName = URIUtils.getLocalName(name);
            String nameSpace = URIUtils.getNameSpace(name);
            XSSimpleType simpleType = (XSSimpleType)map.itemByName(nameSpace, localName);
            if (simpleType == null) {
                simpleType = (XSSimpleType)map.itemByName("", localName);
            }
            if (DEBUG) {
                System.out.println("Type: " + simpleType);
            }
            if (DEBUG) {
                System.out.println("Base: " + simpleType.getBaseType());
            }
            if (DEBUG) {
                System.out.println("MinInclusive value: " + simpleType.getLexicalFacetValue((short)256));
            }
            if (DEBUG) {
                System.out.println("MaxInclusive value: " + simpleType.getLexicalFacetValue((short)32));
            }
            String baseType = "http://www.w3.org/2001/XMLSchema#" + simpleType.getBaseType().getName();
            XSDDerivableType xsdType = (XSDDerivableType)this.getDatatype(baseType);
            if (DEBUG) {
                System.out.println("Facets: ");
            }
            XSObjectList facets = simpleType.getFacets();
            for (int i = 0; i < facets.getLength(); ++i) {
                XSFacet facet = (XSFacet)facets.item(i);
                if (DEBUG) {
                    System.out.println(i + ") Facet kind: " + facet.getFacetKind() + " Facet name = " + facet.getName() + " Facet value: " + facet.getLexicalFacetValue());
                }
                xsdType = (XSDDerivableType)xsdType.deriveByRestriction(facet.getFacetKind(), facet.getLexicalFacetValue());
            }
            StringList enumValues = simpleType.getLexicalEnumeration();
            if (enumValues != null && enumValues.getLength() > 0) {
                if (DEBUG) {
                    for (int k = 0; k < enumValues.getLength(); ++k) {
                        System.out.println("enum: " + enumValues.item(k));
                    }
                }
                xsdType = (XSDDerivableType)xsdType.deriveByRestriction(2048, enumValues);
            }
            this.defineDatatype(name, xsdType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.defineDatatype(name, new UnknownDatatype());
        }
    }

    public String defineDatatype(Datatype dt) {
        String name = dt.getName() == null ? "datatype" + this.datatypeCount++ : dt.getName().getName();
        this.defineDatatype(name, dt);
        return name;
    }

    public void removeDatatype(String name) {
        Datatype dt = this.getDatatype(name);
        this.uriToDatatype.remove(name);
        this.datatypeToURI.remove(dt);
        this.normalized.remove(dt);
        ATermAppl term = ATermUtils.makeTermAppl(name);
        this.termToDatatype.remove(term);
        ATermAppl not = ATermUtils.makeNot((ATerm)term);
        this.termToDatatype.remove(not);
    }

    public Datatype getDatatype(String datatypeURI) {
        if (datatypeURI == null || datatypeURI.length() == 0) {
            return XSDString.instance;
        }
        if (this.uriToDatatype.containsKey(datatypeURI)) {
            return (Datatype)this.uriToDatatype.get(datatypeURI);
        }
        return UnknownDatatype.instance;
    }

    public String getDatatypeURI(Datatype datatype) {
        return (String)this.datatypeToURI.get(datatype);
    }

    public Object getValue(ATermAppl lit) {
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        if (!lang.equals("") && !datatypeURI.equals("")) {
            throw new UnsupportedFeatureException("A literal value cannot have both a datatype URI and a language identifier " + lit);
        }
        Datatype datatype = this.getDatatype(datatypeURI);
        Object value = lang.equals("") ? datatype.getValue(lexicalValue, datatypeURI) : new StringValue(lexicalValue, lang);
        return value;
    }

    public Datatype singleton(ATermAppl term) {
        ATermAppl lit = null;
        if (ATermUtils.isNominal(term)) {
            lit = (ATermAppl)term.getArgument(0);
        } else if (ATermUtils.isLiteral(term)) {
            lit = term;
        } else {
            throw new RuntimeException("An invalid data value is found " + term);
        }
        String lexicalValue = ((ATermAppl)lit.getArgument(0)).getName();
        String lang = ((ATermAppl)lit.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)lit.getArgument(2)).getName();
        if (!lang.equals("") && !datatypeURI.equals("")) {
            throw new UnsupportedFeatureException("A literal value cannot have both a datatype URI and a language identifier " + lit);
        }
        Datatype datatype = this.getDatatype(datatypeURI);
        Object value = lang.equals("") ? datatype.getValue(lexicalValue, datatypeURI) : new StringValue(lexicalValue, lang);
        return datatype.singleton(value);
    }

    public Datatype enumeration(Set values) {
        Datatype[] enums = new Datatype[values.size()];
        Iterator i = values.iterator();
        for (int index = 0; index < enums.length; ++index) {
            enums[index] = this.singleton((ATermAppl)i.next());
        }
        return this.normalize(new BaseUnionDatatype(enums));
    }

    public Datatype getDatatype(ATermAppl datatypeTerm) {
        Datatype datatype = (Datatype)this.termToDatatype.get(datatypeTerm);
        if (datatype != null) {
            return datatype;
        }
        if (ATermUtils.isNominal(datatypeTerm)) {
            datatype = this.singleton(datatypeTerm);
        } else if (ATermUtils.isNot(datatypeTerm)) {
            ATermAppl negatedDatatype = (ATermAppl)datatypeTerm.getArgument(0);
            Datatype norm = this.normalize(this.getDatatype(negatedDatatype));
            Set atomicTypes = ((UnionDatatype)this.normalized.get(RDFSLiteral.instance)).getMembers();
            atomicTypes = SetUtils.create(atomicTypes);
            if (norm instanceof AtomicDatatype) {
                AtomicDatatype atomicType = (AtomicDatatype)norm;
                AtomicDatatype primitiveType = atomicType.getPrimitiveType();
                atomicTypes.remove(primitiveType);
                if (atomicType.isDerived()) {
                    atomicTypes.add(atomicType.not());
                }
            } else if (norm instanceof UnionDatatype) {
                atomicTypes.removeAll(((UnionDatatype)norm).getMembers());
            } else {
                throw new RuntimeException("Error in datatype reasoning");
            }
            Datatype[] members = new Datatype[atomicTypes.size()];
            atomicTypes.toArray(members);
            datatype = new BaseUnionDatatype(members);
        } else {
            datatype = this.getDatatype(datatypeTerm.getName());
        }
        if (datatype == null) {
            datatype = new UnknownDatatype();
        }
        this.termToDatatype.put(datatypeTerm, datatype);
        return datatype;
    }

    private Datatype normalize(Datatype datatype) {
        Datatype norm = (Datatype)this.normalized.get(datatype);
        if (norm != null) {
            return norm;
        }
        if (datatype instanceof UnionDatatype) {
            Map groupedTypes = new HashMap();
            UnionDatatype union = (UnionDatatype)datatype;
            Iterator i = union.getMembers().iterator();
            while (i.hasNext()) {
                Datatype member = (Datatype)i.next();
                Datatype normalizedMember = this.normalize(member);
                groupedTypes = this.unionWithGroup(groupedTypes, normalizedMember);
            }
            Datatype[] datatypes = new Datatype[groupedTypes.size()];
            groupedTypes.values().toArray(datatypes);
            norm = datatypes.length == 1 ? datatypes[0] : new BaseUnionDatatype(datatypes);
        } else {
            norm = datatype;
        }
        this.normalized.put(datatype, norm);
        return norm;
    }

    public boolean isSubTypeOf(ATermAppl d1, ATermAppl d2) {
        ATermAppl notD2 = ATermUtils.makeNot((ATerm)d2);
        Datatype conjunction = this.intersection(new ATermAppl[]{d1, notD2});
        return conjunction.isEmpty();
    }

    public Datatype intersection(ATermAppl[] datatypeTerms) {
        if (datatypeTerms.length == 0) {
            return EmptyDatatype.instance;
        }
        if (datatypeTerms.length == 1 && ATermUtils.isPrimitive(datatypeTerms[0])) {
            return this.getDatatype(datatypeTerms[0]);
        }
        ATermAppl and = ATermUtils.normalize(ATermUtils.makeAnd(ATermUtils.makeList((ATerm[])datatypeTerms)));
        Datatype intersection = (Datatype)this.termToDatatype.get(and);
        if (intersection != null) {
            return intersection;
        }
        Datatype[] datatypes = new Datatype[datatypeTerms.length];
        for (int i = 0; i < datatypeTerms.length; ++i) {
            datatypes[i] = this.getDatatype(datatypeTerms[i]);
        }
        Map<AtomicDatatype, AtomicDatatype> groupedTypes = new HashMap<AtomicDatatype, AtomicDatatype>();
        Set atomicTypes = ((UnionDatatype)this.normalized.get(RDFSLiteral.instance)).getMembers();
        Iterator i = atomicTypes.iterator();
        while (i.hasNext()) {
            AtomicDatatype primitiveType = (AtomicDatatype)i.next();
            groupedTypes.put(primitiveType, primitiveType);
        }
        for (int i2 = 0; i2 < datatypes.length; ++i2) {
            groupedTypes = this.intersectWithGroup(groupedTypes, datatypes[i2]);
        }
        intersection = new BaseUnionDatatype(new HashSet(groupedTypes.values()));
        this.termToDatatype.put(and, intersection);
        if (DEBUG && intersection.isEmpty()) {
            intersection = this.intersection(datatypeTerms);
        }
        return intersection;
    }

    private Map intersectWithGroup(Map groupedTypes, Datatype datatype) {
        HashMap<AtomicDatatype, AtomicDatatype> newGroup = new HashMap<AtomicDatatype, AtomicDatatype>();
        if (datatype instanceof AtomicDatatype) {
            AtomicDatatype atomicType = (AtomicDatatype)datatype;
            AtomicDatatype primitiveType = atomicType.getPrimitiveType();
            AtomicDatatype type = (AtomicDatatype)groupedTypes.get(primitiveType);
            if (type != null) {
                type = type.intersection(atomicType);
                newGroup.put(primitiveType, type);
            }
        } else if (datatype instanceof UnionDatatype) {
            UnionDatatype union = (UnionDatatype)datatype;
            Iterator i = union.getMembers().iterator();
            while (i.hasNext()) {
                Datatype member = (Datatype)i.next();
                newGroup.putAll(this.intersectWithGroup(groupedTypes, member));
            }
        } else {
            throw new RuntimeException("Error in datatype reasoning");
        }
        return newGroup;
    }

    private Map unionWithGroup(Map groupedTypes, Datatype datatype) {
        Map newGroup = groupedTypes;
        if (datatype instanceof AtomicDatatype) {
            AtomicDatatype atomicType = (AtomicDatatype)datatype;
            AtomicDatatype primitiveType = atomicType.getPrimitiveType();
            AtomicDatatype type = (AtomicDatatype)groupedTypes.get(primitiveType);
            type = type == null ? atomicType : type.union(atomicType);
            newGroup.put(primitiveType, type);
        } else if (datatype instanceof UnionDatatype) {
            UnionDatatype union = (UnionDatatype)datatype;
            Iterator i = union.getMembers().iterator();
            while (i.hasNext()) {
                Datatype member = (Datatype)i.next();
                newGroup = this.unionWithGroup(groupedTypes, member);
            }
        } else {
            throw new RuntimeException("Error in datatype reasoning");
        }
        return newGroup;
    }
}

