/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDFloat
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static XSDFloat instance = new XSDFloat();

    XSDFloat() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float"));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (datatypeURI.equals(XSDFloat.instance.name.getName())) {
                System.err.println("Invalid xsd:float value: '" + value + "'");
                System.err.println(e);
            }
            return null;
        }
    }

    public boolean contains(Object value) {
        return value instanceof Float && super.contains(value);
    }
}

