/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DocumentImpl;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.dig.DIGErrors;
import org.mindswap.pellet.utils.ATermUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGResponse {
    private Document doc = new DocumentImpl();
    private Element root;

    public DIGResponse(String rootTag) {
        this.root = this.doc.createElement(rootTag);
        this.root.setAttribute("xmlns", "http://dl.kr.org/dig/2003/02/lang");
        this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://dl.kr.org/dig/2003/02/lang      http://dl-web.man.ac.uk/dig/2003/02/dig.xsd");
        this.doc.appendChild(this.root);
    }

    public Document getDocument() {
        return this.doc;
    }

    protected Element addElement(String tag) {
        return this.addElement(tag, this.root);
    }

    protected Element addElement(String tag, Element parent) {
        Element element = this.doc.createElement(tag);
        parent.appendChild(element);
        return element;
    }

    public static Document createOkResponse() {
        DIGResponse resp = new DIGResponse("response");
        resp.addElement("ok");
        return resp.getDocument();
    }

    public static Document createKBResponse(String uri) {
        DIGResponse resp = new DIGResponse("response");
        Element kb = resp.addElement("kb");
        kb.setAttribute("uri", uri);
        return resp.getDocument();
    }

    public static Document createErrorResponse(int code, String details) {
        DIGResponse resp = new DIGResponse("response");
        resp.addError(code, details);
        return resp.getDocument();
    }

    public Element addError(int code, String details) {
        Element error = this.addElement("error");
        error.setAttribute("code", DIGErrors.codes[2 * code]);
        error.setAttribute("message", DIGErrors.codes[2 * code + 1]);
        if (details != null) {
            error.appendChild(this.doc.createTextNode(details));
        }
        return error;
    }

    public Element addBoolean(boolean b) {
        return this.addElement(b ? "true" : "false");
    }

    public Element addConceptSet(Collection concepts) {
        return this.addSet(concepts, "conceptSet", "catom");
    }

    public Element addRoleSet(Collection roles, boolean attribute) {
        return this.addSet(roles, "roleSet", attribute ? "attribute" : "ratom");
    }

    public Element addIndividualSet(Collection individuals) {
        Element set = this.addElement("individualSet");
        Iterator i = individuals.iterator();
        while (i.hasNext()) {
            ATermAppl individual = (ATermAppl)i.next();
            Element element = this.addElement("individual", set);
            element.setAttribute("name", individual.getName());
        }
        return set;
    }

    public void addValues(Collection values, String id) {
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Literal literal = (Literal)i.next();
            String datatypeURI = literal.getDatatypeURI();
            String lexicalValue = literal.getValue().toString();
            boolean isInt = datatypeURI != null;
            Element val = this.addElement(isInt ? "ival" : "sval");
            val.appendChild(this.doc.createTextNode(lexicalValue));
            val.setAttribute("id", id);
        }
    }

    public Element addIndividualPairSet(Map values) {
        Element set = this.addElement("individualPairSet");
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            ATermAppl subj = (ATermAppl)i.next();
            Iterator objects = ((Collection)values.get(subj)).iterator();
            while (objects.hasNext()) {
                ATermAppl obj = (ATermAppl)objects.next();
                Element indPair = this.addElement("individualPair", set);
                Element subjElement = this.addElement("individual", indPair);
                subjElement.setAttribute("name", subj.getName());
                Element objElement = this.addElement("individual", indPair);
                objElement.setAttribute("name", obj.getName());
            }
        }
        return set;
    }

    private Element addSet(Collection values, String tag, String atom) {
        Element set = this.addElement(tag);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Set synonms = (Set)i.next();
            this.addSynonms(set, synonms, atom);
        }
        return set;
    }

    public void addSynonms(Element parent, Collection elements, String atom) {
        Element synonms = this.addElement("synonyms", parent);
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ATermAppl term = (ATermAppl)i.next();
            if (term.equals(ATermUtils.TOP)) {
                this.addElement("top", synonms);
                continue;
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                this.addElement("bottom", synonms);
                continue;
            }
            Element element = this.addElement(atom, synonms);
            element.setAttribute("name", term.getName());
        }
    }
}

