/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.datatypes.XSDInt;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.dig.DIGErrors;
import org.mindswap.pellet.dig.DIGHandler;
import org.mindswap.pellet.dig.DIGResponse;
import org.mindswap.pellet.dig.ElementList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGTellHandler
extends DIGHandler {
    public Document tells(Element tells) {
        ElementList tellList = DIGTellHandler.getElements(tells);
        for (int i = 0; i < tellList.getLength(); ++i) {
            Element tell = tellList.item(i);
            String tag = tell.getTagName();
            try {
                ATermAppl obj;
                ATermAppl subj;
                ElementList list;
                ATermAppl p;
                Element elem;
                ATermAppl c1;
                ElementList pair;
                if (tag.equals("clearKB")) {
                    this.kb.clear();
                    continue;
                }
                if (tag.equals("defconcept")) {
                    this.kb.addClass((ATerm)DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defrole")) {
                    this.kb.addObjectProperty((ATerm)DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defattribute")) {
                    this.kb.addDatatypeProperty((ATerm)DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("defindividual")) {
                    this.kb.addIndividual(DIGTellHandler.getNameTerm(tell));
                    continue;
                }
                if (tag.equals("equalc")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    c1 = this.concept(pair.item(0));
                    ATermAppl c2 = this.concept(pair.item(1));
                    this.kb.addClass((ATerm)c1);
                    this.kb.addClass((ATerm)c2);
                    this.kb.addSameClass(c1, c2);
                    continue;
                }
                if (tag.equals("impliesc")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    c1 = this.concept(pair.item(0));
                    ATermAppl c2 = this.concept(pair.item(1));
                    this.kb.addClass((ATerm)c1);
                    this.kb.addClass((ATerm)c2);
                    this.kb.addSubClass(c1, c2);
                    continue;
                }
                if (tag.equals("disjoint")) {
                    int j;
                    ElementList children = DIGTellHandler.getElements(tell);
                    if (children.getLength() <= 1) continue;
                    ATermAppl[] terms = new ATermAppl[children.getLength()];
                    for (j = 0; j < children.getLength(); ++j) {
                        terms[j] = this.concept(children.item(j));
                    }
                    for (j = 0; j < terms.length - 1; ++j) {
                        for (int k = j + 1; k < terms.length; ++k) {
                            this.kb.addDisjointClass((ATerm)terms[j], (ATerm)terms[k]);
                        }
                    }
                    continue;
                }
                if (tag.equals("equalr")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl inv1 = DIGTellHandler.getInverse(pair.item(0));
                    ATermAppl inv2 = DIGTellHandler.getInverse(pair.item(1));
                    if (inv1 != null) {
                        if (inv2 != null) {
                            this.kb.addSameProperty(inv1, inv2);
                            continue;
                        }
                        this.kb.addInverseProperty(inv1, DIGTellHandler.property(pair.item(1)));
                        continue;
                    }
                    if (inv2 != null) {
                        this.kb.addInverseProperty(DIGTellHandler.property(pair.item(0)), inv2);
                        continue;
                    }
                    this.kb.addSameProperty(DIGTellHandler.property(pair.item(0)), DIGTellHandler.property(pair.item(1)));
                    continue;
                }
                if (tag.equals("impliesr")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl p1 = DIGTellHandler.property(pair.item(0));
                    ATermAppl p2 = DIGTellHandler.property(pair.item(1));
                    this.kb.addProperty(p1);
                    this.kb.addProperty(p2);
                    this.kb.addSubProperty(DIGTellHandler.property(pair.item(0)), DIGTellHandler.property(pair.item(1)));
                    continue;
                }
                if (tag.equals("functional")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    p = DIGTellHandler.property(elem);
                    this.kb.addProperty(p);
                    this.kb.addFunctionalProperty(p);
                    continue;
                }
                if (tag.equals("transitive")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    p = DIGTellHandler.property(elem);
                    this.kb.addObjectProperty((ATerm)p);
                    this.kb.addTransitiveProperty(DIGTellHandler.property(elem));
                    continue;
                }
                if (tag.equals("domain")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    p = DIGTellHandler.property(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addObjectProperty((ATerm)p);
                    this.kb.addClass((ATerm)c);
                    this.kb.addDomain((ATerm)p, c);
                    continue;
                }
                if (tag.equals("range")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    p = DIGTellHandler.property(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addObjectProperty((ATerm)p);
                    this.kb.addClass((ATerm)c);
                    this.kb.addRange((ATerm)p, c);
                    continue;
                }
                if (tag.equals("rangeint")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    p = DIGTellHandler.property(elem);
                    this.kb.addDatatypeProperty((ATerm)p);
                    this.kb.addRange((ATerm)p, XSDInt.instance.getName());
                    continue;
                }
                if (tag.equals("rangestring")) {
                    elem = DIGTellHandler.getElement(tell);
                    if (elem == null) continue;
                    p = DIGTellHandler.property(elem);
                    this.kb.addDatatypeProperty((ATerm)p);
                    this.kb.addRange((ATerm)p, XSDString.instance.getName());
                    continue;
                }
                if (tag.equals("instanceof")) {
                    pair = DIGTellHandler.getElements(tell);
                    if (pair.getLength() != 2) continue;
                    ATermAppl ind = DIGTellHandler.individual(pair.item(0));
                    ATermAppl c = this.concept(pair.item(1));
                    this.kb.addIndividual(ind);
                    this.kb.addClass((ATerm)c);
                    this.kb.addType(ind, c);
                    continue;
                }
                if (tag.equals("related")) {
                    list = DIGTellHandler.getElements(tell);
                    if (list.getLength() != 3) continue;
                    subj = DIGTellHandler.individual(list.item(0));
                    ATermAppl pred = DIGTellHandler.property(list.item(1));
                    obj = DIGTellHandler.individual(list.item(2));
                    this.kb.addIndividual(subj);
                    this.kb.addObjectProperty((ATerm)pred);
                    this.kb.addIndividual(obj);
                    this.kb.addPropertyValue(pred, subj, obj);
                    continue;
                }
                if (tag.equals("value")) {
                    list = DIGTellHandler.getElements(tell);
                    if (list.getLength() != 3) continue;
                    subj = DIGTellHandler.individual(list.item(0));
                    ATermAppl pred = DIGTellHandler.property(list.item(1));
                    obj = DIGTellHandler.literal(list.item(2));
                    this.kb.addIndividual(subj);
                    this.kb.addDatatypeProperty((ATerm)pred);
                    this.kb.addPropertyValue(pred, subj, obj);
                    continue;
                }
                log.error((Object)("ERROR (" + DIGErrors.UNKNOWN_TELL_OPERATION + ") : " + tag + " is not a known tell operation"));
                continue;
            }
            catch (RuntimeException e) {
                log.error((Object)("Ignoring invalid tell command:\n" + this.serialize(tell)));
            }
        }
        return DIGResponse.createOkResponse();
    }
}

