/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Iterator;
import java.util.Map;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.RDFXMLLiteral;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class JenaUtils {
    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI) : (jenaLiteral.language() == null ? ATermUtils.makePlainLiteral(lexicalValue, jenaLiteral.language()) : ATermUtils.makePlainLiteral(lexicalValue));
        return literalValue;
    }

    public static Node makeGraphLiteral(Literal literal) {
        String lang = literal.getLang();
        String datatypeURI = literal.getDatatypeURI();
        String lexicalValue = literal.getValue().toString();
        Node node = !lang.equals("") ? Node.createLiteral((String)lexicalValue, (String)lang, (boolean)false) : (datatypeURI == null ? Node.createLiteral((String)lexicalValue) : (datatypeURI.equals(RDFXMLLiteral.instance.getURI()) ? Node.createLiteral((String)lexicalValue, (String)"", (boolean)true) : Node.createLiteral((String)lexicalValue, (String)"", (RDFDatatype)TypeMapper.getInstance().getTypeByName(datatypeURI))));
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        String name = term.getName();
        if (name.startsWith("bNode")) {
            String anonID = name.substring("bNode".length());
            return Node.createAnon((AnonId)new AnonId(anonID));
        }
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.getArity() == 0) {
            return Node.createURI((String)name);
        }
        throw new InternalReasonerException("Invalid term found " + term);
    }

    public static Node makeGraphNode(Object value) {
        if (value instanceof Literal) {
            return JenaUtils.makeGraphLiteral((Literal)value);
        }
        if (value instanceof ATermAppl) {
            return JenaUtils.makeGraphResource((ATermAppl)value);
        }
        throw new InternalReasonerException("Expecting literal or ATermAppl but got " + value.getClass().getName());
    }

    public static com.hp.hpl.jena.rdf.model.Literal makeLiteral(ATermAppl literal, Model model) {
        com.hp.hpl.jena.rdf.model.Literal node = null;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        String lang = ((ATermAppl)literal.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
        node = !lang.equals("") ? model.createLiteral(lexicalValue, lang) : (datatypeURI.equals("") ? model.createLiteral(lexicalValue) : (datatypeURI.equals(RDFXMLLiteral.instance.getName()) ? model.createLiteral(lexicalValue, true) : model.createTypedLiteral(lexicalValue, datatypeURI)));
        return node;
    }

    public static com.hp.hpl.jena.rdf.model.Literal makeLiteral(Literal literal, Model model) {
        com.hp.hpl.jena.rdf.model.Literal node = null;
        String lang = literal.getLang();
        String datatypeURI = literal.getDatatypeURI();
        String lexicalValue = literal.getValue().toString();
        node = !lang.equals("") ? model.createLiteral(lexicalValue, lang) : (datatypeURI == null ? model.createLiteral(lexicalValue) : (datatypeURI.equals(RDFXMLLiteral.instance.getURI()) ? model.createLiteral(lexicalValue, true) : model.createTypedLiteral(lexicalValue, datatypeURI)));
        return node;
    }

    public static Resource makeResource(ATermAppl term, Model model) {
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing;
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing;
        }
        if (term.getArity() == 0) {
            String name = term.getName();
            if (name.startsWith("bNode")) {
                String anonID = name.substring("bNode".length());
                return model.createResource(new AnonId(anonID));
            }
            return model.getResource(name);
        }
        return null;
    }

    public static RDFNode makeRDFNode(Object value, Model model) {
        if (value instanceof Literal) {
            return JenaUtils.makeLiteral((Literal)value, model);
        }
        if (value instanceof ATermAppl) {
            ATermAppl term = (ATermAppl)value;
            if (ATermUtils.isLiteral(term)) {
                return JenaUtils.makeLiteral(term, model);
            }
            return JenaUtils.makeResource(term, model);
        }
        return null;
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        Iterator entries = mapping.getNsPrefixMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

