/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class ModelExtractor {
    private OWLReasoner reasoner;
    private KnowledgeBase kb;
    private boolean verbose;
    private boolean includeDirects;

    public ModelExtractor() {
    }

    public ModelExtractor(OWLReasoner reasoner) {
        this.setReasoner(reasoner);
    }

    public Model extractModel() {
        Model model = ModelFactory.createDefaultModel();
        model = this.extractClassModel(model);
        model = this.extractPropertyModel(model);
        if (this.kb.isRealized()) {
            model = this.extractIndividualModel(model);
        }
        return model;
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel() {
        this.kb.realize();
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        this.kb.classify();
        HashSet<ATermAppl> classes = new HashSet<ATermAppl>(this.kb.getClasses());
        classes.add(ATermUtils.TOP);
        classes.add(ATermUtils.BOTTOM);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            Resource r = this.reasoner.toJenaResource(c);
            model.add(r, RDF.type, (RDFNode)OWL.Class);
            model.add(OWL.Nothing, RDFS.subClassOf, (RDFNode)r);
            Set eqs = this.kb.getEquivalentClasses(c);
            eqs.add(c);
            Iterator j = eqs.iterator();
            while (j.hasNext()) {
                Resource eq = this.reasoner.toJenaResource((ATermAppl)j.next());
                model.add(r, OWL.equivalentClass, (RDFNode)eq);
                model.add(r, RDFS.subClassOf, (RDFNode)eq);
                model.add(eq, RDFS.subClassOf, (RDFNode)r);
            }
            Set supers = this.verbose ? this.kb.getSuperClasses(c) : this.kb.getSuperClasses(c, true);
            supers = SetUtils.union(supers);
            Iterator j2 = supers.iterator();
            while (j2.hasNext()) {
                Resource sup = this.reasoner.toJenaResource((ATermAppl)j2.next());
                model.add(r, RDFS.subClassOf, (RDFNode)sup);
            }
            if (!this.includeDirects) continue;
            Set direct = this.verbose ? SetUtils.union(this.kb.getSuperClasses(c, true)) : supers;
            Iterator j3 = direct.iterator();
            while (j3.hasNext()) {
                Resource sup = this.reasoner.toJenaResource((ATermAppl)j3.next());
                model.add(r, ReasonerVocabulary.directSubClassOf, (RDFNode)sup);
            }
        }
        return model;
    }

    public Model extractIndividualModel(Model model) {
        this.kb.realize();
        Set individuals = this.kb.getIndividuals();
        Iterator i = individuals.iterator();
        while (i.hasNext()) {
            ATermAppl ind = (ATermAppl)i.next();
            Resource r = this.reasoner.toJenaResource(ind);
            Set types = this.verbose ? this.kb.getTypes(ind) : this.kb.getTypes(ind, true);
            types = SetUtils.union(types);
            Iterator j = types.iterator();
            while (j.hasNext()) {
                ATermAppl sub = (ATermAppl)j.next();
                model.add(r, RDF.type, (RDFNode)this.reasoner.toJenaResource(sub));
            }
            if (!this.includeDirects) continue;
            Set direct = this.verbose ? SetUtils.union(this.kb.getTypes(ind, true)) : types;
            Iterator j2 = direct.iterator();
            while (j2.hasNext()) {
                Resource sup = this.reasoner.toJenaResource((ATermAppl)j2.next());
                model.add(r, ReasonerVocabulary.directRDFType, (RDFNode)sup);
            }
        }
        return model;
    }

    public Model extractPropertyModel(Model model) {
        this.kb.prepare();
        Collection props = this.kb.getRBox().getRoles();
        Iterator i = props.iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATermAppl name = role.getName();
            if (role.isAnon()) continue;
            Resource r = this.reasoner.toJenaResource(name);
            if (role.isDatatypeRole()) {
                model.add(r, RDF.type, (RDFNode)OWL.DatatypeProperty);
            } else {
                if (!role.isObjectRole()) continue;
                model.add(r, RDF.type, (RDFNode)OWL.ObjectProperty);
            }
            if (role.isFunctional()) {
                model.add(r, RDF.type, (RDFNode)OWL.FunctionalProperty);
            }
            if (role.isInverseFunctional()) {
                model.add(r, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
            }
            if (role.isTransitive()) {
                model.add(r, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
            if (role.isSymmetric()) {
                model.add(r, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
            Set eqs = this.kb.getAllEquivalentProperties(name);
            Iterator j = eqs.iterator();
            while (j.hasNext()) {
                ATermAppl eq = (ATermAppl)j.next();
                Resource eqR = this.reasoner.toJenaResource(eq);
                model.add(r, OWL.equivalentProperty, (RDFNode)eqR);
                model.add(r, RDFS.subPropertyOf, (RDFNode)eqR);
            }
            Set supers = this.verbose ? this.kb.getSuperProperties(name) : this.kb.getSuperProperties(name, true);
            supers = SetUtils.union(supers);
            Iterator j2 = supers.iterator();
            while (j2.hasNext()) {
                ATermAppl sup = (ATermAppl)j2.next();
                model.add(r, RDFS.subPropertyOf, (RDFNode)this.reasoner.toJenaResource(sup));
            }
            if (!this.includeDirects) continue;
            Set direct = this.verbose ? SetUtils.union(this.kb.getSuperProperties(name, true)) : supers;
            Iterator j3 = direct.iterator();
            while (j3.hasNext()) {
                ATermAppl sup = (ATermAppl)j3.next();
                model.add(r, ReasonerVocabulary.directSubPropertyOf, (RDFNode)this.reasoner.toJenaResource(sup));
            }
        }
        return model;
    }

    public boolean isIncludeDirects() {
        return this.includeDirects;
    }

    public void setIncludeDirects(boolean includeDirects) {
        this.includeDirects = includeDirects;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.kb = reasoner.getKB();
    }
}

