/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.owlapi.PelletVisitor;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.URIUtils;
import org.semanticweb.owl.impl.model.OWLConnectionImpl;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.semanticweb.owl.util.OWLConnection;

public class PelletLoader {
    public static boolean DEBUG = false;
    private KnowledgeBase kb;
    private Set loadedFiles;
    private boolean loadImports = true;
    private Set ontologies;
    private PelletVisitor visitor = new PelletVisitor(this);

    public PelletLoader(KnowledgeBase kb) {
        this.kb = kb;
        this.reset();
    }

    public boolean loadImports() {
        return this.loadImports;
    }

    public void setLoadImports(boolean loadImports) {
        this.loadImports = loadImports;
    }

    public void reset() {
        this.kb.clear();
        this.ontologies = new HashSet();
        this.loadedFiles = new HashSet();
        this.loadedFiles.add(URIUtils.getNameSpace("http://www.w3.org/2002/07/owl#"));
        this.loadedFiles.add(URIUtils.getNameSpace("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        this.loadedFiles.add(URIUtils.getNameSpace("http://www.w3.org/2000/01/rdf-schema#"));
    }

    public void load(OWLOntology ontology) throws OWLException {
        if (this.loadImports) {
            Iterator i = OntologyHelper.importClosure((OWLOntology)ontology).iterator();
            while (i.hasNext()) {
                this.loadOntology((OWLOntology)i.next());
            }
        } else {
            this.loadOntology(ontology);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public ATermAppl term(OWLObject d) throws OWLException {
        this.visitor.reset();
        d.accept((OWLObjectVisitor)this.visitor);
        ATermAppl a = this.visitor.result();
        if (a == null) {
            throw new OWLException("Cannot create ATerm from description " + d);
        }
        return a;
    }

    void loadOntology(OWLOntology ontology) throws OWLException {
        Iterator it = null;
        String uri = URIUtils.getNameSpace(ontology.getURI());
        if (this.loadedFiles.contains(uri)) {
            return;
        }
        this.loadedFiles.add(uri);
        this.ontologies.add(ontology);
        if (this.kb instanceof EconnectedKB) {
            EconnectedKB econn = (EconnectedKB)this.kb;
            String ontURI = ontology.getURI().toString();
            if (!econn.getTBoxes().keySet().contains(ontURI)) {
                econn.addOntology(ontURI);
            }
            ((EconnectedKB)this.kb).setOntology(ontURI);
        }
        this.visitor = new PelletVisitor(this);
        this.defineEntities(ontology);
        it = ontology.getClasses().iterator();
        while (it.hasNext()) {
            this.loadClass(ontology, (OWLClass)it.next());
        }
        it = ontology.getObjectProperties().iterator();
        while (it.hasNext()) {
            this.loadObjectProperty(ontology, (OWLObjectProperty)it.next());
        }
        it = ontology.getDataProperties().iterator();
        while (it.hasNext()) {
            this.loadDataProperty(ontology, (OWLDataProperty)it.next());
        }
        it = ontology.getIndividuals().iterator();
        while (it.hasNext()) {
            this.loadIndividual(ontology, (OWLIndividual)it.next());
        }
        it = ontology.getDatatypes().iterator();
        while (it.hasNext()) {
            this.loadDataType(ontology, (OWLDataType)it.next());
        }
        it = ontology.getClassAxioms().iterator();
        while (it.hasNext()) {
            this.loadClassAxiom((OWLClassAxiom)it.next());
        }
        it = ontology.getPropertyAxioms().iterator();
        while (it.hasNext()) {
            this.loadPropertyAxiom((OWLPropertyAxiom)it.next());
        }
        it = ontology.getIndividualAxioms().iterator();
        while (it.hasNext()) {
            this.loadIndividualAxiom((OWLIndividualAxiom)it.next());
        }
        if (this.kb instanceof EconnectedKB) {
            Iterator i = ontology.getForeignOntologies().iterator();
            while (i.hasNext()) {
                URI foreignOntURI = (URI)i.next();
                OWLRDFParser parser = new OWLRDFParser();
                parser.setConnection((OWLConnection)new OWLConnectionImpl());
                OWLOntology foreignOnt = parser.parseOntology(foreignOntURI);
                this.loadOntology(foreignOnt);
            }
        }
    }

    private void defineEntities(OWLOntology ontology) throws OWLException {
        Iterator it = null;
        it = ontology.getClasses().iterator();
        while (it.hasNext()) {
            this.kb.addClass((ATerm)this.term((OWLObject)((OWLClass)it.next())));
        }
        it = ontology.getObjectProperties().iterator();
        while (it.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)it.next();
            ATermAppl p = this.term((OWLObject)prop);
            if (prop.isLink()) {
                ((EconnectedKB)this.kb).addLinkProperty((ATerm)p);
                String target = prop.getLinkTarget().toString();
                Role role = this.kb.getProperty((ATerm)p);
                role.setForeignOntology(target);
                continue;
            }
            this.kb.addObjectProperty((ATerm)p);
        }
        it = ontology.getDataProperties().iterator();
        while (it.hasNext()) {
            this.kb.addDatatypeProperty((ATerm)this.term((OWLObject)((OWLDataProperty)it.next())));
        }
        it = ontology.getIndividuals().iterator();
        while (it.hasNext()) {
            this.kb.addIndividual(this.term((OWLObject)((OWLIndividual)it.next())));
        }
    }

    private void loadClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        Iterator it = null;
        ATermAppl c = this.term((OWLObject)clazz);
        this.kb.addClass((ATerm)c);
        it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription eq = (OWLDescription)it.next();
            this.kb.addSameClass(c, this.term((OWLObject)eq));
        }
        it = clazz.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription sup = (OWLDescription)it.next();
            this.kb.addSubClass(c, this.term((OWLObject)sup));
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            OWLEnumeration en = (OWLEnumeration)it.next();
            this.kb.addSameClass(c, this.term((OWLObject)en));
        }
    }

    private void loadIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        Iterator<Object> it = null;
        ATermAppl indReference = this.term((OWLObject)ind);
        it = ind.getTypes(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            this.visitor.reset();
            desc.accept((OWLObjectVisitor)this.visitor);
            this.kb.addType(indReference, this.visitor.result());
        }
        Map propertyValues = ind.getObjectPropertyValues(ontology);
        it = propertyValues.keySet().iterator();
        while (it.hasNext()) {
            OWLObjectProperty op = (OWLObjectProperty)it.next();
            Set vals = (Set)propertyValues.get(op);
            if (vals == null) continue;
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                OWLIndividual oi = (OWLIndividual)valIt.next();
                ATermAppl obj = this.term((OWLObject)oi);
                this.kb.addPropertyValue(this.term((OWLObject)op), indReference, obj);
            }
        }
        Map dataValues = ind.getDataPropertyValues(ontology);
        it = dataValues.keySet().iterator();
        while (it.hasNext()) {
            OWLDataProperty dp = (OWLDataProperty)it.next();
            Set vals = (Set)dataValues.get(dp);
            Iterator valIt = vals.iterator();
            while (valIt.hasNext()) {
                OWLDataValue dv = (OWLDataValue)valIt.next();
                String lexicalValue = dv.getValue().toString();
                URI datatypeURI = dv.getURI();
                ATermAppl literalValue = null;
                literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI.toString()) : (dv.getLang() != null ? ATermUtils.makePlainLiteral(lexicalValue, dv.getLang()) : ATermUtils.makePlainLiteral(lexicalValue));
                this.kb.addPropertyValue(this.term((OWLObject)dp), indReference, literalValue);
            }
        }
    }

    private void loadObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        ATermAppl p = this.term((OWLObject)prop);
        Iterator it = null;
        if (prop.isTransitive(ontology)) {
            this.kb.addTransitiveProperty(p);
        }
        if (prop.isFunctional(ontology)) {
            this.kb.addFunctionalProperty(p);
        }
        if (prop.isInverseFunctional(ontology)) {
            this.kb.addInverseFunctionalProperty((ATerm)p);
        }
        if (prop.isSymmetric(ontology)) {
            this.kb.addSymmetricProperty(p);
        }
        it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            Role roleInv;
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            if (!prop.isLink()) {
                this.kb.addInverseProperty(p, this.term((OWLObject)inv));
                continue;
            }
            Role role = this.kb.getProperty((ATerm)p);
            String ontURI = prop.getLinkTarget().toString();
            if (!((EconnectedKB)this.kb).getTBoxes().keySet().contains(ontURI)) {
                ((EconnectedKB)this.kb).addOntology(ontURI);
            }
            ((EconnectedKB)this.kb).setOntology(ontURI);
            if (!((EconnectedKB)this.kb).getRBox().isRole((ATerm)this.term((OWLObject)inv))) {
                ((EconnectedKB)this.kb).addLinkProperty((ATerm)this.term((OWLObject)inv));
            }
            if ((roleInv = this.kb.getProperty((ATerm)this.term((OWLObject)inv))) != null) {
                roleInv.setForeignOntology(ontology.getURI().toString());
            }
            ((EconnectedKB)this.kb).setOntology(ontology.getURI().toString());
            ((EconnectedKB)this.kb).addInverseLink(role, roleInv);
        }
        it = prop.getSuperProperties(ontology).iterator();
        while (it.hasNext()) {
            OWLObjectProperty sup = (OWLObjectProperty)it.next();
            this.kb.addSubProperty(p, this.term((OWLObject)sup));
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.kb.addDomain((ATerm)p, this.visitor.result());
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription ran = (OWLDescription)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.kb.addRange((ATerm)p, this.visitor.result());
        }
    }

    private void loadDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        ATermAppl p = this.term((OWLObject)prop);
        Iterator it = null;
        this.kb.addDatatypeProperty((ATerm)p);
        if (prop.isFunctional(ontology)) {
            this.kb.addFunctionalProperty(p);
        }
        it = prop.getSuperProperties(ontology).iterator();
        while (it.hasNext()) {
            OWLDataProperty sup = (OWLDataProperty)it.next();
            this.kb.addSubProperty(p, this.term((OWLObject)sup));
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.kb.addDomain((ATerm)p, this.visitor.result());
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            OWLDataRange ran = (OWLDataRange)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.kb.addRange((ATerm)p, this.visitor.result());
        }
    }

    private void loadDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
        if (!this.kb.getDatatypeReasoner().isDefined(datatype.getURI().toString())) {
            throw new OWLException("Unsupported datatype " + datatype.getURI() + " in ontology " + ontology.getURI());
        }
    }

    private void loadClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
    }

    private void loadPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
    }

    private void loadIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
    }

    public Set getOntologies() {
        return this.ontologies;
    }
}

