/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.owlapi.PelletLoader;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLConsistencyChecker;
import org.semanticweb.owl.inference.OWLIndividualReasoner;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLTaxonomyReasoner;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.OntologyChangeListener;

public class Reasoner
implements OWLReasoner,
OWLConsistencyChecker,
OWLClassReasoner,
OWLTaxonomyReasoner,
OWLIndividualReasoner,
OntologyChangeListener {
    private static XMLSchemaSimpleDatatypeVocabulary XSD = XMLSchemaSimpleDatatypeVocabulary.INSTANCE;
    public static final int UNKNOWN = -1;
    private PelletLoader loader;
    private OWLOntology ontology;
    private Set ontologies;
    protected KnowledgeBase kb = new KnowledgeBase();
    int consistent = 2;
    boolean autoClassify = false;
    boolean autoRealize = false;
    static /* synthetic */ Class class$org$semanticweb$owl$model$OWLAnnotationProperty;

    public Reasoner() {
        this.loader = new PelletLoader(this.kb);
    }

    public boolean loadImports() {
        return this.loader.loadImports();
    }

    public void setLoadImports(boolean loadImports) throws OWLException {
        this.loader.setLoadImports(loadImports);
        this.refreshOntology();
    }

    public void refreshOntology() throws OWLException {
        if (this.ontology != null) {
            this.setOntology(this.ontology);
        }
    }

    public void setOntology(OWLOntology ontology) throws OWLException {
        this.ontology = ontology;
        if (!ontology.getForeignOntologies().isEmpty()) {
            this.loader.setKB(new EconnectedKB());
        }
        this.loader.reset();
        this.loader.load(ontology);
        this.kb = this.loader.getKB();
        this.ontologies = this.loader.getOntologies();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public Set getOntologies() {
        return this.ontologies;
    }

    public int consistency(OWLOntology ontology) throws OWLException {
        this.setOntology(ontology);
        return this.consistency();
    }

    public int consistency() {
        return this.consistent;
    }

    public Set superClassesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c), true), OWLClass.class);
    }

    public Set ancestorClassesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public Set subClassesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c), true), OWLClass.class);
    }

    public Set descendantClassesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public Set equivalentClassesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public boolean isInstanceOf(OWLIndividual ind, OWLClass c) throws OWLException {
        return this.kb.isType(this.loader.term((OWLObject)ind), this.loader.term((OWLObject)c));
    }

    public boolean isInstanceOf(OWLIndividual ind, OWLDescription d) throws OWLException {
        return this.kb.isType(this.loader.term((OWLObject)ind), this.loader.term((OWLObject)d));
    }

    public Set allInstancesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySet(this.kb.getInstances(this.loader.term((OWLObject)c)), OWLIndividual.class);
    }

    public Set instancesOf(OWLClass c) throws OWLException {
        return this.toOWLEntitySet(this.kb.getInstances(this.loader.term((OWLObject)c), true), OWLIndividual.class);
    }

    public Set instancesOf(OWLDescription d) throws OWLException {
        return this.toOWLEntitySet(this.kb.getInstances(this.loader.term((OWLObject)d)), OWLIndividual.class);
    }

    public void ontologyChanged(OntologyChange change) throws OWLException {
        this.refreshOntology();
    }

    public Set getClasses() {
        try {
            return this.toOWLEntitySet(this.kb.getClasses(), OWLClass.class);
        }
        catch (OWLException e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    public Set getProperties() {
        try {
            return this.toOWLEntitySet(this.kb.getProperties(), OWLProperty.class);
        }
        catch (OWLException e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    public Set getObjectProperties() {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        Iterator props = this.getProperties().iterator();
        while (props.hasNext()) {
            OWLProperty prop = (OWLProperty)props.next();
            if (!(prop instanceof OWLObjectProperty)) continue;
            set.add(prop);
        }
        return set;
    }

    public OWLIndividual getPropertyValue(OWLIndividual ind, OWLObjectProperty prop) throws OWLException {
        Set values = this.getPropertyValues(ind, prop);
        return values.isEmpty() ? null : (OWLIndividual)values.iterator().next();
    }

    public OWLDataValue getPropertyValue(OWLIndividual ind, OWLDataProperty prop) throws OWLException {
        Set values = this.getPropertyValues(ind, prop);
        return values.isEmpty() ? null : (OWLDataValue)values.iterator().next();
    }

    public Set getPropertyValues(OWLIndividual ind, OWLObjectProperty prop) throws OWLException {
        return this.toOWLEntitySet(this.kb.getObjectPropertyValues(this.loader.term((OWLObject)prop), this.loader.term((OWLObject)ind)), OWLIndividual.class);
    }

    public Set getPropertyValues(OWLIndividual ind, OWLDataProperty prop) throws OWLException {
        return this.toOWLEntitySet(this.kb.getDataPropertyValues(this.loader.term((OWLObject)prop), this.loader.term((OWLObject)ind)), OWLDataValue.class);
    }

    public Set getPropertyValues(OWLIndividual ind, OWLProperty prop) throws OWLException {
        if (prop instanceof OWLObjectProperty) {
            return this.getPropertyValues(ind, (OWLObjectProperty)prop);
        }
        if (prop instanceof OWLDataProperty) {
            return this.getPropertyValues(ind, (OWLDataProperty)prop);
        }
        throw new OWLException("Property " + prop + " is neither data nor object property!");
    }

    public Map getDataPropertyValues(OWLIndividual ind) throws OWLException {
        HashMap<OWLDataProperty, Set> values = new HashMap<OWLDataProperty, Set>();
        Set dataProps = this.getDataProperties();
        Iterator i = dataProps.iterator();
        while (i.hasNext()) {
            OWLDataProperty prop = (OWLDataProperty)i.next();
            Set set = this.getPropertyValues(ind, prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Map getObjectPropertyValues(OWLIndividual ind) throws OWLException {
        HashMap<OWLObjectProperty, Set> values = new HashMap<OWLObjectProperty, Set>();
        Set objProps = this.getObjectProperties();
        Iterator i = objProps.iterator();
        while (i.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)i.next();
            Set set = this.getPropertyValues(ind, prop);
            if (set.isEmpty()) continue;
            values.put(prop, set);
        }
        return values;
    }

    public Map getPropertyValues(OWLObjectProperty prop) throws OWLException {
        HashMap<OWLIndividual, Set> result = new HashMap<OWLIndividual, Set>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        Map values = this.kb.getPropertyValues(p);
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            ATermAppl subjTerm = (ATermAppl)i.next();
            Collection objTerms = (Collection)values.get(subjTerm);
            OWLIndividual subj = (OWLIndividual)this.getEntity(URI.create(subjTerm.getName()), class$org$semanticweb$owl$model$OWLIndividual == null ? Reasoner.class$("org.semanticweb.owl.model.OWLIndividual") : class$org$semanticweb$owl$model$OWLIndividual);
            Set objects = this.toOWLEntitySet(objTerms, class$org$semanticweb$owl$model$OWLIndividual == null ? Reasoner.class$("org.semanticweb.owl.model.OWLIndividual") : class$org$semanticweb$owl$model$OWLIndividual);
            result.put(subj, objects);
        }
        return result;
    }

    public Map getPropertyValues(OWLDataProperty prop) throws OWLException {
        HashMap<OWLIndividual, Set> map = new HashMap<OWLIndividual, Set>();
        ATermAppl p = this.loader.term((OWLObject)prop);
        List candidates = this.kb.retrieveIndividualsWithProperty(p);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl candidate = (ATermAppl)i.next();
            List list = this.kb.getDataPropertyValues(p, candidate);
            if (list.isEmpty()) continue;
            OWLIndividual subj = (OWLIndividual)this.getEntity(URI.create(candidate.getName()), class$org$semanticweb$owl$model$OWLIndividual == null ? Reasoner.class$("org.semanticweb.owl.model.OWLIndividual") : class$org$semanticweb$owl$model$OWLIndividual);
            Set objects = this.toOWLEntitySet(list, class$org$semanticweb$owl$model$OWLDataValue == null ? Reasoner.class$("org.semanticweb.owl.model.OWLDataValue") : class$org$semanticweb$owl$model$OWLDataValue);
            map.put(subj, objects);
        }
        return map;
    }

    public Map getPropertyValues(OWLProperty prop) throws OWLException {
        if (prop instanceof OWLObjectProperty) {
            return this.getPropertyValues((OWLObjectProperty)prop);
        }
        if (prop instanceof OWLDataProperty) {
            return this.getPropertyValues((OWLDataProperty)prop);
        }
        throw new OWLException("Property " + prop + " is neither data nor object property!");
    }

    public boolean hasPropertyValue(OWLIndividual subj, OWLObjectProperty prop, OWLIndividual obj) throws OWLException {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subj), this.loader.term((OWLObject)prop), this.loader.term((OWLObject)obj));
    }

    public boolean hasPropertyValue(OWLIndividual subj, OWLDataProperty prop, OWLDataValue obj) throws OWLException {
        return this.kb.hasPropertyValue(this.loader.term((OWLObject)subj), this.loader.term((OWLObject)prop), this.loader.term((OWLObject)obj));
    }

    public Set getDataProperties() {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        Iterator props = this.getProperties().iterator();
        while (props.hasNext()) {
            OWLProperty prop = (OWLProperty)props.next();
            if (!(prop instanceof OWLDataProperty)) continue;
            set.add(prop);
        }
        return set;
    }

    public Set getAnnotationProperties() {
        HashSet set = new HashSet();
        try {
            Iterator ont = this.getOntologies().iterator();
            while (ont.hasNext()) {
                OWLOntology o = (OWLOntology)ont.next();
                set.addAll(o.getAnnotationProperties());
            }
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public Set getIndividuals() {
        try {
            return this.toOWLEntitySet(this.kb.getIndividuals(), OWLIndividual.class);
        }
        catch (OWLException e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    public OWLClass getClass(URI uri) throws OWLException {
        return (OWLClass)this.getEntity(uri, OWLClass.class);
    }

    public OWLObjectProperty getObjectProperty(URI uri) throws OWLException {
        return (OWLObjectProperty)this.getEntity(uri, OWLObjectProperty.class);
    }

    public OWLDataProperty getDataProperty(URI uri) throws OWLException {
        return (OWLDataProperty)this.getEntity(uri, OWLDataProperty.class);
    }

    public OWLIndividual getIndividual(URI uri) throws OWLException {
        return (OWLIndividual)this.getEntity(uri, OWLIndividual.class);
    }

    public OWLObject getEntity(URI uri, Class type) throws OWLException {
        OWLClass entity = null;
        Iterator i = this.ontologies.iterator();
        while (entity == null && i.hasNext()) {
            OWLOntology o = (OWLOntology)i.next();
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLClass == null ? Reasoner.class$("org.semanticweb.owl.model.OWLClass") : class$org$semanticweb$owl$model$OWLClass)) {
                entity = o.getClass(uri);
            }
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLDataType == null ? Reasoner.class$("org.semanticweb.owl.model.OWLDataType") : class$org$semanticweb$owl$model$OWLDataType)) {
                entity = o.getDatatype(uri);
            }
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLDataType == null ? Reasoner.class$("org.semanticweb.owl.model.OWLDataType") : class$org$semanticweb$owl$model$OWLDataType) && XSD.getDatatypes().contains(uri.toString())) {
                entity = o.getOWLDataFactory().getOWLConcreteDataType(uri);
            }
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLObjectProperty == null ? Reasoner.class$("org.semanticweb.owl.model.OWLObjectProperty") : class$org$semanticweb$owl$model$OWLObjectProperty)) {
                entity = o.getObjectProperty(uri);
            }
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLDataProperty == null ? Reasoner.class$("org.semanticweb.owl.model.OWLDataProperty") : class$org$semanticweb$owl$model$OWLDataProperty)) {
                entity = o.getDataProperty(uri);
            }
            if (entity == null && type.isAssignableFrom(class$org$semanticweb$owl$model$OWLIndividual == null ? Reasoner.class$("org.semanticweb.owl.model.OWLIndividual") : class$org$semanticweb$owl$model$OWLIndividual)) {
                entity = o.getIndividual(uri);
            }
            if (entity != null || !type.isAssignableFrom(class$org$semanticweb$owl$model$OWLAnnotationProperty == null ? Reasoner.class$("org.semanticweb.owl.model.OWLAnnotationProperty") : class$org$semanticweb$owl$model$OWLAnnotationProperty)) continue;
            entity = o.getAnnotationProperty(uri);
        }
        return entity;
    }

    private Set toOWLEntitySetOfSet(Set set, Class type) throws OWLException {
        HashSet<Set> results = new HashSet<Set>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Set entitySet = this.toOWLEntitySet((Set)i.next(), type);
            if (entitySet.isEmpty()) continue;
            results.add(entitySet);
        }
        return results;
    }

    protected Set toOWLEntitySet(Collection set, Class type) throws OWLException {
        HashSet<OWLObject> results = new HashSet<OWLObject>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            OWLObject e = null;
            if (obj instanceof Role) {
                try {
                    URI uri = new URI(((Role)obj).getName().getName());
                    e = this.getEntity(uri, type);
                }
                catch (URISyntaxException x) {
                    throw new OWLException("Cannot create URI from term " + x);
                }
            }
            if (obj instanceof Literal) {
                Literal lit = (Literal)obj;
                URI datatypeURI = lit.getDatatypeURI() == null ? null : URI.create(lit.getDatatypeURI());
                Object value = lit.getValue();
                if (value instanceof StringValue) {
                    value = ((StringValue)value).getValue();
                }
                e = this.ontology.getOWLDataFactory().getOWLConcreteData(datatypeURI, lit.getLang(), value);
            } else {
                ATermAppl a = (ATermAppl)obj;
                if (a.equals(ATermUtils.TOP)) {
                    e = this.ontology.getOWLDataFactory().getOWLThing();
                } else if (a.equals(ATermUtils.BOTTOM)) {
                    e = this.ontology.getOWLDataFactory().getOWLNothing();
                } else if (a.getArity() == 0) {
                    URI uri;
                    try {
                        uri = new URI(a.getName());
                    }
                    catch (URISyntaxException x) {
                        throw new OWLException("Cannot create URI from term " + x);
                    }
                    e = this.getEntity(uri, type);
                }
            }
            if (e == null) continue;
            results.add(e);
        }
        return results;
    }

    public boolean isSubClassOf(OWLDescription c1, OWLDescription c2) throws OWLException {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isSubTypeOf(OWLDataType d1, OWLDataType d2) throws OWLException {
        return this.kb.isSubClassOf(this.loader.term((OWLObject)d1), this.loader.term((OWLObject)d2));
    }

    public boolean isEquivalentClass(OWLDescription c1, OWLDescription c2) throws OWLException {
        return this.kb.isEquivalentClass(this.loader.term((OWLObject)c1), this.loader.term((OWLObject)c2));
    }

    public boolean isConsistent() {
        return this.kb.isConsistent();
    }

    public boolean isConsistent(OWLDescription d) throws OWLException {
        try {
            return this.kb.isSatisfiable(this.loader.term((OWLObject)d));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OWLException(e.getMessage());
        }
    }

    public Set superClassesOf(OWLDescription c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c), true), OWLClass.class);
    }

    public Set ancestorClassesOf(OWLDescription c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public Set subClassesOf(OWLDescription c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c), true), OWLClass.class);
    }

    public Set descendantClassesOf(OWLDescription c) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public Set equivalentClassesOf(OWLDescription c) throws OWLException {
        return this.toOWLEntitySet(this.kb.getEquivalentClasses(this.loader.term((OWLObject)c)), OWLClass.class);
    }

    public boolean isAutoClassify() {
        return this.autoClassify;
    }

    public void setAutoClassify(boolean autoClassify) {
        this.autoClassify = autoClassify;
    }

    public boolean isAutoRealize() {
        return this.autoRealize;
    }

    public void setAutoRealize(boolean autoRealize) {
        this.autoRealize = autoRealize;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Set superPropertiesOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)prop), true), OWLProperty.class);
    }

    public Set ancestorPropertiesOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSuperProperties(this.loader.term((OWLObject)prop)), OWLProperty.class);
    }

    public Set subPropertiesOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)prop), true), OWLProperty.class);
    }

    public Set descendantPropertiesOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getSubProperties(this.loader.term((OWLObject)prop)), OWLProperty.class);
    }

    public Set equivalentPropertiesOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySet(this.kb.getEquivalentProperties(this.loader.term((OWLObject)prop)), OWLProperty.class);
    }

    public Set inversePropertiesOf(OWLObjectProperty prop) throws OWLException {
        return this.toOWLEntitySet(this.kb.getInverses((ATerm)this.loader.term((OWLObject)prop)), OWLProperty.class);
    }

    public Set rangesOf(OWLProperty prop) throws OWLException {
        if (prop instanceof OWLObjectProperty) {
            return this.toOWLEntitySet(this.kb.getRanges((ATerm)this.loader.term((OWLObject)prop)), OWLClass.class);
        }
        return this.toOWLEntitySet(this.kb.getRanges((ATerm)this.loader.term((OWLObject)prop)), OWLDataType.class);
    }

    public Set domainsOf(OWLProperty prop) throws OWLException {
        return this.toOWLEntitySet(this.kb.getDomains(this.loader.term((OWLObject)prop)), OWLClass.class);
    }

    public OWLClass typeOf(OWLIndividual ind) throws OWLException {
        Set types = this.typesOf(ind);
        types = types.isEmpty() ? types : (Set)types.iterator().next();
        return types.isEmpty() ? null : (OWLClass)types.iterator().next();
    }

    public Set typesOf(OWLIndividual ind) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getTypes(this.loader.term((OWLObject)ind), true), OWLClass.class);
    }

    public Set allTypesOf(OWLIndividual ind) throws OWLException {
        return this.toOWLEntitySetOfSet(this.kb.getTypes(this.loader.term((OWLObject)ind)), OWLClass.class);
    }

    public Set getSameAsIndividuals(OWLIndividual ind) throws OWLException {
        return this.toOWLEntitySet(this.kb.getSames(this.loader.term((OWLObject)ind)), OWLIndividual.class);
    }
}

