/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QuerySplitter;
import org.mindswap.pellet.query.impl.DistVarsQueryExec;
import org.mindswap.pellet.query.impl.JenaRDQLParser;
import org.mindswap.pellet.query.impl.MultiQueryResults;
import org.mindswap.pellet.query.impl.NoDistVarsQueryExec;
import org.mindswap.pellet.query.impl.OptimizedQueryExec;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.query.impl.SimpleQueryExec;
import org.mindswap.pellet.utils.Timer;

public class QueryEngine {
    public static boolean DEBUG = false;
    private static DistVarsQueryExec distVars = new DistVarsQueryExec();
    private static OptimizedQueryExec optimized = new OptimizedQueryExec();
    private static SimpleQueryExec simple = new SimpleQueryExec();
    private static NoDistVarsQueryExec noVars = new NoDistVarsQueryExec();
    private static QueryExec[] queryExecs = new QueryExec[]{noVars, distVars, optimized, simple};
    private static QuerySplitter splitter = new QuerySplitter();

    public static QueryResults exec(String queryStr, KnowledgeBase kb) {
        Timer t = kb.timers.startTimer("queryParse");
        JenaRDQLParser parser = new JenaRDQLParser();
        Query query = parser.parse(queryStr, kb);
        t.stop();
        return QueryEngine.exec(query);
    }

    public static QueryResults exec(Query query) {
        if (query.getQueryPatterns().isEmpty()) {
            QueryResultsImpl results = new QueryResultsImpl(query);
            results.add(new QueryResultBindingImpl());
            return results;
        }
        if (query.isGround()) {
            return noVars.exec(query);
        }
        List queries = splitter.split(query);
        if (queries.isEmpty()) {
            throw new InternalReasonerException("Splitting query returned no results!");
        }
        if (queries.size() == 1) {
            return QueryEngine.execSingleQuery((Query)queries.get(0));
        }
        QueryResults[] results = new QueryResults[queries.size()];
        for (int i = 0; i < queries.size(); ++i) {
            Query qry = (Query)queries.get(i);
            results[i] = QueryEngine.execSingleQuery(qry);
        }
        return new MultiQueryResults(query, results);
    }

    private static QueryResults execSingleQuery(Query query) {
        for (int i = 0; i < queryExecs.length; ++i) {
            if (!queryExecs[i].supports(query)) continue;
            Timer timer = query.getKB().timers.startTimer("Query");
            QueryExec queryExec = queryExecs[i];
            QueryResults results = queryExec.exec(query);
            timer.stop();
            return results;
        }
        throw new InternalReasonerException("Cannot determine which query engine to use");
    }

    public static boolean execBoolean(Query query) {
        return noVars.execBoolean(query);
    }

    public static List split(Query query) {
        List vars = query.getObjVars();
        HashSet graphs = new HashSet();
        HashSet processed = new HashSet();
        Iterator i = vars.iterator();
        while (i.hasNext()) {
            ATermAppl var = (ATermAppl)i.next();
            if (processed.contains(var)) continue;
            HashSet graph = new HashSet();
            QueryEngine.addVar(var, query, graph, processed);
            graphs.add(graph);
        }
        if (graphs.size() == 1) {
            return Collections.singletonList(query);
        }
        ArrayList queries = new ArrayList();
        return queries;
    }

    private static void addVar(ATermAppl var, Query query, Set graph, Set processed) {
        if (graph.contains(var)) {
            return;
        }
        graph.add(var);
        processed.add(var);
        List outList = query.findPatterns(var, null, null);
        Iterator i = outList.iterator();
        while (i.hasNext()) {
            QueryPattern pattern = (QueryPattern)i.next();
            ATermAppl obj = pattern.getObject();
            QueryEngine.addVar(obj, query, graph, processed);
        }
        List inList = query.findPatterns(null, null, var);
        Iterator i2 = inList.iterator();
        while (i2.hasNext()) {
            QueryPattern pattern = (QueryPattern)i2.next();
            ATermAppl subj = pattern.getSubject();
            QueryEngine.addVar(subj, query, graph, processed);
        }
    }
}

