/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.utils.ATermUtils;

public class DistVarsQueryExec
implements QueryExec {
    private Query query;
    private KnowledgeBase kb;
    private List patterns;

    public void prepare() {
        if (!PelletOptions.USE_CACHING || !this.kb.isClassified()) {
            List vars = this.query.getObjVars();
            for (int i = 0; i < vars.size(); ++i) {
                ATermAppl var = (ATermAppl)vars.get(i);
                ATermList list = this.query.getClasses(var);
                while (!list.isEmpty()) {
                    ATermAppl c = (ATermAppl)list.getFirst();
                    ATermAppl notC = ATermUtils.makeNot((ATerm)c);
                    this.kb.isSatisfiable(c);
                    this.kb.isSatisfiable(notC);
                    list = list.getNext();
                }
            }
        }
    }

    public boolean supports(Query q) {
        return q.getDistVars().containsAll(q.getVars());
    }

    public boolean execBoolean(Query query) {
        this.query = query;
        this.kb = query.getKB();
        this.patterns = query.getQueryPatterns();
        if (this.kb == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        if (!query.getVars().isEmpty()) {
            throw new RuntimeException("Boolean query cannot have variables!");
        }
        this.prepare();
        return this.isQuerySatisfied();
    }

    public QueryResults exec(Query query) {
        this.query = query;
        this.kb = query.getKB();
        this.patterns = query.getQueryPatterns();
        if (this.kb == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        this.prepare();
        QueryResultsImpl results = this.isQuerySatisfied() ? this.exec(0, new QueryResultBindingImpl(), new QueryResultsImpl(query)) : new QueryResultsImpl(query);
        return results;
    }

    private QueryResults exec(int index, QueryResultBinding binding, QueryResults results) {
        if (this.patterns.size() <= index) {
            if (!results.getResultVars().containsAll(binding.getVars())) {
                QueryResultBindingImpl newBinding = new QueryResultBindingImpl();
                List resultVars = results.getResultVars();
                for (int i = 0; i < resultVars.size(); ++i) {
                    ATermAppl var = (ATermAppl)resultVars.get(i);
                    ATermAppl value = binding.getValue(var);
                    newBinding.setValue(var, value);
                }
                binding = newBinding;
                if (results.contains(binding)) {
                    return results;
                }
            }
            results.add(binding);
            return results;
        }
        QueryPattern pattern = (QueryPattern)this.patterns.get(index);
        if (QueryEngine.DEBUG) {
            System.out.println("Check pattern " + pattern + " " + binding);
        }
        boolean alreadySatisfied = false;
        List sValues = null;
        List oValues = null;
        if (!pattern.isGround()) {
            pattern = pattern.apply(binding);
            ATermAppl subj = pattern.getSubject();
            ATermAppl pred = pattern.getPredicate();
            ATermAppl obj = pattern.getObject();
            if (ATermUtils.isVar(subj)) {
                if (pattern.isTypePattern()) {
                    sValues = this.kb.getInstances(obj);
                    alreadySatisfied = true;
                } else if (!ATermUtils.isVar(obj)) {
                    sValues = this.kb.getIndividualsWithProperty(pred, obj);
                    alreadySatisfied = true;
                } else {
                    sValues = this.kb.retrieveIndividualsWithProperty(pred);
                }
            } else {
                sValues = Collections.singletonList(subj);
            }
            Datatype datatype = null;
            if (ATermUtils.isVar(obj)) {
                if (this.query.getLitVars().contains(obj)) {
                    datatype = this.query.getDatatype(obj);
                }
                if (!ATermUtils.isVar(subj)) {
                    oValues = datatype == null ? this.kb.getPropertyValues(pred, subj) : this.kb.getDataPropertyValues(pred, subj, datatype);
                    alreadySatisfied = true;
                } else {
                    alreadySatisfied = true;
                }
            } else {
                oValues = Collections.singletonList(obj);
            }
            Iterator i = sValues.iterator();
            while (i.hasNext()) {
                ATermAppl sValue = (ATermAppl)i.next();
                Iterator j = null;
                j = oValues != null ? oValues.iterator() : (datatype == null ? this.kb.getPropertyValues(pred, sValue).iterator() : this.kb.getDataPropertyValues(pred, sValue, datatype).iterator());
                while (j.hasNext()) {
                    ATermAppl oValue;
                    Object value = j.next();
                    ATermAppl aTermAppl = oValue = value instanceof ATermAppl ? (ATermAppl)value : ((Literal)value).getTerm();
                    if (!alreadySatisfied && !this.isTripleSatisfied(sValue, pred, oValue)) continue;
                    QueryResultBinding newBinding = (QueryResultBinding)binding.clone();
                    if (ATermUtils.isVar(subj)) {
                        newBinding.setValue(subj, sValue);
                    }
                    if (ATermUtils.isVar(obj)) {
                        newBinding.setValue(obj, oValue);
                    }
                    results = this.exec(index + 1, newBinding, results);
                }
            }
        } else {
            results = this.exec(index + 1, binding, results);
        }
        return results;
    }

    private boolean isQuerySatisfied() {
        if (QueryEngine.DEBUG) {
            System.out.println("Check ground triples");
        }
        boolean querySatisfied = true;
        for (int i = 0; querySatisfied && i < this.patterns.size(); ++i) {
            QueryPattern triple = (QueryPattern)this.patterns.get(i);
            if (!triple.isGround()) continue;
            querySatisfied = this.isTripleSatisfied(triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        return querySatisfied;
    }

    private boolean isTripleSatisfied(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (QueryEngine.DEBUG) {
            System.out.println("Check triple " + s + " " + (p == null ? "rdf:type" : p.getName()) + " " + o);
        }
        if (ATermUtils.isVar(s) || ATermUtils.isVar(o)) {
            throw new RuntimeException("No value assigned to variables when checking triple in query!");
        }
        boolean tripleSatisfied = p == null ? this.kb.isType(s, o) : this.kb.hasPropertyValue(s, p, o);
        return tripleSatisfied;
    }
}

