/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.utils.ATermUtils;

public class LiteralIterator
implements Iterator {
    QueryResultBinding binding;
    List litVars;
    ArrayList[] lb;
    int[] indices;
    boolean more = true;

    public LiteralIterator(Query q, QueryResultBinding binding) {
        KnowledgeBase kb = q.getKB();
        this.binding = binding;
        this.litVars = q.getDistLitVars();
        this.lb = new ArrayList[this.litVars.size()];
        this.indices = new int[this.litVars.size()];
        for (int i = 0; i < this.litVars.size(); ++i) {
            ATermAppl litVar = (ATermAppl)this.litVars.get(i);
            Datatype dtype = q.getDatatype(litVar);
            QueryPattern pattern = (QueryPattern)q.findPatterns(null, null, litVar).get(0);
            ATermAppl name = pattern.getSubject();
            if (ATermUtils.isVar(name)) {
                name = binding.getValue(name);
            }
            this.lb[i] = new ArrayList();
            List act = kb.getDataPropertyValues(pattern.getPredicate(), name, dtype);
            if (act.size() > 0) {
                Iterator a = act.iterator();
                while (a.hasNext()) {
                    Literal lit = (Literal)a.next();
                    this.lb[i].add(lit);
                }
                continue;
            }
            this.more = false;
        }
    }

    public void remove() {
    }

    public boolean hasNext() {
        return this.more;
    }

    public Object next() {
        if (!this.more) {
            return null;
        }
        QueryResultBinding next = (QueryResultBinding)this.binding.clone();
        for (int i = 0; i < this.indices.length; ++i) {
            ATermAppl o1 = (ATermAppl)this.litVars.get(i);
            Literal o2 = (Literal)this.lb[i].get(this.indices[i]);
            next.setValue(o1, o2.getTerm());
        }
        this.more = this.incIndex(0);
        return next;
    }

    private boolean incIndex(int index) {
        if (this.indices[index] + 1 >= this.lb[index].size()) {
            if (index == this.indices.length - 1) {
                return false;
            }
            this.indices[index] = 0;
            return this.incIndex(index + 1);
        }
        int n = index;
        this.indices[n] = this.indices[n] + 1;
        return true;
    }
}

