/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.servlet;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class DatasetManager {
    private Map onLoan = new WeakHashMap();
    private List cache;
    private int size = 0;
    private Set defaultBackground = null;
    private Set defaultNamed = null;

    public DatasetManager(int size) {
        this.cache = new Vector(size);
        this.size = size;
        this.defaultBackground = new HashSet();
        this.defaultNamed = new HashSet();
    }

    public synchronized Dataset getDataset(Set backgroundGraphs, Set namedGraphs) {
        DataSource dataset = null;
        if (backgroundGraphs.size() == 0 && namedGraphs.size() == 0) {
            backgroundGraphs = this.defaultBackground;
            namedGraphs = this.defaultNamed;
        }
        List<Set> setId = Arrays.asList(backgroundGraphs, namedGraphs);
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            DatasetAssociation association = (DatasetAssociation)iter.next();
            if (!association.id.equals(setId)) continue;
            System.err.println("Found setId: " + setId);
            this.cache.remove(association);
            this.onLoan.put(association.dataset, association);
            return association.dataset;
        }
        dataset = this.create(backgroundGraphs, namedGraphs);
        DatasetAssociation association = new DatasetAssociation(setId, (Dataset)dataset);
        this.onLoan.put(association.dataset, association);
        return dataset;
    }

    protected DataSource create(Set background, Set named) {
        String uri;
        System.out.println("Loading graphs: " + background + ", " + named);
        DataSource datasource = DatasetFactory.create();
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Iterator uriIter = background.iterator();
        while (uriIter.hasNext()) {
            uri = (String)uriIter.next();
            try {
                ontModel.read(uri);
            }
            catch (Exception e) {
                System.out.println("Couldn't load graph: " + uri);
            }
        }
        datasource.setDefaultModel((Model)ontModel);
        uriIter = named.iterator();
        while (uriIter.hasNext()) {
            uri = (String)uriIter.next();
            Model model = ModelFactory.createDefaultModel();
            try {
                model.read(uri);
            }
            catch (Exception e) {
                System.out.println("Couldn't load named graph: " + uri);
            }
            datasource.addNamedModel(uri, model);
        }
        return datasource;
    }

    public void reset() {
        this.onLoan = new WeakHashMap();
        this.cache = new Vector(this.size);
    }

    public synchronized void returnDataset(Dataset dataset) {
        if (!this.onLoan.containsKey(dataset)) {
            System.out.println("Warning: dataset not on loan!");
            return;
        }
        DatasetAssociation association = (DatasetAssociation)this.onLoan.get(dataset);
        this.cache.add(association);
        while (this.cache.size() > this.size) {
            System.out.println("Pushing " + ((DatasetAssociation)this.cache.get((int)0)).id + " off the cache.");
            this.cache.remove(0);
        }
    }

    public void setDefaultDataset(Set background, Set named) {
        this.defaultBackground = background;
        this.defaultNamed = named;
    }

    private class DatasetAssociation {
        public Object id;
        public Dataset dataset;

        public DatasetAssociation(Object id, Dataset dataset) {
            this.id = id;
            this.dataset = dataset;
        }
    }
}

