/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.swrl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Vector;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.swrl.OWLRuleVocabulary;
import org.mindswap.pellet.utils.ATermUtils;

public class OWLRule {
    HashSet variables = new HashSet();
    KnowledgeBase ruleBody = null;
    Vector ruleHead = new Vector();
    Model model = null;

    OWLRule(Resource rule) {
        this.model = rule.getModel();
        this.parseAntecedent(rule.getProperty(OWLRuleVocabulary.antecedent).getResource());
        this.parseConsequent(rule.getProperty(OWLRuleVocabulary.consequent).getResource());
    }

    public String toString() {
        return this.ruleHead + " :- " + this.ruleBody;
    }

    ATermAppl node2term(Resource r) {
        if (this.isVariable(r)) {
            return ATermUtils.makeTermAppl("bNode" + r.getLocalName());
        }
        return ATermUtils.makeTermAppl(r.getURI());
    }

    boolean isVariable(Resource x) {
        return this.variables.contains(x);
    }

    ATermAppl defineNode(Resource x) {
        ATermAppl a = null;
        if (x.hasProperty(RDF.type, (RDFNode)OWLRuleVocabulary.Variable) && !this.isVariable(x)) {
            this.variables.add(x);
            a = this.node2term(x);
            this.ruleBody.addIndividual(a);
        } else {
            a = this.node2term(x);
            if (!this.ruleBody.isIndividual((ATerm)a)) {
                this.ruleBody.addIndividual(a);
            }
        }
        return a;
    }

    boolean unsafeVariable(Resource x) {
        return x.hasProperty(RDF.type, (RDFNode)OWLRuleVocabulary.Variable) && !this.isVariable(x);
    }

    void parseAntecedent(Resource antecedent) {
        this.ruleBody = new KnowledgeBase();
        Resource atom = antecedent.getProperty(RDF.first).getResource();
        while (!antecedent.equals(RDF.nil)) {
            atom = antecedent.getProperty(RDF.first).getResource();
            Resource atomType = atom.getProperty(RDF.type).getResource();
            if (atomType.equals(OWLRuleVocabulary.classAtom)) {
                Resource c = atom.getProperty(OWLRuleVocabulary.classPredicate).getResource();
                Resource x = atom.getProperty(OWLRuleVocabulary.argument1).getResource();
                ATermAppl a = this.defineNode(x);
                this.ruleBody.addType(a, this.node2term(c));
            } else if (atomType.equals(OWLRuleVocabulary.individualPropertyAtom)) {
                Resource p = atom.getProperty(OWLRuleVocabulary.propertyPredicate).getResource();
                Resource r1 = atom.getProperty(OWLRuleVocabulary.argument1).getResource();
                Resource r2 = atom.getProperty(OWLRuleVocabulary.argument2).getResource();
                ATermAppl r = this.node2term(p);
                ATermAppl x1 = this.defineNode(r1);
                ATermAppl x2 = this.defineNode(r2);
                this.ruleBody.getRBox().addObjectRole(r);
                this.ruleBody.addPropertyValue(r, x1, x2);
            } else {
                if (atomType.equals(OWLRuleVocabulary.datavaluedPropertyAtom)) {
                    throw new RuntimeException("datavaluedPropertyAtom in antecedent is not supported yet!");
                }
                if (atomType.equals(OWLRuleVocabulary.sameIndividualAtom)) {
                    throw new RuntimeException("sameIndividualAtom in antecedent is not supported yet!");
                }
                if (atomType.equals(OWLRuleVocabulary.differentIndividualAtom)) {
                    throw new RuntimeException("differentIndividualAtom in antecedent is not supported yet!");
                }
            }
            antecedent = antecedent.getProperty(RDF.rest).getResource();
        }
    }

    void parseConsequent(Resource consequent) throws UnsafeVariableException {
        this.ruleHead = new Vector();
        Resource atom = consequent.getProperty(RDF.first).getResource();
        while (!consequent.equals(RDF.nil)) {
            atom = consequent.getProperty(RDF.first).getResource();
            Resource atomType = atom.getProperty(RDF.type).getResource();
            if (atomType.equals(OWLRuleVocabulary.classAtom)) {
                Resource c = atom.getProperty(OWLRuleVocabulary.classPredicate).getResource();
                Resource x = atom.getProperty(OWLRuleVocabulary.argument1).getResource();
                if (this.unsafeVariable(x)) {
                    throw new UnsafeVariableException(x + " is unsafe");
                }
                this.ruleHead.add(ATermUtils.makeTermAppl(ATermUtils.TYPEFUN, new ATerm[]{this.node2term(x), this.node2term(c)}));
            } else if (atomType.equals(OWLRuleVocabulary.individualPropertyAtom)) {
                Resource p1 = atom.getProperty(OWLRuleVocabulary.propertyPredicate).getResource();
                Resource r1 = atom.getProperty(OWLRuleVocabulary.argument1).getResource();
                Resource r2 = atom.getProperty(OWLRuleVocabulary.argument2).getResource();
                if (this.unsafeVariable(r1)) {
                    throw new UnsafeVariableException(r1 + " is unsafe");
                }
                if (this.unsafeVariable(r2)) {
                    throw new UnsafeVariableException(r2 + " is unsafe");
                }
                this.ruleHead.add(ATermUtils.makeTermAppl(ATermUtils.IPFUN, new ATerm[]{this.node2term(r1), this.node2term(p1), this.node2term(r2)}));
            } else {
                if (atomType.equals(OWLRuleVocabulary.datavaluedPropertyAtom)) {
                    throw new RuntimeException("datavaluedPropertyAtom in consequent is not supported yet!");
                }
                if (atomType.equals(OWLRuleVocabulary.sameIndividualAtom)) {
                    throw new RuntimeException("sameIndividualAtom in consequent is not supported yet!");
                }
                if (atomType.equals(OWLRuleVocabulary.differentIndividualAtom)) {
                    throw new RuntimeException("differentIndividualAtom in consequent is not supported yet!");
                }
            }
            consequent = consequent.getProperty(RDF.rest).getResource();
        }
    }

    public class UnsafeVariableException
    extends RuntimeException {
        public UnsafeVariableException() {
        }

        public UnsafeVariableException(String e) {
            super(e);
        }
    }
}

