/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletQueryEngine;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.impl.model.OWLConnectionImpl;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;

public class MiscTests
extends PelletTestCase {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;

    public static TestSuite suite() {
        TestSuite s = new TestSuite("MiscTests");
        s.addTestSuite(MiscTests.class);
        return s;
    }

    public void testReflexive() {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "reflexive.owl");
        ObjectProperty knows = model.getObjectProperty(foaf + "knows");
        Individual[] people = new Individual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = model.getIndividual(ns + "P" + (i + 1));
            MiscTests.assertTrue((boolean)people[i].hasProperty((Property)knows, (RDFNode)people[i]));
            TestUtil.assertIteratorValues((TestCase)this, (Iterator)people[i].listPropertyValues((Property)knows), (Object[])new Resource[]{people[i]});
        }
        Query query = new Query("SELECT * \nWHERE (?p foaf:knows ?q) \nUSING foaf FOR <http://xmlns.com/foaf/0.1/>");
        query.setSource((Model)model);
        List answers = MiscTests.createBindings(new String[]{"p", "q"}, new Resource[][]{{people[0], people[0]}, {people[1], people[1]}, {people[2], people[2]}, {people[3], people[3]}, {people[4], people[4]}});
        QueryResults results1 = new PelletQueryEngine(query).exec();
        MiscTests.testQueryResults(results1, answers);
        QueryResults results2 = new QueryEngine(query).exec();
        MiscTests.testQueryResults(results2, answers);
    }

    public void testFoodQuery() {
        String ns = "http://www.w3.org/2001/sw/WebOnt/guide-src/food#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "food.owl");
        Resource RedMeatCourse = model.getResource(ns + "RedMeatCourse");
        Resource PastaWithLightCreamCourse = model.getResource(ns + "PastaWithLightCreamCourse");
        Individual MyLunch = model.createIndividual(ns + "MyLunch", PastaWithLightCreamCourse);
        Individual MyDinner = model.createIndividual(ns + "MyDinner", RedMeatCourse);
        Individual White = model.getIndividual(ns + "White");
        Individual Red = model.getIndividual(ns + "Red");
        String queryBody = "WHERE \t   (?Meal rdf:type food:MealCourse)\t   (?Meal food:hasDrink ?Wine)\t   (?Wine wine:hasColor ?WineColor)USING       food FOR <http://www.w3.org/2001/sw/WebOnt/guide-src/food#>      wine FOR <http://www.w3.org/2001/sw/WebOnt/guide-src/wine#>";
        String queryStr1 = "SELECT ?Meal, ?WineColor " + queryBody;
        String queryStr2 = "SELECT * " + queryBody;
        Query query1 = new Query(queryStr1);
        query1.setSource((Model)model);
        Query query2 = new Query(queryStr2);
        query2.setSource((Model)model);
        QueryResults results1 = new PelletQueryEngine(query1).exec();
        MiscTests.testQueryResults(results1, MiscTests.createBindings(new String[]{"Meal", "WineColor"}, new Resource[][]{{MyLunch, White}, {MyDinner, Red}}));
        QueryResults results2 = new PelletQueryEngine(query2).exec();
        MiscTests.assertTrue((!results2.hasNext() ? 1 : 0) != 0);
    }

    public void test3Sat() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "3Sat.owl");
        String solution = "101";
        int n = solution.length();
        Individual T = model.getIndividual(ns + "T");
        Individual F = model.getIndividual(ns + "F");
        model.prepare();
        ATermUtils.assertTrue(((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Object[] positives = new Individual[n + 1];
        Object[] negatives = new Individual[n + 1];
        positives[0] = T;
        negatives[0] = F;
        for (int i = 1; i <= n; ++i) {
            boolean t;
            boolean bl = t = solution.charAt(i - 1) == '1';
            if (t) {
                positives[i] = model.getIndividual(ns + "plus" + i);
                negatives[i] = model.getIndividual(ns + "minus" + i);
            } else {
                positives[i] = model.getIndividual(ns + "minus" + i);
                negatives[i] = model.getIndividual(ns + "plus" + i);
            }
            TestCase.assertTrue((String)(T + " = " + positives[i]), (boolean)T.isSameAs((Resource)positives[i]));
            TestCase.assertTrue((String)(F + " = " + negatives[i]), (boolean)F.isSameAs((Resource)negatives[i]));
        }
        TestUtil.assertIteratorValues((TestCase)new MiscTests(), (Iterator)T.listSameAs(), (Object[])positives, (int)0);
        TestUtil.assertIteratorValues((TestCase)new MiscTests(), (Iterator)F.listSameAs(), (Object[])negatives, (int)0);
    }

    public void testPropertyRestrictionsInSuperclasses() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((com.hp.hpl.jena.reasoner.Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass X = model.createClass(ns + "X");
        ObjectProperty hasX = model.createObjectProperty(ns + "hasX");
        AllValuesFromRestriction AllX = model.createAllValuesFromRestriction(null, (Property)hasX, (Resource)X);
        IntersectionClass Y = model.createIntersectionClass(ns + "Y", model.createList(new RDFNode[]{X, AllX}));
        MiscTests.assertTrue((String)"AllX is not a superclass of Y", (boolean)Y.hasSuperClass((Resource)AllX));
    }

    public void testMaxCardinality() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)MiscTests.term("p"));
        kb.addObjectProperty((ATerm)MiscTests.term("q"));
        kb.addFunctionalProperty(MiscTests.term("q"));
        kb.addClass((ATerm)MiscTests.term("C"));
        kb.addSubClass(MiscTests.term("C"), ATermUtils.makeMax((ATerm)MiscTests.term("p"), 2));
        kb.addClass((ATerm)MiscTests.term("D1"));
        kb.addClass((ATerm)MiscTests.term("D2"));
        kb.addClass((ATerm)MiscTests.term("D3"));
        kb.addClass((ATerm)MiscTests.term("D4"));
        kb.addClass((ATerm)MiscTests.term("E1"));
        kb.addClass((ATerm)MiscTests.term("E2"));
        kb.addClass((ATerm)MiscTests.term("E3"));
        kb.addClass((ATerm)MiscTests.term("E4"));
        kb.addSubClass(MiscTests.term("D1"), ATermUtils.makeSomeValues((ATerm)MiscTests.term("q"), (ATerm)MiscTests.term("E1")));
        kb.addSubClass(MiscTests.term("D2"), ATermUtils.makeSomeValues((ATerm)MiscTests.term("q"), (ATerm)MiscTests.term("E2")));
        kb.addSubClass(MiscTests.term("D3"), ATermUtils.makeSomeValues((ATerm)MiscTests.term("q"), (ATerm)MiscTests.term("E3")));
        kb.addSubClass(MiscTests.term("D4"), ATermUtils.makeSomeValues((ATerm)MiscTests.term("q"), (ATerm)MiscTests.term("E4")));
        kb.addIndividual(MiscTests.term("x"));
        kb.addType(MiscTests.term("x"), MiscTests.term("C"));
        kb.addIndividual(MiscTests.term("x1"));
        kb.addType(MiscTests.term("x1"), MiscTests.term("D1"));
        kb.addIndividual(MiscTests.term("x2"));
        kb.addType(MiscTests.term("x2"), MiscTests.term("D2"));
        kb.addIndividual(MiscTests.term("x3"));
        kb.addType(MiscTests.term("x3"), MiscTests.term("D3"));
        kb.addIndividual(MiscTests.term("x4"));
        kb.addType(MiscTests.term("x4"), MiscTests.term("D4"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x1"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x2"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x3"));
        kb.addPropertyValue(MiscTests.term("p"), MiscTests.term("x"), MiscTests.term("x4"));
        kb.addDisjointClass((ATerm)MiscTests.term("E1"), (ATerm)MiscTests.term("E2"));
        kb.addDisjointClass((ATerm)MiscTests.term("E1"), (ATerm)MiscTests.term("E4"));
        kb.addDisjointClass((ATerm)MiscTests.term("E2"), (ATerm)MiscTests.term("E3"));
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x1"), MiscTests.term("x3")));
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x3"), MiscTests.term("x1")));
        MiscTests.assertTrue((boolean)kb.isSameAs(MiscTests.term("x2"), MiscTests.term("x4")));
        MiscTests.assertTrue((boolean)kb.getSames(MiscTests.term("x1")).contains(MiscTests.term("x3")));
        MiscTests.assertTrue((boolean)kb.getSames(MiscTests.term("x2")).contains(MiscTests.term("x4")));
    }

    public void testAnonTypes() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass c = model.createClass(ns + "C");
        Individual anon = model.createIndividual((Resource)c);
        Individual x = model.createIndividual(ns + "x", (Resource)c);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)x, null), (Object[])new Resource[]{OWL.Thing, c}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)anon, null), (Object[])new Resource[]{OWL.Thing, c}, (int)0);
    }

    public void testAnonClasses() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        OntClass class2 = ontmodel.createClass(nc + "C2");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        inds[0].addRDFType((Resource)class1);
        inds[1].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class1);
        inds[3].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class2);
        inds[3].addRDFType((Resource)class2);
        inds[4].addRDFType((Resource)class2);
        inds[5].addRDFType((Resource)class2);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)class1.listInstances(), (Object[])new Resource[]{inds[0], inds[1], inds[2], inds[3]}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)class2.listInstances(), (Object[])new Resource[]{inds[2], inds[3], inds[4], inds[5]}, (int)0);
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass class3 = ontmodel.createIntersectionClass(null, list);
        UnionClass class4 = ontmodel.createUnionClass(null, list);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)class3.listInstances(), (Object[])new Resource[]{inds[2], inds[3]}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)class4.listInstances(), (Object[])new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]}, (int)0);
    }

    public void testDelete() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel();
        OntClass A = model.createClass(ns + "A");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)A);
        Individual x = model.createIndividual(ns + "x", OWL.Thing);
        Individual y = model.createIndividual(ns + "y", OWL.Thing);
        x.addProperty((Property)P, (RDFNode)y);
        MiscTests.assertTrue((boolean)x.hasRDFType((Resource)A));
        x.removeRDFType((Resource)A);
        MiscTests.assertTrue((boolean)x.hasRDFType((Resource)A));
    }

    public void testDeclaredProperties() {
        String ns = "urn:test:";
        com.hp.hpl.jena.reasoner.Reasoner r = PelletReasonerFactory.theInstance().create();
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass A = model.createClass(ns + "A");
        OntClass B = model.createClass(ns + "B");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)model.createUnionClass(null, model.createList(new RDFNode[]{A, B})));
        OntClass oc = model.getOntClass(ns + "B");
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)oc.listDeclaredProperties(), (Object[])new Resource[]{P}, (int)0);
    }

    public void testSameAs1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        ObjectProperty q = model.createObjectProperty(ns + "q");
        a.addProperty((Property)p, (RDFNode)c);
        b.addProperty((Property)p, (RDFNode)b);
        c.addProperty((Property)q, (RDFNode)a);
        c.addSameAs((Resource)b);
        a.addProperty((Property)q, (RDFNode)c);
        model.prepare();
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)a.listPropertyValues((Property)p), (Object[])new Resource[]{b, c}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)a.listPropertyValues((Property)q), (Object[])new Resource[]{b, c}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)b.listPropertyValues((Property)p), (Object[])new Resource[]{b, c}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)b.listPropertyValues((Property)q), (Object[])new Resource[]{a}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)c.listPropertyValues((Property)p), (Object[])new Resource[]{b, c}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)c.listPropertyValues((Property)q), (Object[])new Resource[]{a}, (int)0);
    }

    public void testSameAs2() {
        RDFNode o;
        Property p;
        Resource s;
        Statement stmt;
        Resource resource;
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        ontModelSpec.setReasoner((com.hp.hpl.jena.reasoner.Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        Individual i1 = model.createIndividual("http://test#i1", OWL.Thing);
        Individual i2 = model.createIndividual("http://test#i2", OWL.Thing);
        Property prop = model.createProperty("http://test#prop");
        i1.addProperty(prop, "test");
        i1.addSameAs((Resource)i2);
        boolean flag = false;
        ExtendedIterator iter = i1.listSameAs();
        while (iter.hasNext()) {
            resource = (Resource)iter.next();
            if (!resource.getURI().equals("http://test#i2")) continue;
            flag = true;
        }
        MiscTests.assertTrue((String)"<i1> <owl:sameAs> <i2> not created", (boolean)flag);
        flag = false;
        iter = i2.listSameAs();
        while (iter.hasNext()) {
            resource = (Resource)iter.next();
            if (!resource.getURI().equals("http://test#i1")) continue;
            flag = true;
        }
        MiscTests.assertTrue((String)"<i2> <owl:sameAs> <i1> not created via symmetric property", (boolean)flag);
        flag = false;
        iter = i1.listProperties(prop);
        while (iter.hasNext()) {
            stmt = iter.nextStatement();
            s = stmt.getSubject();
            p = stmt.getPredicate();
            o = stmt.getObject();
            if (!p.getURI().equals("http://test#prop")) continue;
            MiscTests.assertEquals((String)"test", (String)((Literal)o.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? MiscTests.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal)).getString());
            flag = true;
        }
        MiscTests.assertTrue((String)"<http://test#i1> <http://test#prop> 'test' was not created when querying with predicate.", (boolean)flag);
        flag = false;
        iter = i2.listProperties(prop);
        while (iter.hasNext()) {
            stmt = iter.nextStatement();
            s = stmt.getSubject();
            p = stmt.getPredicate();
            o = stmt.getObject();
            if (!p.getURI().equals("http://test#prop")) continue;
            MiscTests.assertEquals((String)"test", (String)((Literal)o.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? MiscTests.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal)).getString());
            flag = true;
        }
        MiscTests.assertTrue((String)"<http://test#i2> <http://test#prop> 'test' was not inferred when querying with predicate.", (boolean)flag);
        flag = false;
        iter = i1.listProperties();
        while (iter.hasNext()) {
            stmt = iter.nextStatement();
            s = stmt.getSubject();
            p = stmt.getPredicate();
            o = stmt.getObject();
            if (!p.getURI().equals("http://test#prop")) continue;
            MiscTests.assertEquals((String)"test", (String)((Literal)o.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? MiscTests.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal)).getString());
            flag = true;
        }
        MiscTests.assertTrue((String)"<http://test#i1> <http://test#prop> 'test' was not created.", (boolean)flag);
        flag = false;
        iter = i2.listProperties();
        while (iter.hasNext()) {
            stmt = iter.nextStatement();
            s = stmt.getSubject();
            p = stmt.getPredicate();
            o = stmt.getObject();
            if (!p.getURI().equals("http://test#prop")) continue;
            MiscTests.assertEquals((String)"test", (String)((Literal)o.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? MiscTests.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal)).getString());
            flag = true;
        }
        MiscTests.assertTrue((String)"<http://test#i2> <http://test#prop> 'test' is not inferred.", (boolean)i2.hasProperty(prop, "test"));
        MiscTests.assertTrue((String)"<http://test#i2> <http://test#prop> 'test' was not inferred.", (boolean)flag);
    }

    public void testFuncProp() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        Individual d = model.createIndividual(ns + "d", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        a.addProperty((Property)p, (RDFNode)b);
        ObjectProperty q = model.createObjectProperty(ns + "q", true);
        a.addProperty((Property)q, (RDFNode)b);
        a.addProperty((Property)q, (RDFNode)d);
        c.addSameAs((Resource)b);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)a.listPropertyValues((Property)p), (Object[])new Resource[]{b, c, d}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)b.listSameAs(), (Object[])new Resource[]{b, c, d}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)c.listSameAs(), (Object[])new Resource[]{b, c, d}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)d.listSameAs(), (Object[])new Resource[]{b, c, d}, (int)0);
    }

    public void testHasValueReasoning() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((com.hp.hpl.jena.reasoner.Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass HomeOwner = model.createClass(ns + "HomeOwner");
        Individual bob = model.createIndividual(ns + "bob", (Resource)HomeOwner);
        ObjectProperty hasNeighbor = model.createObjectProperty(ns + "hasNeighbor");
        OntClass NeighborOfBob = model.createClass(ns + "NeighborOfBob");
        NeighborOfBob.addEquivalentClass((Resource)model.createHasValueRestriction(null, (Property)hasNeighbor, (RDFNode)bob));
        Individual susan = model.createIndividual(ns + "susan", (Resource)HomeOwner);
        susan.setPropertyValue((Property)hasNeighbor, (RDFNode)bob);
        MiscTests.assertTrue((String)"susan is not a NeighborOfBob", (boolean)susan.hasRDFType((Resource)NeighborOfBob));
    }

    public void testFamily() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "family.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Mom = model.getIndividual(ns + "Mom");
        Individual Dad = model.getIndividual(ns + "Dad");
        ObjectProperty hasParent = model.getObjectProperty(ns + "hasParent");
        ObjectProperty hasFather = model.getObjectProperty(ns + "hasFather");
        ObjectProperty hasMother = model.getObjectProperty(ns + "hasMother");
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasParent), (Object[])new Resource[]{Mom, Dad}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), (Object[])new Resource[]{Dad}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasMother), (Object[])new Resource[]{Mom}, (int)0);
    }

    public void testPropertyAssertions2() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        ObjectProperty hasFather = model.createObjectProperty(ns + "hasFather");
        ObjectProperty hasBioFather = model.createObjectProperty(ns + "hasBioFather", true);
        hasBioFather.addSuperProperty((Property)hasFather);
        Person.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)hasBioFather, 1));
        Individual Bob = model.createIndividual(ns + "Bob", (Resource)Person);
        Individual Dad = model.createIndividual(ns + "Dad", (Resource)Person);
        Bob.addProperty((Property)hasBioFather, (RDFNode)Dad);
        Bob.addRDFType((Resource)model.createCardinalityRestriction(null, (Property)hasFather, 1));
        model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)model);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), (Object[])new Resource[]{Dad}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Bob, (Property)hasBioFather), (Object[])new Resource[]{Dad}, (int)0);
    }

    public void testTransitive1() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "agencies.owl");
        model.prepare();
        String ns = "http://www.owl-ontologies.com/unnamed.owl#";
        Individual Forest_Service = model.getIndividual(ns + "Forest_Service");
        ObjectProperty comprises = model.getObjectProperty(ns + "comprises");
        Individual Executive = model.getIndividual(ns + "Executive");
        Individual USDA = model.getIndividual(ns + "USDA");
        MiscTests.assertTrue((String)"Forest_Service, comprises, Executive", (boolean)model.contains((Resource)Forest_Service, (Property)comprises, (RDFNode)Executive));
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)Forest_Service, (Property)comprises), (Object[])new Resource[]{USDA, Executive}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listSubjectsWithProperty((Property)comprises, (RDFNode)Executive), (Object[])new Resource[]{model.getIndividual(ns + "USDA"), model.getIndividual(ns + "DOE"), model.getIndividual(ns + "DHS"), model.getIndividual(ns + "HHS"), model.getIndividual(ns + "HUD"), model.getIndividual(ns + "DOC"), model.getIndividual(ns + "DOD"), model.getIndividual(ns + "DOI"), model.getIndividual(ns + "Research__Economics___Education"), model.getIndividual(ns + "Forest_Service"), model.getIndividual(ns + "Rural_Development"), model.getIndividual(ns + "Natural_Resources_Conservation_Service"), model.getIndividual(ns + "Economic_Research_Service"), model.getIndividual(ns + "Farm_Service_Agency"), model.getIndividual(ns + "Cooperative_State_Research__Education__and_Extension_Service"), model.getIndividual(ns + "Animal___Plant_Health_Inspection_Service"), model.getIndividual(ns + "Agricultural_Research_Service"), model.getIndividual(ns + "National_Agricultural_Library")}, (int)0);
    }

    public void testTransitiveSubProperty() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty knows = model.createObjectProperty(ns + "knows");
        ObjectProperty hasRelative = model.createObjectProperty(ns + "hasRelative");
        hasRelative.addSuperProperty((Property)knows);
        hasRelative.addRDFType(OWL.TransitiveProperty);
        ObjectProperty hasParent = model.createObjectProperty(ns + "hasParent");
        hasParent.addSuperProperty((Property)hasRelative);
        OntClass cls = model.createClass(ns + "cls");
        Individual a = cls.createIndividual(ns + "a");
        Individual b = cls.createIndividual(ns + "b");
        Individual c = cls.createIndividual(ns + "c");
        Individual d = cls.createIndividual(ns + "d");
        Individual e = cls.createIndividual(ns + "e");
        Individual f = cls.createIndividual(ns + "f");
        Individual g = cls.createIndividual(ns + "g");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(PelletReasonerFactory.theInstance().create());
        model = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model);
        model.add((Resource)a, (Property)hasParent, (RDFNode)b);
        model.add((Resource)b, (Property)hasParent, (RDFNode)c);
        model.add((Resource)a, (Property)knows, (RDFNode)d);
        model.add((Resource)d, (Property)knows, (RDFNode)e);
        model.add((Resource)b, (Property)knows, (RDFNode)e);
        model.add((Resource)c, (Property)hasRelative, (RDFNode)f);
        model.add((Resource)d, (Property)hasRelative, (RDFNode)g);
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)b));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)b));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)c));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)f));
        MiscTests.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)f));
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)e) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)e) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)g) ? 1 : 0) != 0);
        MiscTests.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)g) ? 1 : 0) != 0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)a, (Property)hasRelative), (Object[])new Resource[]{b, c, f}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)a, (Property)knows), (Object[])new Resource[]{b, c, d, f}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)b, (Property)knows), (Object[])new Resource[]{c, e, f}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listSubjectsWithProperty((Property)knows, (RDFNode)e), (Object[])new Resource[]{b, d}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listSubjectsWithProperty((Property)hasRelative, (RDFNode)f), (Object[])new Resource[]{a, b, c}, (int)0);
    }

    public void testNominals() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "nominals.owl");
        OntClass Color2 = model.getOntClass(ns + "Color");
        Individual red = model.getIndividual(ns + "red");
        OntClass PrimaryColors = model.getOntClass(ns + "PrimaryColors");
        OntClass MyFavoriteColors = model.getOntClass(ns + "MyFavoriteColors");
        OntClass HasFourPrimaryColors = model.getOntClass(ns + "HasFourPrimaryColors");
        model.prepare();
        MiscTests.assertTrue((boolean)model.contains((Resource)red, RDF.type, (RDFNode)MyFavoriteColors));
        MiscTests.assertTrue((boolean)model.contains((Resource)HasFourPrimaryColors, RDFS.subClassOf, (RDFNode)OWL.Nothing));
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)Color2.listSubClasses(), (Object[])new Resource[]{PrimaryColors, MyFavoriteColors, HasFourPrimaryColors, OWL.Nothing}, (int)0);
    }

    public void testDatatypeProperties1a() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty email = model.createDatatypeProperty(ns + "email", false);
        john.addProperty((Property)email, "john.doe@unknown.org");
        john.addProperty((Property)email, "jdoe@unknown.org");
        MiscTests.assertTrue((boolean)model.validate().isValid());
    }

    public void testDatatypeProperties1b() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty name = model.createDatatypeProperty(ns + "name", true);
        john.addProperty((Property)name, "Name", "en");
        john.addProperty((Property)name, "Nom", "fr");
        MiscTests.assertTrue((boolean)model.validate().isValid());
    }

    public void testDatatypeProperties1c() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty name = model.createDatatypeProperty(ns + "name", true);
        john.addProperty((Property)name, "Name");
        john.addProperty((Property)name, "Nom");
        MiscTests.assertTrue((!model.validate().isValid() ? 1 : 0) != 0);
    }

    public void testUniqueNameAssumption() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Country = model.createClass(ns + "Country");
        Individual USA = model.createIndividual(ns + "USA", (Resource)Country);
        Individual UnitedStates = model.createIndividual(ns + "UnitedStates", (Resource)Country);
        ObjectProperty livesIn = model.createObjectProperty(ns + "livesIn");
        livesIn.convertToFunctionalProperty();
        OntClass Person = model.createClass(ns + "Person");
        Individual JohnDoe = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)USA);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)UnitedStates);
        MiscTests.assertTrue((boolean)model.contains((Resource)JohnDoe, RDF.type, (RDFNode)Person));
        MiscTests.assertTrue((boolean)model.contains((Resource)USA, OWL.sameAs, (RDFNode)UnitedStates));
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)model.listObjectsOfProperty((Resource)JohnDoe, (Property)livesIn), (Object[])new Resource[]{USA, UnitedStates}, (int)0);
    }

    public void testESG() {
        String ns = "http://www.csm.ornl.gov/~7lp/onto-library/esg1.1#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.getDocumentManager().setProcessImports(false);
        model.read(base + "ESG1.1.owl");
        model.prepare();
        MiscTests.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Individual jdl62 = model.getIndividual(ns + "JDL_00062");
        Individual jdl63 = model.getIndividual(ns + "JDL_00063");
        MiscTests.assertTrue((boolean)jdl62.isSameAs((Resource)jdl63));
        MiscTests.assertTrue((boolean)jdl63.isSameAs((Resource)jdl62));
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)jdl62.listSameAs(), (Object[])new Resource[]{jdl62, jdl63}, (int)0);
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)jdl63.listSameAs(), (Object[])new Resource[]{jdl62, jdl63}, (int)0);
    }

    public void testSHOIN() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)MiscTests.term("R1"));
        kb.addObjectProperty((ATerm)MiscTests.term("invR1"));
        kb.addObjectProperty((ATerm)MiscTests.term("R2"));
        kb.addObjectProperty((ATerm)MiscTests.term("invR2"));
        kb.addObjectProperty((ATerm)MiscTests.term("S1"));
        kb.addObjectProperty((ATerm)MiscTests.term("invS1"));
        kb.addObjectProperty((ATerm)MiscTests.term("S2"));
        kb.addObjectProperty((ATerm)MiscTests.term("invS2"));
        kb.addInverseProperty(MiscTests.term("R1"), MiscTests.term("invR1"));
        kb.addInverseProperty(MiscTests.term("R2"), MiscTests.term("invR2"));
        kb.addInverseProperty(MiscTests.term("S1"), MiscTests.term("invS1"));
        kb.addInverseProperty(MiscTests.term("S2"), MiscTests.term("invS2"));
        kb.addIndividual(MiscTests.term("o1"));
        kb.addIndividual(MiscTests.term("o2"));
        kb.addSubClass(MiscTests.value(MiscTests.term("o1")), MiscTests.and(MiscTests.max(MiscTests.term("invR1"), 2), MiscTests.all(MiscTests.term("invR1"), MiscTests.some(MiscTests.term("S1"), MiscTests.some(MiscTests.term("invS2"), MiscTests.some(MiscTests.term("R2"), MiscTests.value(MiscTests.term("o2"))))))));
        kb.addSubClass(MiscTests.value(MiscTests.term("o2")), MiscTests.and(MiscTests.max(MiscTests.term("invR2"), 2), MiscTests.all(MiscTests.term("invR2"), MiscTests.some(MiscTests.term("S2"), MiscTests.some(MiscTests.term("invS1"), MiscTests.some(MiscTests.term("R1"), MiscTests.value(MiscTests.term("o1"))))))));
        MiscTests.assertTrue((boolean)kb.isConsistent());
        MiscTests.assertTrue((boolean)kb.isSatisfiable(MiscTests.and(MiscTests.value(MiscTests.term("o1")), MiscTests.some(MiscTests.term("invR1"), TOP))));
    }

    public void testEconn1() throws Exception {
        String ns = "http://www.mindswap.org/2004/multipleOnt/FactoredOntologies/EasyTests/Easy2/people.owl#";
        Reasoner reasoner = new Reasoner();
        OWLRDFParser parser = new OWLRDFParser();
        parser.setConnection((OWLConnection)new OWLConnectionImpl());
        OWLOntology ont = parser.parseOntology(URI.create(ns));
        reasoner.setOntology(ont);
        MiscTests.assertTrue((boolean)reasoner.isConsistent());
        System.out.println("Consistent: " + reasoner.isConsistent());
        MiscTests.assertTrue((!reasoner.isConsistent((OWLDescription)reasoner.getClass(URI.create(ns + "Unsat1"))) ? 1 : 0) != 0);
        MiscTests.assertTrue((!reasoner.isConsistent((OWLDescription)reasoner.getClass(URI.create(ns + "Unsat2"))) ? 1 : 0) != 0);
        MiscTests.assertTrue((!reasoner.isConsistent((OWLDescription)reasoner.getClass(URI.create(ns + "Unsat3"))) ? 1 : 0) != 0);
        MiscTests.assertTrue((!reasoner.isConsistent((OWLDescription)reasoner.getClass(URI.create(ns + "Unsat4"))) ? 1 : 0) != 0);
    }

    public void testUserDefinedDatatypes() {
        String ns = "http://www.mindswap.org/ontologies/family#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("http://www.mindswap.org/ontologies/family-ages.owl");
        model.prepare();
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Teenage = model.getOntClass(ns + "Teenage");
        OntClass Adult = model.getOntClass(ns + "Adult");
        OntClass Senior = model.getOntClass(ns + "Senior");
        Individual Daughter = model.getIndividual(ns + "Daughter");
        Individual Son = model.getIndividual(ns + "Son");
        Individual Dad = model.getIndividual(ns + "Dad");
        Individual Mom = model.getIndividual(ns + "Mom");
        Individual Grandpa = model.getIndividual(ns + "Grandpa");
        MiscTests.assertTrue((boolean)Adult.hasSubClass((Resource)Senior));
        TestUtil.assertIteratorValues((TestCase)this, (Iterator)Adult.listSubClasses(true), (Object[])new Resource[]{Senior});
        MiscTests.printAll((Iterator)Daughter.listRDFTypes(false));
        MiscTests.assertTrue((boolean)Daughter.hasRDFType((Resource)Child));
        MiscTests.assertTrue((boolean)Son.hasRDFType((Resource)Teenage));
        MiscTests.assertTrue((boolean)Dad.hasRDFType((Resource)Adult));
        MiscTests.assertTrue((boolean)Dad.hasRDFType((Resource)Adult));
    }
}

