/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.mindswap.pellet.jena.OWLTest;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AlphaNumericComparator;

public class OWLTestSuite
extends TestSuite {
    public static String base = PelletTestSuite.base + "owl-test";
    private OWLTest test = new OWLTest();

    public OWLTestSuite() {
        super("OWLTests");
        this.test.setAvoidFailTests(true);
        this.test.setBase(base);
        this.test.setShowStats(0);
        File testDir = new File(base);
        File[] dirs = testDir.listFiles();
        Arrays.sort(dirs, ATermUtils.stringComparator);
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isFile()) continue;
            File[] files = dirs[i].listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().indexOf("Manifest") != -1;
                }
            });
            Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
            for (int j = 0; j < files.length; ++j) {
                this.addTest((Test)new OWLTestCase(files[j], dirs[i].getName() + "-" + files[j].getName()));
            }
        }
    }

    public static TestSuite suite() {
        return new OWLTestSuite();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)OWLTestSuite.suite());
    }

    class OWLTestCase
    extends TestCase {
        File manifest;

        OWLTestCase(File manifest, String name) {
            super("OWLTestCase-" + name);
            this.manifest = manifest;
        }

        public void runTest() throws IOException {
            OWLTestCase.assertTrue((OWLTestSuite.this.test.doSingleTest(this.manifest.toURL().toString()) != 1 ? 1 : 0) != 0);
        }
    }
}

