/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class PelletTestCase
extends TestCase {
    static ATermAppl TOP = ATermUtils.TOP;
    static ATermAppl BOTTOM = ATermUtils.BOTTOM;

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }

    public static ATermAppl not(ATermAppl c) {
        return ATermUtils.makeNot((ATerm)c);
    }

    public static ATermAppl all(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeAllValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl some(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeSomeValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl min(ATermAppl r, int n) {
        return ATermUtils.makeMin((ATerm)r, n);
    }

    public static ATermAppl max(ATermAppl r, int n) {
        return ATermUtils.makeMax((ATerm)r, n);
    }

    public static ATermAppl inv(ATermAppl r) {
        return ATermUtils.makeInv(r);
    }

    public static ATermAppl literal(String value) {
        return ATermUtils.makePlainLiteral(value);
    }

    public static ATermAppl plainLiteral(String value, String lang) {
        return ATermUtils.makePlainLiteral(value, lang);
    }

    public static ATermAppl typedLiteral(String value, String dt) {
        return ATermUtils.makeTypedLiteral(value, dt);
    }

    public static ATermAppl value(ATermAppl r) {
        return ATermUtils.makeValue((ATerm)r);
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeAnd((ATerm)c1, (ATerm)c2);
    }

    public static ATermAppl and(ATermAppl[] c) {
        return ATermUtils.makeAnd(ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl or(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(c1, c2);
    }

    public static ATermAppl or(ATermAppl[] c) {
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm[])c));
    }

    public static void testQueryResults(QueryResults results, List ans) {
        ArrayList answers = new ArrayList(ans);
        while (results.hasNext()) {
            ResultBinding rb = (ResultBinding)results.next();
            PelletTestCase.assertNotNull((String)"ResultBinding", (Object)rb);
            HashMap<String, Object> answer = new HashMap<String, Object>();
            Iterator iter = results.getResultVars().iterator();
            while (iter.hasNext()) {
                String var = (String)iter.next();
                Object val = rb.get(var);
                PelletTestCase.assertNotNull((String)("Variable: " + var), (Object)val);
                answer.put(var, val);
            }
            PelletTestCase.assertTrue((String)("Unexpected binding found: " + answer), (boolean)answers.remove(answer));
        }
        results.close();
        PelletTestCase.assertTrue((String)("Binding not found: " + answers), (boolean)answers.isEmpty());
    }

    public static Map createBinding(Object[] keys, Object[] values) {
        PelletTestCase.assertTrue((keys.length == values.length ? 1 : 0) != 0);
        HashMap<Object, Object> answer = new HashMap<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            answer.put(keys[i], values[i]);
        }
        return answer;
    }

    public static List createBindings(Object[] keys, Object[][] values) {
        ArrayList answers = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            HashMap<Object, Object> answer = new HashMap<Object, Object>();
            for (int j = 0; j < keys.length; ++j) {
                answer.put(keys[j], values[i][j]);
            }
            answers.add(answer);
        }
        return answers;
    }

    public static void printAll(Iterator i) {
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public static void printAll(Iterator i, String head) {
        System.out.print(head + ": ");
        if (i.hasNext()) {
            System.out.println();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
    }

    public static boolean[] testSubClass(KnowledgeBase kb, String c1, String c2) {
        return PelletTestCase.testSubClass(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public static boolean[] testSubClass(KnowledgeBase kb, ATermAppl c1, ATermAppl c2) {
        boolean[] result = new boolean[2];
        result[0] = kb.isSubClassOf(c1, c2);
        kb.isSatisfiable(c1);
        kb.isSatisfiable(PelletTestCase.not(c1));
        kb.isSatisfiable(c2);
        kb.isSatisfiable(PelletTestCase.not(c2));
        long satCount = kb.getABox().satisfiabilityCount;
        result[1] = kb.isSubClassOf(c1, c2);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        System.out.println("Subsumption : " + result[0]);
        System.out.println("Cached " + (cached ? "(yes)" : "(no) ") + ": " + result[1]);
        return result;
    }

    public static boolean[] testType(KnowledgeBase kb, String c1, String c2) {
        return PelletTestCase.testType(kb, PelletTestCase.term(c1), PelletTestCase.term(c2));
    }

    public static boolean[] testType(KnowledgeBase kb, ATermAppl ind, ATermAppl c) {
        boolean[] result = new boolean[2];
        result[0] = kb.isType(ind, c);
        kb.isSatisfiable(c);
        kb.isSatisfiable(PelletTestCase.not(c));
        long satCount = kb.getABox().satisfiabilityCount;
        result[1] = kb.isType(ind, c);
        boolean cached = satCount == kb.getABox().satisfiabilityCount;
        System.out.println("Type      : " + result[0]);
        System.out.println("Cached " + (cached ? "(yes)" : "(no) ") + ": " + result[1]);
        return result;
    }
}

