/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;

public class FileUtils {
    public static String readURL(URL fileURL) throws IOException {
        return FileUtils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(file));
    }

    public static String readFile(String fileName) throws FileNotFoundException, IOException {
        return FileUtils.readAll(new FileReader(fileName));
    }

    public static String readAll(Reader reader) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((ch = in.read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static String toURI(String fileName) {
        if (fileName.startsWith("http://") || fileName.startsWith("file:/")) {
            return fileName;
        }
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            throw new RuntimeException(new FileNotFoundException(localFile.getAbsolutePath() + " is not found"));
        }
        try {
            return localFile.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(fileName + " is not a valid URI");
        }
    }
}

