/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.mindswap.pellet.utils.HashCodeUtil;

public class GenericIntervalList
implements Serializable {
    private final List intervals;
    private ExtendedComparator comparator;

    public GenericIntervalList(Object start, Object end, ExtendedComparator comp) {
        this.comparator = comp;
        this.intervals = new LinkedList();
        this.intervals.add(new Interval(start, end));
    }

    public GenericIntervalList(ExtendedComparator comp) {
        this.comparator = comp;
        this.intervals = new LinkedList();
    }

    public GenericIntervalList(GenericIntervalList il, ExtendedComparator comp) {
        this.comparator = comp;
        this.intervals = new LinkedList(il.intervals);
    }

    public boolean isEmpty() {
        return this.intervals.size() == 0;
    }

    public Object min() {
        if (this.intervals.size() == 0) {
            return null;
        }
        return ((Interval)this.intervals.get(0)).start();
    }

    public Object max() {
        if (this.intervals.size() == 0) {
            return null;
        }
        return ((Interval)this.intervals.get(this.intervals.size() - 1)).end();
    }

    public int count() {
        double count = 0.0;
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            count += (double)i.count();
        }
        if (count > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    private void canonicalize() {
        Collections.sort(this.intervals);
        ListIterator<Interval> iter = this.intervals.listIterator();
        if (!iter.hasNext()) {
            return;
        }
        Interval currentElement = (Interval)iter.next();
        while (iter.hasNext()) {
            Interval lastElement = currentElement;
            if (!lastElement.overlaps(currentElement = (Interval)iter.next())) continue;
            Interval newElement = lastElement.merge(currentElement);
            iter.remove();
            iter.previous();
            iter.remove();
            iter.add(newElement);
            currentElement = newElement;
        }
    }

    public void addInterval(Object start, Object end) {
        this.addIntervalInternal(start, end);
        this.canonicalize();
    }

    private void addIntervalInternal(Object start, Object end) {
        this.intervals.add(new Interval(start, end));
    }

    public void removeInterval(Object start, Object end) {
        this.removeIntervalInternal(start, end);
        this.canonicalize();
    }

    private void removeIntervalInternal(Object start, Object end) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        Interval toRemove = new Interval(start, end);
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.overlaps(toRemove)) continue;
            if (this.comparator.compare(start, curr.start()) > 0) {
                if (this.comparator.compare(end, curr.end()) < 0) {
                    iter.remove();
                    iter.add(new Interval(curr.start(), this.comparator.prev(start)));
                    iter.add(new Interval(this.comparator.next(end), curr.end()));
                    continue;
                }
                iter.remove();
                iter.add(new Interval(curr.start(), this.comparator.prev(start)));
                continue;
            }
            if (this.comparator.compare(end, curr.end()) < 0) {
                iter.remove();
                iter.add(new Interval(this.comparator.next(end), curr.end()));
                continue;
            }
            iter.remove();
        }
    }

    public void addIntervalList(GenericIntervalList il) {
        Iterator iter = il.intervals.iterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            this.addIntervalInternal(i.start(), i.end());
        }
        this.canonicalize();
    }

    public void removeIntervalList(GenericIntervalList il) {
        Iterator iter = il.intervals.iterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            this.removeIntervalInternal(i.start(), i.end());
        }
        this.canonicalize();
    }

    public void restrictToInterval(Object start, Object end) {
        this.restrictToInterval(new Interval(start, end));
    }

    public void restrictToInterval(Interval i) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (curr.overlaps(i)) {
                iter.set(curr.restrictTo(i));
                continue;
            }
            iter.remove();
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.intervals).iterator();
    }

    public boolean equals(Object o) {
        if (o instanceof GenericIntervalList) {
            GenericIntervalList il = (GenericIntervalList)o;
            return ((Object)this.intervals).equals(il.intervals);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.intervals).hashCode();
    }

    public String toString() {
        return this.intervals.toString();
    }

    public boolean contains(Object value) {
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static interface ExtendedComparator
    extends Comparator {
        public Object prev(Object var1);

        public Object next(Object var1);

        public long count(Object var1, Object var2);
    }

    public class Interval
    implements Comparable,
    Serializable {
        public final Object start;
        public final Object end;
        private int hashCode;

        public Interval(Object start, Object end) {
            if (GenericIntervalList.this.comparator.compare(end, start) < 0) {
                throw new IllegalArgumentException(end + " is less than " + start);
            }
            this.start = start;
            this.end = end;
            this.computeHashCode();
        }

        public Object start() {
            return this.start;
        }

        public Object end() {
            return this.end;
        }

        public long count() {
            return GenericIntervalList.this.comparator.count(this.start, this.end);
        }

        private boolean overlaps(Interval i) {
            if (GenericIntervalList.this.comparator.compare(this.start, i.start) <= 0) {
                return GenericIntervalList.this.comparator.compare(i.start, this.end) <= 0;
            }
            return i.overlaps(this);
        }

        private Interval merge(Interval i) {
            if (this.overlaps(i)) {
                if (GenericIntervalList.this.comparator.compare(this.start, i.start) <= 0) {
                    return new Interval(this.start, GenericIntervalList.this.comparator.compare(i.end, this.end) > 0 ? i.end : this.end);
                }
                return i.merge(this);
            }
            throw new IllegalArgumentException();
        }

        private Interval restrictTo(Interval i) {
            if (!this.overlaps(i)) {
                throw new IllegalArgumentException();
            }
            return new Interval(GenericIntervalList.this.comparator.compare(this.start, i.start) > 0 ? this.start : i.start, GenericIntervalList.this.comparator.compare(this.end, i.end) < 0 ? this.end : i.end);
        }

        public int compareTo(Object o) {
            Interval i = (Interval)o;
            if (GenericIntervalList.this.comparator.compare(this.start, i.start) < 0) {
                return -1;
            }
            if (GenericIntervalList.this.comparator.compare(this.start, i.start) > 0) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval i = (Interval)o;
                if (i == this) {
                    return true;
                }
                return this.start.equals(i.start) && this.end.equals(i.end);
            }
            return false;
        }

        private void computeHashCode() {
            this.hashCode = 23;
            this.hashCode = HashCodeUtil.hash(this.hashCode, this.start);
            this.hashCode = HashCodeUtil.hash(this.hashCode, this.end);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "[" + this.start + " - " + this.end + "]";
        }

        public boolean contains(Object value) {
            return GenericIntervalList.this.comparator.compare(this.start, value) <= 0 && GenericIntervalList.this.comparator.compare(value, this.end) <= 0;
        }
    }
}

