/*
 * Decompiled with CFR 0.152.
 */
package mx.arq.cmdline;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mx.arq.cmdline.Arg;
import mx.arq.cmdline.ArgDecl;
import mx.arq.cmdline.ArgHandler;
import mx.arq.cmdline.CmdLineUtils;

public class CommandLine {
    protected ArgHandler argHook = null;
    protected String usage = null;
    protected Map argMap = new HashMap();
    protected Map args = new HashMap();
    String indirectionMarker = "@";
    protected boolean allowItemIndirect = false;
    boolean ignoreIndirectionMarker = false;
    protected List items = new ArrayList();

    public void setHook(ArgHandler argHandler) {
        this.argHook = argHandler;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public Iterator args() {
        return this.args.values().iterator();
    }

    public int numArgs() {
        return this.args.size();
    }

    public int numItems() {
        return this.items.size();
    }

    public void pushItem(String string) {
        this.items.add(string);
    }

    public boolean isIndirectItem(int n) {
        return this.allowItemIndirect && ((String)this.items.get(n)).startsWith(this.indirectionMarker);
    }

    public String getItem(int n) {
        return this.getItem(n, this.allowItemIndirect);
    }

    public String getItem(int n, boolean bl) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        String string = (String)this.items.get(n);
        if (bl && string.startsWith(this.indirectionMarker)) {
            string = string.substring(1);
            try {
                string = CmdLineUtils.readWholeFileAsUTF8(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to read '" + string + "': " + exception.getMessage());
            }
        }
        return string;
    }

    public void process(String[] stringArray) throws IllegalArgumentException {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        for (n = 0; n < arrayList.size() && !this.endProcessing(string = (String)arrayList.get(n)); ++n) {
            String string2;
            int n2 = string.indexOf(61);
            int n3 = string.indexOf(58);
            int n4 = Integer.MAX_VALUE;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            if (n3 > 0 && n3 < n4) {
                n4 = n3;
            }
            if (n4 != Integer.MAX_VALUE) {
                string2 = string.substring(n4 + 1);
                arrayList.add(n + 1, string2);
                string = string.substring(0, n4);
            }
            string = ArgDecl.canonicalForm(string);
            string2 = null;
            if (this.argMap.containsKey(string)) {
                if (!this.args.containsKey(string)) {
                    this.args.put(string, new Arg(string));
                }
                Arg arg = (Arg)this.args.get(string);
                ArgDecl argDecl = (ArgDecl)this.argMap.get(string);
                if (argDecl.takesValue()) {
                    if (n == arrayList.size() - 1) {
                        throw new IllegalArgumentException("No value for argument: " + arg.getName());
                    }
                    string2 = (String)arrayList.get(++n);
                    arg.setValue(string2);
                    arg.addValue(string2);
                }
                if (this.argHook != null) {
                    this.argHook.action(string, string2);
                }
                argDecl.trigger(arg);
                continue;
            }
            this.handleUnrecognizedArg((String)arrayList.get(n));
        }
        if (n < arrayList.size()) {
            if (arrayList.get(n).equals("-") || arrayList.get(n).equals("--")) {
                ++n;
            }
            while (n < arrayList.size()) {
                string = (String)arrayList.get(n);
                this.items.add(string);
                ++n;
            }
        }
    }

    public boolean endProcessing(String string) {
        return !string.startsWith("-") || string.equals("--") || string.equals("-");
    }

    public void handleUnrecognizedArg(String string) {
        throw new IllegalArgumentException("Unknown argument: " + string);
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArg(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iterator = this.args.values().iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!argDecl.matches(arg2)) continue;
            arg = arg2;
        }
        return arg;
    }

    public Arg getArg(String string) {
        string = ArgDecl.canonicalForm(string);
        return (Arg)this.args.get(string);
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String string) {
        Arg arg = this.getArg(string);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    public List getValues(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public List getValues(String string) {
        Arg arg = this.getArg(string);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public CommandLine add(String string, boolean bl) {
        return this.add(new ArgDecl(bl, string));
    }

    public CommandLine add(boolean bl, String string) {
        return this.add(new ArgDecl(bl, string));
    }

    public CommandLine add(ArgDecl argDecl) {
        Iterator iterator = argDecl.names();
        while (iterator.hasNext()) {
            this.argMap.put(iterator.next(), argDecl);
        }
        return this;
    }

    public boolean allowItemIndirect() {
        return this.allowItemIndirect;
    }

    public void setAllowItemIndirect(boolean bl) {
        this.allowItemIndirect = bl;
    }

    public boolean isIgnoreIndirectionMarker() {
        return this.ignoreIndirectionMarker;
    }

    public String getIndirectionMarker() {
        return this.indirectionMarker;
    }

    public void setIndirectionMarker(String string) {
        this.indirectionMarker = string;
    }

    public void setIgnoreIndirectionMarker(boolean bl) {
        this.ignoreIndirectionMarker = bl;
    }

    public ArgHandler trace() {
        final PrintStream printStream = System.err;
        return new ArgHandler(){

            public void action(String string, String string2) {
                if (printStream != null) {
                    printStream.println("Seen: " + string + (string2 != null ? " = " + string2 : ""));
                }
            }
        };
    }
}

