/*
 * Decompiled with CFR 0.152.
 */
package mx.arq.cmdline.test;

import java.util.Iterator;
import junit.framework.TestCase;
import mx.arq.cmdline.Arg;
import mx.arq.cmdline.ArgDecl;
import mx.arq.cmdline.CommandLine;
import mx.arq.cmdline.CommandLineIgnoreUnknown;

public class TestCmdLine
extends TestCase {
    public void test_Simple1() {
        String[] stringArray = new String[]{""};
        CommandLine commandLine = new CommandLine();
        commandLine.process(stringArray);
    }

    public void test_Flag1() {
        String[] stringArray = new String[]{""};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLine.add(argDecl);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"-a argument found", (!commandLine.contains(argDecl) ? 1 : 0) != 0);
    }

    public void test_Flag2() {
        String[] stringArray = new String[]{"-a"};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLine.add(argDecl);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)commandLine.contains(argDecl));
    }

    public void test_Flag3() {
        String[] stringArray = new String[]{"-a", "filename"};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLine.add(argDecl);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)commandLine.contains(argDecl));
    }

    public void test_Arg1() {
        String[] stringArray = new String[]{""};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        commandLine.add(argDecl);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"-arg argument found", (!commandLine.contains(argDecl) ? 1 : 0) != 0);
    }

    public void test_Arg2() {
        String[] stringArray = new String[]{"-arg=ARG", "filename"};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        commandLine.add(argDecl);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)commandLine.contains(argDecl));
        TestCmdLine.assertEquals((String)"", (String)commandLine.getValue(argDecl), (String)"ARG");
        TestCmdLine.assertEquals((String)"", (String)commandLine.getArg("arg").getValue(), (String)"ARG");
    }

    public void test_nArg1() {
        String[] stringArray = new String[]{"-arg=V1", "--arg=V2", "-v"};
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(true, "-arg");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "-v");
        commandLine.add(argDecl2);
        commandLine.process(stringArray);
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)commandLine.contains(argDecl));
        Iterator iterator = commandLine.getValues("arg").iterator();
        TestCmdLine.assertEquals((String)"Argument 1", iterator.next(), (Object)"V1");
        TestCmdLine.assertEquals((String)"Argument 2", iterator.next(), (Object)"V2");
    }

    public static void main(String[] stringArray) {
        CommandLineIgnoreUnknown commandLineIgnoreUnknown = new CommandLineIgnoreUnknown();
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLineIgnoreUnknown.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(true, "--file");
        commandLineIgnoreUnknown.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "-v", "--verbose");
        commandLineIgnoreUnknown.add(argDecl3);
        String[] stringArray2 = new String[]{"-a", "--b", "--a", "--file", "value1", "--file", "value2", "--file:value3", "--v", "rest"};
        try {
            String string;
            Object object;
            commandLineIgnoreUnknown.process(stringArray2);
            System.out.println("PROCESSED");
            if (commandLineIgnoreUnknown.getArg("file") == null) {
                System.out.println("No --file seen");
            } else {
                System.out.println("--file => " + commandLineIgnoreUnknown.getArg(argDecl2).getValue());
                int n = 0;
                object = commandLineIgnoreUnknown.getValues(argDecl2).iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    System.out.println("--file =>  " + ++n + "=" + string);
                }
            }
            if (!commandLineIgnoreUnknown.hasArg(argDecl)) {
                System.out.println("No --a seen");
            } else {
                System.out.println("--a seen " + commandLineIgnoreUnknown.getArg(argDecl).getValue());
            }
            System.out.println("DUMP");
            Iterator iterator = commandLineIgnoreUnknown.args();
            while (iterator.hasNext()) {
                object = (Arg)iterator.next();
                string = ((Arg)object).hasValue() ? " = " + ((Arg)object).getValue() : "";
                System.out.println("Arg: " + ((Arg)object).getName() + string);
            }
            for (int i = 0; i < commandLineIgnoreUnknown.numItems(); ++i) {
                System.out.println("Item: " + commandLineIgnoreUnknown.getItem(i));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Illegal argument: " + illegalArgumentException.getMessage());
        }
    }
}

