/*
 * Decompiled with CFR 0.152.
 */
package mx.arq;

import java.io.File;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import mx.arq.cmd.CmdUtils;
import mx.arq.cmdline.ArgDecl;
import mx.arq.cmdline.CommandLine;
import mx.com.hp.hpl.jena.query.junit.SimpleTestRunner;
import mx.com.hp.hpl.jena.query.junit.TestScripts;
import mx.com.hp.hpl.jena.query.test.ARQTestSuite;
import mx.com.hp.hpl.jena.query.util.RelURI;

public class qtest {
    static String usage;

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "all");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "wg", "dawg");
        commandLine.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "dir");
        commandLine.add(argDecl4);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            qtest.usage(System.err);
            System.exit(2);
        }
        if (commandLine.contains(argDecl) || !commandLine.hasArgs() && !commandLine.hasItems()) {
            qtest.usage();
            System.exit(0);
        }
        if (commandLine.contains(argDecl2)) {
            qtest.allTests();
            System.exit(0);
        }
        if (commandLine.contains(argDecl3)) {
            qtest.dawgTests();
            System.exit(0);
        }
        if (!commandLine.hasItems()) {
            qtest.argError("No manifest file");
        }
        String string = commandLine.getItem(0);
        String string2 = RelURI.resolve(string);
        qtest.oneManifest(string2);
        System.exit(0);
    }

    static void oneManifest(String string) {
        TestScripts testScripts = new TestScripts("ARQ", string);
        SimpleTestRunner.runAndReport((Test)testScripts);
    }

    static void allTests() {
        qtest.ensureDirExists("testing");
        qtest.ensureDirExists("testing/ARQ");
        qtest.ensureDirExists("testing/DAWG");
        qtest.ensureDirExists("testing/DAWG-Approved");
        TestSuite testSuite = ARQTestSuite.suite();
        TestRunner.run((Test)testSuite);
        System.exit(0);
    }

    static void dawgTests() {
        System.err.println("DAWG tests not packaged up yet");
        System.exit(4);
    }

    static void usage() {
        qtest.usage(System.err);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static void ensureDirExists(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            System.err.println("Can't find required directory: '" + string + "'");
            System.exit(8);
        }
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        usage = qtest.class.getName() + " [--all]\n" + qtest.class.getName() + " [--dawg]\n" + qtest.class.getName() + " manifest\n" + " where --all      run all built-in tests\n" + "       --dawg     run working group tests\n" + "       manifest   run a set of tests";
    }
}

