/*
 * Decompiled with CFR 0.152.
 */
package mx.arq;

import java.io.OutputStream;
import java.io.PrintStream;
import mx.arq.cmd.CmdUtils;
import mx.arq.cmdline.ArgDecl;
import mx.arq.cmdline.CommandLine;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFactory;
import mx.com.hp.hpl.jena.query.ResultSetFormatter;
import mx.com.hp.hpl.jena.query.resultset.ResultSetFormat;
import mx.com.hp.hpl.jena.rdf.model.Model;

public class rset {
    static String usage;

    public static void main(String[] stringArray) {
        int n;
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        ArgDecl argDecl6 = new ArgDecl(true, "file");
        commandLine.add(argDecl);
        commandLine.add(argDecl3);
        commandLine.add(argDecl2);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        commandLine.add(argDecl6);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (commandLine.contains(argDecl2)) {
            rset.usage();
            System.exit(0);
        }
        ResultSetFormat resultSetFormat = null;
        if (commandLine.contains(argDecl4) && (resultSetFormat = ResultSetFormat.lookup(commandLine.getValue(argDecl4))).equals(ResultSetFormat.syntaxText)) {
            System.err.println("Can't read in the tabular text format");
            System.exit(2);
        }
        ResultSetFormat resultSetFormat2 = null;
        if (commandLine.contains(argDecl5)) {
            resultSetFormat2 = ResultSetFormat.lookup(commandLine.getValue(argDecl5));
        }
        String string = null;
        if (commandLine.contains(argDecl6)) {
            string = commandLine.getValue(argDecl6);
        }
        if (string == null && (n = 0) < commandLine.numItems()) {
            String string2;
            string = string2 = commandLine.getItem(n);
        }
        if (string != null && resultSetFormat == null) {
            resultSetFormat = ResultSetFormat.guessSyntax(string);
        }
        if (resultSetFormat == null) {
            resultSetFormat = ResultSetFormat.syntaxRDF;
        }
        if (resultSetFormat2 == null) {
            resultSetFormat2 = ResultSetFormat.syntaxText;
        }
        ResultSet resultSet = rset.parseResultSet(string, resultSetFormat);
        rset.printResultSet(resultSet, resultSetFormat2);
    }

    static ResultSet parseResultSet(String string, ResultSetFormat resultSetFormat) {
        ResultSet resultSet = ResultSetFactory.load(string, resultSetFormat);
        if (resultSet == null) {
            System.exit(9);
        }
        return resultSet;
    }

    private static void printResultSet(ResultSet resultSet, ResultSetFormat resultSetFormat) {
        if (resultSetFormat.equals(ResultSetFormat.syntaxXML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, resultSet);
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxRDF)) {
            Model model = ResultSetFormatter.toModel(resultSet);
            model.write((OutputStream)System.out, "N3");
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxText)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet);
            return;
        }
        rset.msg("Unknown output syntax: " + resultSetFormat);
        System.exit(9);
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static void usage() {
        rset.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        usage = rset.class.getName() + " [--in syntax] [--out syntax] [--file FILE | FILE ]\n" + "  where syntax is one of XML, RDF";
    }
}

