/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.query.DataSource;
import mx.com.hp.hpl.jena.query.Dataset;
import mx.com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import mx.com.hp.hpl.jena.query.core.DataSourceImpl;
import mx.com.hp.hpl.jena.query.core.DatasetGraph;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetFactory {
    private static Log log = LogFactory.getLog((Class)DatasetFactory.class);

    public static Dataset merge(List uriList) {
        return DatasetFactory.merge(uriList, null);
    }

    public static Dataset merge(List uriList, FileManager fileManager) {
        return DatasetFactory.create(uriList, null, fileManager, null);
    }

    public static DataSource create() {
        return new DataSourceImpl();
    }

    public static Dataset create(List uriList) {
        return DatasetFactory.create(uriList, null, null, null);
    }

    public static Dataset create(List uriList, FileManager fileManager) {
        return DatasetFactory.create(uriList, null, fileManager, null);
    }

    public static Dataset createNamed(List namedSourceList, FileManager fileManager) {
        return DatasetFactory.create(null, namedSourceList, fileManager, null);
    }

    public static Dataset create(List uriList, List namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null, null);
    }

    public static Dataset create(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        DatasetGraph dsg = DatasetFactory.createDatasetGraph(uriList, namedSourceList, fileManager, baseURI);
        return new DataSourceImpl(dsg);
    }

    public static DatasetGraph createDatasetGraph(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (uriList != null) {
            Model m = ModelFactory.createDefaultModel();
            Iterator iter = uriList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(unnamed): " + sourceURI));
                fileManager.readModel(m, sourceURI, absURI, null);
            }
            ds.setDefaultGraph(m.getGraph());
            ds.setActiveGraph(ds.getDefaultGraph());
        } else {
            ds.setDefaultGraph(ModelFactory.createDefaultModel().getGraph());
            ds.setActiveGraph(ds.getDefaultGraph());
        }
        if (namedSourceList != null) {
            Iterator iter = namedSourceList.iterator();
            while (iter.hasNext()) {
                String sourceURI = (String)iter.next();
                String absURI = null;
                absURI = baseURI != null ? RelURI.resolve(sourceURI, baseURI) : RelURI.resolve(sourceURI);
                log.debug((Object)("Load(named): " + sourceURI + " as " + absURI));
                Model m = fileManager.loadModel(sourceURI, absURI, null);
                ds.addNamedGraph(absURI, m.getGraph());
            }
        }
        return ds;
    }

    public static Dataset make(Dataset ds) {
        DataSourceImpl ds2 = new DataSourceImpl(ds);
        return ds2;
    }

    public static Dataset make(Dataset ds, Model defaultModel) {
        DataSourceImpl ds2 = new DataSourceImpl(ds);
        ds2.setDefaultModel(defaultModel);
        return ds2;
    }
}

