/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.QueryVisitor;
import mx.com.hp.hpl.jena.query.SortCondition;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.core.Element;
import mx.com.hp.hpl.jena.query.core.ElementBlock;
import mx.com.hp.hpl.jena.query.core.QueryCompare;
import mx.com.hp.hpl.jena.query.core.QueryHashCode;
import mx.com.hp.hpl.jena.query.core.Template;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.serializer.Serializer;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.util.IndentedLineBuffer;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log log = LogFactory.getLog((Class)Query.class);
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    List graphURIs = new ArrayList();
    List namedGraphURIs = new ArrayList();
    ElementBlock queryBlock = null;
    Syntax syntax = Syntax.syntaxSPARQL;
    public static long NOLIMIT = Long.MIN_VALUE;
    long resultLimit = NOLIMIT;
    long resultOffset = NOLIMIT;
    List orderBy = null;
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected List resultVars = new ArrayList();
    protected boolean distinct = false;
    protected Template constructTemplate = null;
    protected List resultNodes = new ArrayList();
    protected boolean seenBaseURI = false;
    protected String baseURI = null;
    protected PrefixMapping prefixMap = new PrefixMappingImpl();
    private boolean resultVarsSet = false;
    private int hashcode = -1;

    public Query() {
        this.syntax = Syntax.syntaxSPARQL;
    }

    public void setQueryType(int qType) {
        this.queryType = qType;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setStrict(boolean isStrict) {
        this.strictQuery = isStrict;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
    }

    private void initLax() {
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long limit) {
        this.resultLimit = limit;
    }

    public boolean hasLimit() {
        return this.resultLimit != NOLIMIT;
    }

    public long getOffset() {
        return this.resultOffset;
    }

    public void setOffset(long offset) {
        this.resultOffset = offset;
    }

    public boolean hasOffset() {
        return this.resultOffset != NOLIMIT;
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() > 0;
    }

    public void addOrderBy(SortCondition condition) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList();
        }
        this.orderBy.add(condition);
    }

    public void addOrderBy(Expr expr, int direction) {
        SortCondition sc = new SortCondition(expr, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(Node var, int direction) {
        if (!var.isVariable()) {
            throw new QueryException("Not a variable: " + var);
        }
        SortCondition sc = new SortCondition(var, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(String varName, int direction) {
        SortCondition sc = new SortCondition(varName, direction);
        this.addOrderBy(sc);
    }

    public List getOrderBy() {
        return this.orderBy;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public boolean isQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean isQueryStar) {
        this.queryResultStar = isQueryStar;
    }

    public void setQueryElement(Element elt) {
        if (this.queryBlock == null) {
            this.queryBlock = new ElementBlock(null, null);
        }
        this.queryBlock.setPatternElement(elt);
    }

    public void setQueryBlock(ElementBlock block) {
        this.queryBlock = block;
    }

    public ElementBlock getQueryBlock() {
        return this.queryBlock;
    }

    public void addGraphURI(String s) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList();
        }
        this.graphURIs.add(s);
    }

    public void addNamedGraphURI(String s) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        this.namedGraphURIs.add(s);
    }

    public List getGraphURIs() {
        return this.graphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean hasDatasetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String varName) {
        if (!this.resultVars.contains(varName)) {
            this.resultVars.add(varName);
        }
    }

    public void addResultVar(Node v) {
        if (!v.isVariable()) {
            throw new QueryException("Not a variable: " + v);
        }
        this.addResultVar(v.getName());
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI()) {
            this.addResultURIs(node);
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + FmtUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + FmtUtils.stringForNode(node));
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(Template templ) {
        this.constructTemplate = templ;
    }

    public List getResultURIs() {
        return this.resultNodes;
    }

    public void addResultURIs(Node node) {
        if (node.isLiteral()) {
            throw new QueryException("Result URI is a literal: " + FmtUtils.stringForNode(node));
        }
        if (!this.resultNodes.contains(node)) {
            this.resultNodes.add(node);
        }
    }

    public void setResultVars() {
        if (this.resultVarsSet) {
            return;
        }
        this.resultVarsSet = true;
        if (this.getQueryBlock() == null) {
            if (!this.isDescribeType()) {
                log.warn((Object)"setResultVars(): no query block");
            }
            return;
        }
        if (this.resultVars.size() != 0) {
            return;
        }
        if (this.isSelectType() && this.isQueryResultStar()) {
            this.findAndAddNamedVars();
        }
        if (this.isConstructType()) {
            this.findAndAddNamedVars();
        }
        if (this.isDescribeType() && this.isQueryResultStar()) {
            this.findAndAddNamedVars();
        }
    }

    private void findAndAddNamedVars() {
        Set queryVars = this.getQueryBlock().varsMentioned();
        Iterator iter = queryVars.iterator();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            char ch = varName.charAt(0);
            if (!Character.isLetter(ch)) continue;
            this.addResultVar(varName);
        }
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        this.seenBaseURI = true;
    }

    void initParserBaseURI() {
        this.initParserBaseURI(null);
    }

    void initParserBaseURI(String base) {
        if (this.baseURI != null) {
            return;
        }
        this.baseURI = RelURI.chooseBaseURI(base);
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            log.warn((Object)("Illegal prefix mapping(ignored): " + prefix + "=>" + expansion));
        }
    }

    public PrefixMapping getPrefixMap() {
        return this.getPrefixMapping();
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public String expandQName(String qname) {
        String s = this.prefixMap.expandPrefix(qname);
        if (s.equals(qname)) {
            return null;
        }
        return s;
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }

    public void visit(QueryVisitor visitor) {
        visitor.startVisit(this);
        visitor.visitResultForm(this);
        visitor.visitBase(this);
        visitor.visitPrefixes(this);
        if (this.isSelectType()) {
            visitor.visitSelectResultForm(this);
        }
        if (this.isConstructType()) {
            visitor.visitConstructResultForm(this);
        }
        if (this.isDescribeType()) {
            visitor.visitDescribeResultForm(this);
        }
        if (this.isAskType()) {
            visitor.visitAskResultForm(this);
        }
        visitor.visitDatasetDecl(this);
        visitor.visitQueryPattern(this);
        visitor.visitOrderBy(this);
        visitor.visitLimit(this);
        visitor.visitOffset(this);
        visitor.finishVisit(this);
    }

    public String toString() {
        return this.serialize();
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = QueryHashCode.calc(this);
            if (this.hashcode == -1) {
                this.hashcode = -1073741824;
            }
        }
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Query)) {
            return false;
        }
        return QueryCompare.equals(this, (Query)other);
    }

    public String serialize() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff);
        return buff.toString();
    }

    public void serialize(OutputStream out) {
        Serializer.serialize(this, out);
    }

    public void serialize(OutputStream out, Syntax syntax) {
        Serializer.serialize(this, out, syntax);
    }

    public void serialize(IndentedLineBuffer buff) {
        Serializer.serialize(this, buff);
    }

    public void serialize(IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(this, buff, outSyntax);
    }

    public void serialize(IndentedWriter writer) {
        Serializer.serialize(this, writer);
    }

    public void serialize(IndentedWriter writer, Syntax outSyntax) {
        Serializer.serialize(this, writer, outSyntax);
    }
}

