/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import java.util.List;
import mx.com.hp.hpl.jena.query.Dataset;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryExecution;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.core.DataSourceImpl;
import mx.com.hp.hpl.jena.query.engine.QueryEngineFactory;
import mx.com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import mx.com.hp.hpl.jena.query.engineHTTP.QueryEngineHTTP;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionFactory {
    private static Log log = LogFactory.getLog((Class)QueryExecutionFactory.class);

    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset);
    }

    public static QueryExecution create(Query query2, FileManager fm) {
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (fm != null) {
            qe.setFileManager(fm);
        }
        return qe;
    }

    public static QueryExecution create(Query query2, Model model) {
        return QueryExecutionFactory.make(query2, new DataSourceImpl(model));
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        return QueryExecutionFactory.create(query2, new DataSourceImpl(model), initialBinding);
    }

    public static QueryExecution create(Query query2, QuerySolution initialBinding) {
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution intialBinding) {
        QueryExecution qe = QueryExecutionFactory.make(query2, dataset);
        if (intialBinding != null) {
            qe.setInitialBinding(intialBinding);
        }
        return qe;
    }

    private static QueryExecution make(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    public static QueryExecution create(String service, Query query2) {
        return QueryExecutionFactory.make(service, query2);
    }

    public static QueryExecution create(String service, Query query2, String defaultGraph) {
        QueryEngineHTTP qe = QueryExecutionFactory.make(service, query2);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryExecution create(String service, Query query2, List defaultGraphURIs, List namedGraphURIs) {
        QueryEngineHTTP qe = QueryExecutionFactory.make(service, query2);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    private static QueryEngineHTTP make(String service, Query query2) {
        return new QueryEngineHTTP(service, query2);
    }

    private static QueryExecution make(Query query2, Dataset dataset) {
        QueryEngineFactory f = QueryEngineRegistry.get().find(query2, dataset);
        if (f == null) {
            log.warn((Object)("Failed to find a QueryEngineFactory for query: " + query2));
            return null;
        }
        return f.create(query2, dataset);
    }
}

