/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.lang.Parser;
import mx.com.hp.hpl.jena.util.FileManager;

public class QueryFactory {
    public static Query create(String queryString) {
        return QueryFactory.create(queryString, Syntax.defaultSyntax);
    }

    public static Query create(String queryString, Syntax langURI) {
        return QueryFactory.create(queryString, null, langURI);
    }

    public static Query create(String queryString, String baseURI, Syntax langURI) {
        Query query2 = new Query();
        QueryFactory.parse(query2, queryString, baseURI, langURI);
        return query2;
    }

    public static Query make() {
        return new Query();
    }

    public static Query parse(Query query2, String queryString, String baseURI, Syntax syntaxURI) {
        if (syntaxURI == null) {
            syntaxURI = query2.getSyntax();
        } else {
            query2.setSyntax(syntaxURI);
        }
        Parser parser = Parser.createParser(syntaxURI);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing: " + syntaxURI);
        }
        query2.initParserBaseURI(baseURI);
        return parser.parse(query2, queryString);
    }

    static boolean knownParserSyntax(Syntax syntaxURI) {
        Parser parser = Parser.createParser(syntaxURI);
        return parser != null;
    }

    public static Query read(String url) {
        return QueryFactory.read(url, null, null, null);
    }

    public static Query read(String url, String baseURI) {
        return QueryFactory.read(url, null, baseURI, null);
    }

    public static Query read(String url, String baseURI, Syntax langURI) {
        return QueryFactory.read(url, null, baseURI, langURI);
    }

    public static Query read(String url, FileManager filemanager, String baseURI, Syntax langURI) {
        if (filemanager == null) {
            filemanager = FileManager.get();
        }
        String qStr = filemanager.readWholeFileAsUTF8(url);
        if (baseURI == null) {
            baseURI = url;
        }
        if (langURI == null) {
            langURI = Syntax.guessQueryFileSyntax(url);
        }
        return QueryFactory.create(qStr, baseURI, langURI);
    }
}

