/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFormatter;
import mx.com.hp.hpl.jena.query.resultset.RDFInput;
import mx.com.hp.hpl.jena.query.resultset.ResultSetException;
import mx.com.hp.hpl.jena.query.resultset.ResultSetFormat;
import mx.com.hp.hpl.jena.query.resultset.ResultSetMem;
import mx.com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import mx.com.hp.hpl.jena.query.resultset.SortedResultSet;
import mx.com.hp.hpl.jena.query.resultset.XMLInputStAX;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.shared.NotFoundException;
import mx.com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetFactory {
    static Log log = LogFactory.getLog((Class)ResultSetFactory.class);

    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultSetFormat format) {
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            log.warn((Object)"Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            log.fatal((Object)"Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML)) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(filenameOrURI);
            }
            catch (FileNotFoundException ex) {
                throw new NotFoundException("File: " + filenameOrURI);
            }
            return ResultSetFactory.fromXML(in);
        }
        if (format.equals(ResultSetFormat.syntaxRDF)) {
            Model m = FileManager.get().loadModel(filenameOrURI);
            return ResultSetFactory.fromRDF(m);
        }
        log.warn((Object)("Unknown result set syntax: " + format));
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultSetFormat format) {
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            log.warn((Object)"Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            log.fatal((Object)"Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File: " + filenameOrURI);
            }
            ResultSet rs = ResultSetFactory.fromXML(in);
            return ResultSetFormatter.toModel(rs);
        }
        if (format.equals(ResultSetFormat.syntaxRDF)) {
            return FileManager.get().loadModel(filenameOrURI);
        }
        log.warn((Object)("Unknown result set syntax: " + format));
        return null;
    }

    public static ResultSet fromXML(InputStream in) {
        return XMLInputStAX.fromXML(in);
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        return new ResultSetMem(resultSet);
    }

    public static ResultSet makeSorted(ResultSet resultSet, List conditions) {
        return new SortedResultSet(resultSet, conditions);
    }

    public static ResultSetRewindable copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }
}

