/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.resultset.RDFOutput;
import mx.com.hp.hpl.jena.query.resultset.TextOutput;
import mx.com.hp.hpl.jena.query.resultset.XMLOutput;
import mx.com.hp.hpl.jena.query.resultset.XMLOutputASK;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.util.FileUtils;

public class ResultSetFormatter {
    public static void out(OutputStream out, ResultSet qresults) {
        TextOutput tFmt = new TextOutput((SerializationContext)null);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults, Query query2) {
        ResultSetFormatter.out(out, qresults, query2.getPrefixMapping());
    }

    public static void out(OutputStream out, ResultSet qresults, PrefixMapping pmap) {
        TextOutput tFmt = new TextOutput(pmap);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, boolean answer) {
        PrintWriter pw = FileUtils.asPrintWriterUTF8((OutputStream)out);
        if (answer) {
            pw.write("yes");
        } else {
            pw.write("no");
        }
        pw.flush();
    }

    public static int consume(ResultSet resultSet) {
        int count = 0;
        while (resultSet.hasNext()) {
            resultSet.nextSolution();
            ++count;
        }
        return count;
    }

    public static Model toModel(ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.toModel(resultSet);
    }

    public static Resource asRDF(Model model, ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, resultSet);
    }

    public static void outputAsRDF(OutputStream outStream, String format, ResultSet resultSet) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)outStream);
        ResultSetFormatter.outputAsRDF(out, format, resultSet);
        out.flush();
    }

    public static void outputAsRDF(PrintWriter out, String format, ResultSet resultSet) {
        Model m = ResultSetFormatter.toModel(resultSet);
        m.write((Writer)out, format);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, Query query2) {
        ResultSetFormatter.outputAsXML(outStream, qresults);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults) {
        XMLOutput xOut = new XMLOutput();
        xOut.format(outStream, qresults);
    }

    public static String asXMLString(ResultSet qresults) {
        XMLOutput xOut = new XMLOutput();
        return xOut.asString(qresults);
    }

    public static void outputAsXML(OutputStream outStream, boolean result) {
        XMLOutputASK fmt = new XMLOutputASK(outStream, null);
        fmt.exec(result);
    }
}

