/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprVisitor;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import mx.com.hp.hpl.jena.query.util.Utils;

public class SortCondition {
    public Expr expression = null;
    public Node variable = null;
    public int direction = 0;

    public SortCondition(Node var, int dir) {
        this.variable = var;
        this.direction = dir;
    }

    public SortCondition(Expr expr, int dir) {
        this.expression = expr;
        this.direction = dir;
    }

    public SortCondition(String varName, int dir) {
        this.variable = Node.createVariable((String)varName);
        this.direction = dir;
    }

    public void format(ExprVisitor fmt, IndentedWriter writer) {
        boolean doDirection;
        boolean explicitDirection = true;
        boolean bl = doDirection = this.direction != Query.ASCENDING ? true : explicitDirection;
        if (doDirection && this.direction == Query.ASCENDING) {
            writer.print("ASC(");
        }
        if (doDirection && this.direction == Query.DESCENDING) {
            writer.print("DESC(");
        }
        if (this.expression != null) {
            this.expression.visit(fmt);
        } else {
            writer.print(FmtUtils.stringForNode(this.variable));
        }
        if (doDirection) {
            writer.print(")");
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Expr getExpression() {
        return this.expression;
    }

    public Node getVariable() {
        return this.variable;
    }

    public int hashCode() {
        int x = this.getDirection();
        if (this.getExpression() != null) {
            x ^= this.getExpression().hashCode();
        }
        if (this.getVariable() != null) {
            x ^= this.getVariable().hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SortCondition)) {
            return false;
        }
        SortCondition sc = (SortCondition)other;
        if (sc.getDirection() != this.getDirection()) {
            return false;
        }
        if (!Utils.eq(this.getExpression(), sc.getExpression())) {
            return false;
        }
        return Utils.eq(this.getVariable(), sc.getVariable());
    }
}

