/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.core;

import java.util.Iterator;
import java.util.ListIterator;
import mx.com.hp.hpl.jena.query.core.Element;
import mx.com.hp.hpl.jena.query.core.ElementBlock;
import mx.com.hp.hpl.jena.query.core.ElementExtension;
import mx.com.hp.hpl.jena.query.core.ElementFilter;
import mx.com.hp.hpl.jena.query.core.ElementGroup;
import mx.com.hp.hpl.jena.query.core.ElementNamedGraph;
import mx.com.hp.hpl.jena.query.core.ElementOptional;
import mx.com.hp.hpl.jena.query.core.ElementTriplePattern;
import mx.com.hp.hpl.jena.query.core.ElementUnion;
import mx.com.hp.hpl.jena.query.core.ElementUnsaid;
import mx.com.hp.hpl.jena.query.core.ElementVisitor;

public class ElementWalker
implements ElementVisitor {
    ElementVisitor proc;

    public ElementWalker(ElementVisitor visitor) {
        this.proc = visitor;
    }

    public void walk(Element el) {
        el.visit(this);
    }

    public static void walk(Element el, ElementVisitor visitor) {
        new ElementWalker(visitor).walk(el);
    }

    public void visit(ElementTriplePattern el) {
        this.proc.visit(el);
    }

    public void visit(ElementBlock el) {
        if (el.getPatternElement() != null) {
            el.getPatternElement().visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementFilter el) {
        this.proc.visit(el);
    }

    public void visit(ElementUnion el) {
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element e2 = (Element)iter.next();
            e2.visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementGroup el) {
        Iterator iter = el.getElements().iterator();
        while (iter.hasNext()) {
            Element e2 = (Element)iter.next();
            e2.visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementOptional el) {
        if (el.getElement() != null) {
            el.getElement().visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementNamedGraph el) {
        if (el.getElement() != null) {
            el.getElement().visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementUnsaid el) {
        if (el.getElement() != null) {
            el.getElement().visit(this);
        }
        this.proc.visit(el);
    }

    public void visit(ElementExtension el) {
        this.proc.visit(el);
    }
}

