/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.core;

import java.util.List;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryVisitor;
import mx.com.hp.hpl.jena.query.core.ComparisonException;
import mx.com.hp.hpl.jena.query.util.Utils;

public class QueryCompare
implements QueryVisitor {
    private Query query2;
    private boolean result = true;
    public static boolean PrintMessages = false;

    public static boolean equals(Query query1, Query query2) {
        QueryCompare visitor = new QueryCompare(query1);
        try {
            query2.visit(visitor);
        }
        catch (ComparisonException ex) {
            return false;
        }
        return visitor.isTheSame();
    }

    public QueryCompare(Query query2) {
        this.query2 = query2;
    }

    public void startVisit(Query query1) {
    }

    public void visitResultForm(Query query1) {
        this.check("Query result form", query1.getQueryType() == this.query2.getQueryType());
    }

    public void visitBase(Query query1) {
        this.check("Base URIs", query1.getBaseURI(), this.query2.getBaseURI());
        this.check("Explicitly setting of base URIs", query1.explicitlySetBaseURI() == this.query2.explicitlySetBaseURI());
    }

    public void visitPrefixes(Query query1) {
        if (query1.getPrefixMapping() == null && this.query2.getPrefixMapping() == null) {
            return;
        }
        this.check("Prefixes", query1.getPrefixMapping().samePrefixMappingAs(this.query2.getPrefixMapping()));
    }

    public void visitSelectResultForm(Query query1) {
        this.check("Not both SELECT queries", this.query2.isSelectType());
        this.check("DISTINCT modifier", query1.isDistinct() == this.query2.isDistinct());
        this.check("SELECT *", query1.isQueryResultStar() == this.query2.isQueryResultStar());
        List v1 = query1.getResultVars();
        List v2 = this.query2.getResultVars();
        this.check("Result variables", query1.getResultVars(), this.query2.getResultVars());
    }

    public void visitConstructResultForm(Query query1) {
        this.check("Not both CONSTRUCT queries", this.query2.isConstructType());
        this.check("CONSTRUCT templates", query1.getConstructTemplate(), this.query2.getConstructTemplate());
    }

    public void visitDescribeResultForm(Query query1) {
        this.check("Not both DESCRIBE queries", this.query2.isConstructType());
        this.check("Result variables", query1.getResultVars(), this.query2.getResultVars());
        this.check("Result URIs", query1.getResultURIs(), this.query2.getResultURIs());
    }

    public void visitAskResultForm(Query query1) {
        this.check("Not both ASK queries", this.query2.isAskType());
    }

    public void visitDatasetDecl(Query query1) {
        this.check("Default graph URIs", query1.getGraphURIs(), this.query2.getGraphURIs());
        this.check("Named graph URIs", query1.getNamedGraphURIs(), this.query2.getNamedGraphURIs());
    }

    public void visitQueryPattern(Query query1) {
        this.check("Pattern", query1.getQueryBlock(), this.query2.getQueryBlock());
    }

    public void visitOrderBy(Query query1) {
        this.check("ORDER BY", query1.getOrderBy(), this.query2.getOrderBy());
    }

    public void visitLimit(Query query1) {
        this.check("LIMIT", query1.getLimit() == this.query2.getLimit());
    }

    public void visitOffset(Query query1) {
        this.check("OFFSET", query1.getOffset() == this.query2.getOffset());
    }

    public void finishVisit(Query query1) {
    }

    private void check(String msg, Object obj1, Object obj2) {
        this.check(msg, Utils.eq(obj1, obj2));
    }

    private void check(String msg, boolean b) {
        if (!b) {
            if (PrintMessages && msg != null) {
                System.out.println("Different: " + msg);
            }
            this.result = false;
            throw new ComparisonException(msg);
        }
    }

    public boolean isTheSame() {
        return this.result;
    }
}

