/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.core;

import java.util.Collection;
import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.util.NodeUtils;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;

public class ResultBinding
implements QuerySolution {
    Collection causalTriples = null;
    Binding binding;
    Model model;

    public ResultBinding(Model _model, Binding _binding) {
        this.model = _model;
        this.binding = _binding;
    }

    public ResultBinding(Model _model) {
        this.model = _model;
        this.binding = new BindingMap();
    }

    public RDFNode get(String varName) {
        Node n = this.getNode(varName);
        if (n == null) {
            return null;
        }
        return NodeUtils.convertGraphNodeToRDFNode(n, this.model);
    }

    public Resource getResource(String varName) {
        return (Resource)this.get(varName);
    }

    public Literal getLiteral(String varName) {
        return (Literal)this.get(varName);
    }

    public Node getNode(String varName) {
        return this.binding.get(varName);
    }

    public boolean contains(String varName) {
        return this.binding.contains(varName);
    }

    public Iterator varNames() {
        return this.binding.names();
    }

    public void add(String varName, RDFNode rdfNode) {
        this.binding.add(varName, rdfNode.asNode());
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setModel(Model m) {
        this.model = m;
    }

    public Model getModel() {
        return this.model;
    }

    public String toString() {
        if (this.binding == null) {
            return "<no binding>";
        }
        return this.binding.toString();
    }

    public static boolean same(ResultBinding rb1, ResultBinding rb2) {
        return Binding.same(rb1.getBinding(), rb2.getBinding());
    }
}

