/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.core;

import java.util.Collection;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.Template;
import mx.com.hp.hpl.jena.query.core.TemplateVisitor;
import mx.com.hp.hpl.jena.query.engine1.QueryEngineUtils;

public class TemplateTriple
extends Template {
    Triple triple;

    public TemplateTriple(Node s, Node p, Node o) {
        this.triple = new Triple(s, p, o);
    }

    public TemplateTriple(Triple t) {
        this.triple = t;
    }

    public Triple getTriple() {
        return this.triple;
    }

    public void subst(Collection acc, Map bNodeMap, Binding b) {
        Node s = this.triple.getSubject();
        Node p = this.triple.getPredicate();
        Node o = this.triple.getObject();
        if (s.isBlank()) {
            s = this.newBlank(s, bNodeMap);
        }
        if (p.isBlank()) {
            p = this.newBlank(p, bNodeMap);
        }
        if (o.isBlank()) {
            o = this.newBlank(o, bNodeMap);
        }
        Triple t = new Triple(s, p, o);
        Triple t2 = QueryEngineUtils.substituteIntoTriple(t, b);
        acc.add(t2);
    }

    public int hashCode() {
        return this.triple.hashCode();
    }

    public boolean equals(Object temp2) {
        if (temp2 == null) {
            return false;
        }
        if (!(temp2 instanceof TemplateTriple)) {
            return false;
        }
        TemplateTriple tt2 = (TemplateTriple)temp2;
        return this.getTriple().equals((Object)tt2.getTriple());
    }

    public void visit(TemplateVisitor visitor) {
        visitor.visit(this);
    }

    private Node newBlank(Node n, Map bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return (Node)bNodeMap.get(n);
    }
}

